/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference;

import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.ModuleVersion;

public final class Reference {
    private ModuleVersion moduleVersion;
    private ArtifactGroupId artifactGroupId;
    private ArtifactVersion artifactVersion;
    private Object implData;

    public Reference(ModuleVersion moduleVersion, ArtifactGroupId artifactGroupId, ArtifactVersion artifactVersion, Object implData) {
        this.moduleVersion = moduleVersion;
        this.artifactGroupId = artifactGroupId;
        this.artifactVersion = artifactVersion;
        this.implData = implData;
    }

    public Reference(ModuleVersion moduleVersion, ArtifactGroupId artifactGroupId, ArtifactVersion artifactVersion) {
        this.moduleVersion = moduleVersion;
        this.artifactGroupId = artifactGroupId;
        this.artifactVersion = artifactVersion;
    }

    public Reference(ModuleVersion moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    public ModuleVersion getModuleVersion() {
        return this.moduleVersion;
    }

    public ArtifactGroupId getArtifactGroupId() {
        return this.artifactGroupId;
    }

    public ArtifactVersion getArtifactVersion() {
        return this.artifactVersion;
    }

    public Object getImplData() {
        return this.implData;
    }

    public String toString() {
        String stringImplData;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.implData != null && (stringImplData = this.implData.toString()) != null && stringImplData.length() != 0) {
            stringBuilder.append("[").append(stringImplData).append("] ");
        }
        if (this.moduleVersion != null) {
            stringBuilder.append(this.moduleVersion);
            if (this.artifactGroupId != null) {
                stringBuilder.append(" (").append(this.artifactGroupId).append(":").append(this.artifactVersion).append(")");
            }
        } else {
            stringBuilder.append(this.artifactGroupId).append(":").append(this.artifactVersion);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moduleVersion == null ? 0 : this.moduleVersion.hashCode());
        result = 31 * result + (this.artifactGroupId == null ? 0 : this.artifactGroupId.hashCode());
        result = 31 * result + (this.artifactVersion == null ? 0 : this.artifactVersion.hashCode());
        result = 31 * result + (this.implData == null ? 0 : this.implData.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Reference)) {
            return false;
        }
        Reference referenceOther = (Reference)other;
        if (this.artifactGroupId == null ? referenceOther.artifactGroupId != null : !this.artifactGroupId.equals(referenceOther.artifactGroupId)) {
            return false;
        }
        if (this.artifactVersion == null ? referenceOther.artifactVersion != null : !this.artifactVersion.equals(referenceOther.artifactVersion)) {
            return false;
        }
        if (this.moduleVersion == null ? referenceOther.moduleVersion != null : !this.moduleVersion.equals(referenceOther.moduleVersion)) {
            return false;
        }
        return !(this.implData == null ? referenceOther.implData != null : !this.implData.equals(referenceOther.implData));
    }

    public boolean equalsNoVersion(Reference referenceOther) {
        if (this == referenceOther) {
            return true;
        }
        if (this.artifactGroupId == null ? referenceOther.artifactGroupId != null : !this.artifactGroupId.equals(referenceOther.artifactGroupId)) {
            return false;
        }
        if (this.moduleVersion == null ? referenceOther.moduleVersion != null : !this.moduleVersion.getNodePath().equals(referenceOther.moduleVersion.getNodePath())) {
            return false;
        }
        return !(this.implData == null ? referenceOther.implData != null : !this.implData.equals(referenceOther.implData));
    }
}

