/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.plugin.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Stack;
import org.apache.commons.lang.WordUtils;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserInteractionCallbackPluginImpl
implements UserInteractionCallbackPlugin {
    private static final Logger logger = LoggerFactory.getLogger(DefaultUserInteractionCallbackPluginImpl.class);
    private static final String RUNTIME_PROPERTY_IND_BATCH_MODE = "IND_BATCH_MODE";
    private static final String RUNTIME_PROPERTY_BRACKET_INDENT = "BRACKET_INDENT";
    private static final String RUNTIME_PROPERTY_IND_PASSWORD_INPUT_NORMAL = "IND_PASSWORD_INPUT_NORMAL";
    private static final String RUNTIME_PROPERTY_IND_ECHO_INFO = "IND_ECHO_INFO";
    private static final int DEFAULT_BRACKET_INDENT = 4;
    private static final String RUNTIME_PROPERTY_WRAP_MODE = "WRAP_MODE";
    private static final String RUNTIME_PROPERTY_WRAP_WIDTH = "WRAP_WIDTH";
    private static final int DEFAULT_WRAP_WIDTH = 132;
    boolean indBatchMode;
    int bracketIndent;
    char[] arrayCharBracketIndent;
    private WrapMode wrapMode;
    private int wrapWidth;
    private Stack<UserInteractionCallbackPlugin.BracketHandle> stackBracketHandle;
    WriterInfo writerInfoActive;
    BufferedReader bufferedReaderStdin = new BufferedReader(new InputStreamReader(System.in));

    public DefaultUserInteractionCallbackPluginImpl(ExecContext execContext) {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        this.indBatchMode = Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_BATCH_MODE));
        String runtimeProperty = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_BRACKET_INDENT);
        this.bracketIndent = runtimeProperty == null ? 4 : Integer.parseInt(runtimeProperty);
        this.arrayCharBracketIndent = new char[this.bracketIndent];
        Arrays.fill(this.arrayCharBracketIndent, ' ');
        this.stackBracketHandle = new Stack();
        runtimeProperty = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_WRAP_MODE);
        if (runtimeProperty != null) {
            this.wrapMode = WrapMode.valueOf(runtimeProperty);
            runtimeProperty = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_WRAP_WIDTH);
            this.wrapWidth = runtimeProperty == null ? 132 : Integer.parseInt(runtimeProperty);
        } else {
            this.wrapMode = WrapMode.NO_WRAP;
        }
    }

    public UserInteractionCallbackPlugin.BracketHandle startBracket(String info) {
        BracketHandleImpl bracketHandle = new BracketHandleImpl();
        this.stackBracketHandle.push(bracketHandle);
        this.provideInfo(info);
        return bracketHandle;
    }

    public void provideInfo(String info) {
        if (this.writerInfoActive != null) {
            throw new RuntimeException("A WriterInfo is already active and has not been closed.");
        }
        System.out.println();
        this.printWithIndent(info);
        logger.info("Information provided to user: " + info);
    }

    public Writer provideInfoWithWriter(String info) {
        this.provideInfo(info);
        return new WriterInfo(new OutputStreamWriter(System.out));
    }

    public String getInfo(String prompt) {
        String info;
        if (this.writerInfoActive != null) {
            throw new RuntimeException("A WriterInfo is already active and has not been closed.");
        }
        this.validateBatchMode(prompt);
        System.out.println();
        System.out.println();
        this.printWithIndent("##### Information request #####");
        this.printWithIndent(prompt);
        logger.info("Information requested from user: " + prompt);
        try {
            info = this.bufferedReaderStdin.readLine();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (info == null) {
            throw new RuntimeException("Unexpected end of stream reading from stdin.");
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_ECHO_INFO))) {
            System.out.println("Information returned by user: " + info);
        }
        System.out.println();
        logger.info("Information returned by user: " + info);
        return info;
    }

    public String getInfoPassword(String prompt) {
        Console console = System.console();
        if (console == null) {
            return this.getInfo(prompt);
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_PASSWORD_INPUT_NORMAL))) {
            return this.getInfo(prompt);
        }
        if (this.writerInfoActive != null) {
            throw new RuntimeException("A WriterInfo is already active and has not been closed.");
        }
        this.validateBatchMode(prompt);
        System.out.println();
        System.out.println();
        this.printWithIndent("##### Information request #####");
        this.printWithIndent(prompt);
        logger.info("Information requested from user: " + prompt);
        char[] arrayCharInfo = console.readPassword();
        if (arrayCharInfo == null) {
            throw new RuntimeException("Unexpected end of stream reading from stdin.");
        }
        String info = new String(arrayCharInfo);
        System.out.println();
        return info;
    }

    public String getInfoWithDefault(String prompt, String defaultValue) {
        String info;
        if (this.writerInfoActive != null) {
            throw new RuntimeException("A WriterInfo is already active and has not been closed.");
        }
        this.validateBatchMode(prompt);
        System.out.println();
        System.out.println();
        this.printWithIndent("##### Information request #####");
        this.printWithIndent(prompt);
        logger.info("Information requested from user: " + prompt);
        try {
            info = this.bufferedReaderStdin.readLine();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        if (info == null) {
            throw new RuntimeException("Unexpected end of stream reading from stdin.");
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_IND_ECHO_INFO))) {
            System.out.println("Information returned by user: " + info);
        }
        System.out.println();
        if (info.length() == 0) {
            logger.info("Information returned by default: " + info);
            return defaultValue;
        }
        logger.info("Information returned by user: " + info);
        return info;
    }

    private void validateBatchMode(String message) {
        if (this.indBatchMode) {
            throw new RuntimeExceptionUserError("Information is requested and batch mode is endabled. Information request message: " + message);
        }
    }

    private void printWithIndent(String string) {
        String[] arrayLine = null;
        switch (this.wrapMode) {
            case NO_WRAP: {
                break;
            }
            case WRAP_WITH_INDENT: {
                string = WordUtils.wrap((String)string, (int)(this.wrapWidth - this.stackBracketHandle.size() * this.bracketIndent), (String)"\n", (boolean)false);
                break;
            }
            case WRAP_WITHOUT_INDENT: {
                string = WordUtils.wrap((String)string, (int)this.wrapWidth, (String)"\n", (boolean)false);
            }
        }
        arrayLine = string.split("\n");
        for (int i = 0; i < arrayLine.length; ++i) {
            for (int j = 0; j < this.stackBracketHandle.size(); ++j) {
                System.out.print(this.arrayCharBracketIndent);
            }
            System.out.println(arrayLine[i]);
        }
    }

    public boolean isBatchMode() {
        return this.indBatchMode;
    }

    private class WriterInfo
    extends BufferedWriter {
        boolean indClosed;

        public WriterInfo(Writer writer) {
            super(writer);
        }

        @Override
        public void close() throws IOException {
            super.flush();
            if (!this.indClosed) {
                this.indClosed = true;
                DefaultUserInteractionCallbackPluginImpl.this.writerInfoActive = null;
            }
        }

        @Override
        public void write(int c) throws IOException {
            if (this.indClosed) {
                throw new RuntimeException("WriterInfo already closed.");
            }
            super.write(c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.indClosed) {
                throw new RuntimeException("WriterInfo already closed.");
            }
            super.write(cbuf, off, len);
        }

        @Override
        public void write(String s, int off, int len) throws IOException {
            if (this.indClosed) {
                throw new RuntimeException("WriterInfo already closed.");
            }
            super.write(s, off, len);
        }

        @Override
        public void newLine() throws IOException {
            if (this.indClosed) {
                throw new RuntimeException("WriterInfo already closed.");
            }
            super.newLine();
        }

        @Override
        public void flush() throws IOException {
            if (this.indClosed) {
                throw new RuntimeException("WriterInfo already closed.");
            }
            super.flush();
        }
    }

    private class BracketHandleImpl
    implements UserInteractionCallbackPlugin.BracketHandle {
        private BracketHandleImpl() {
        }

        public void close() {
            if (DefaultUserInteractionCallbackPluginImpl.this.stackBracketHandle.pop() != this) {
                throw new RuntimeException("Incorrect bracketing.");
            }
        }
    }

    private static enum WrapMode {
        NO_WRAP,
        WRAP_WITH_INDENT,
        WRAP_WITHOUT_INDENT;

    }
}

