/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.plugin.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.io.FileUtils;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.ExecContextPluginFactory;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.ToolLifeCycleExecContextPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirSystemModule;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.plugin.impl.MapWorkspaceDirPathXmlAdapter;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainModuleVersionWorkspacePluginFactory
implements ExecContextPluginFactory<WorkspacePlugin> {
    private static final Logger logger = LoggerFactory.getLogger(MainModuleVersionWorkspacePluginFactory.class);
    private static final String RUNTIME_PROPERTY_MAIN_MODULE_VERSION = "MAIN_MODULE_VERSION";
    private static final String EXEC_CONTEXT_PROPERTY_MAIN_MODULE_VERSION = "MAIN_MODULE_VERSION";
    private static final String WORKSPACE_LOCKED_INDICATOR_FILE = ".lock";
    private static final String WORKSPACE_FORMAT = "main-module-version";
    private static final String WORKSPACE_VERSION = "1.0";
    private static final String WORKSPACE_METADATA_FILE = "workspace-metadata.xml";
    private static final String MSG_PATTERN_KEY_WORKSPACE_LOCKED = "WORKSPACE_LOCKED";
    private static final String MSG_PATTERN_KEY_SYSTEM_WORKSPACE_DIRECTORY_CONFLICT = "SYSTEM_WORKSPACE_DIRECTORY_CONFLICT";
    private static final String MSG_PATTERN_KEY_MAIN_MODULE_VERSION_NOT_SPECIFIED = "MAIN_MODULE_VERSION_NOT_SPECIFIED";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(MainModuleVersionWorkspacePluginFactory.class.getName() + "ResourceBundle");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WorkspacePlugin getExecContextPlugin(ExecContext execContext) {
        boolean indWorkspaceInit;
        ModuleVersion moduleVersionMain = null;
        if (!(execContext instanceof WorkspaceExecContext)) {
            throw new RuntimeException("An execution context supporting the concept of workspace directory is required.");
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        String stringMainModuleVersion = runtimePropertiesPlugin.getProperty(null, "MAIN_MODULE_VERSION");
        if (stringMainModuleVersion != null) {
            try {
                moduleVersionMain = ModuleVersion.parse((String)stringMainModuleVersion);
            }
            catch (ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
        }
        WorkspaceExecContext workspaceExecContext = (WorkspaceExecContext)execContext;
        Path pathWorkspace = workspaceExecContext.getPathWorkspaceDir();
        Path pathDragomMetadataDir = workspaceExecContext.getPathMetadataDir();
        WorkspaceExecContext.WorkspaceFormatVersion workspaceFormatVersion = workspaceExecContext.getWorkspaceFormatVersion();
        if (workspaceFormatVersion == null) {
            if (stringMainModuleVersion == null) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MAIN_MODULE_VERSION_NOT_SPECIFIED), pathWorkspace));
            }
            workspaceExecContext.setWorkspaceFormatVersion(new WorkspaceExecContext.WorkspaceFormatVersion(WORKSPACE_FORMAT, WORKSPACE_VERSION));
            indWorkspaceInit = false;
        } else {
            if (!workspaceFormatVersion.format.equals(WORKSPACE_FORMAT)) throw new RuntimeException("Unsupported workspace format version " + workspaceFormatVersion + ". + Only format version " + new WorkspaceExecContext.WorkspaceFormatVersion(WORKSPACE_FORMAT, WORKSPACE_VERSION) + " is supported by this WorkspacePlugin factory.");
            if (!workspaceFormatVersion.version.equals(WORKSPACE_VERSION)) {
                throw new RuntimeException("Unsupported workspace format version " + workspaceFormatVersion + ". + Only format version " + new WorkspaceExecContext.WorkspaceFormatVersion(WORKSPACE_FORMAT, WORKSPACE_VERSION) + " is supported by this WorkspacePlugin factory.");
            }
            stringMainModuleVersion = execContext.getProperty("MAIN_MODULE_VERSION");
            if (moduleVersionMain != null) {
                if (!moduleVersionMain.equals((Object)new ModuleVersion(stringMainModuleVersion))) {
                    throw new RuntimeException("Main ModuleVersion specified as a runtime property " + moduleVersionMain + " differs from main ModuleVersion persisted within ExecContext " + stringMainModuleVersion + '.');
                }
            } else {
                moduleVersionMain = new ModuleVersion(stringMainModuleVersion);
            }
            indWorkspaceInit = true;
        }
        DefaultWorkspaceImpl defaultWorkspaceImpl = null;
        if (!indWorkspaceInit) return new DefaultWorkspaceImpl(pathWorkspace, pathDragomMetadataDir, moduleVersionMain);
        try {
            File fileWorkspaceMetadata = pathDragomMetadataDir.resolve(WORKSPACE_METADATA_FILE).toFile();
            if (!fileWorkspaceMetadata.exists()) return defaultWorkspaceImpl;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DefaultWorkspaceImpl.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setAdapter(MapWorkspaceDirPathXmlAdapter.class, (XmlAdapter)new MapWorkspaceDirPathXmlAdapter(pathWorkspace));
            defaultWorkspaceImpl = (DefaultWorkspaceImpl)unmarshaller.unmarshal(fileWorkspaceMetadata);
            defaultWorkspaceImpl.pathWorkspace = pathWorkspace;
            defaultWorkspaceImpl.pathDragomMetadataDir = pathDragomMetadataDir;
            defaultWorkspaceImpl.moduleVersionMain = moduleVersionMain;
            return defaultWorkspaceImpl;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlRootElement(name="workspace-default-impl")
    private static class DefaultWorkspaceImpl
    implements WorkspacePlugin,
    ToolLifeCycleExecContextPlugin {
        private Path pathWorkspace;
        private Path pathDragomMetadataDir;
        private ModuleVersion moduleVersionMain;
        @XmlElement(name="workspace-dirs", type=MapWorkspaceDirPathXmlAdapter.ListWorkspaceDirPath.class)
        @XmlJavaTypeAdapter(value=MapWorkspaceDirPathXmlAdapter.class)
        private Map<WorkspaceDir, Path> mapWorkspaceDirPath = new HashMap<WorkspaceDir, Path>();
        private Map<Path, WorkspaceDir> mapPathWorkspaceDir = new HashMap<Path, WorkspaceDir>();
        private Map<WorkspaceDir, Integer> mapWorkspaceDirAccessMode = new HashMap<WorkspaceDir, Integer>();

        public DefaultWorkspaceImpl() {
        }

        public DefaultWorkspaceImpl(Path pathWorkspace, Path pathDragomMetadataDir, ModuleVersion moduleVersionMain) {
            this();
            this.pathWorkspace = pathWorkspace;
            this.pathDragomMetadataDir = pathDragomMetadataDir;
            this.moduleVersionMain = moduleVersionMain;
            this.save();
        }

        private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
            for (Map.Entry<WorkspaceDir, Path> mapEntry : this.mapWorkspaceDirPath.entrySet()) {
                if (mapEntry.getKey() instanceof WorkspaceDirUserModuleVersion) {
                    throw new RuntimeException("Unexpected WorkspaceDirUserModuleVersion " + mapEntry.getValue() + '.');
                }
                this.mapPathWorkspaceDir.put(mapEntry.getValue(), mapEntry.getKey());
            }
        }

        private void save() {
            try {
                File fileWorkspaceMetadata = this.pathDragomMetadataDir.resolve(MainModuleVersionWorkspacePluginFactory.WORKSPACE_METADATA_FILE).toFile();
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DefaultWorkspaceImpl.class});
                Marshaller marshaller = jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setAdapter(MapWorkspaceDirPathXmlAdapter.class, (XmlAdapter)new MapWorkspaceDirPathXmlAdapter(this.pathWorkspace));
                marshaller.marshal((Object)this, fileWorkspaceMetadata);
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
        }

        public Path getPathWorkspace() {
            return this.pathWorkspace;
        }

        public boolean isSupportMultipleModuleVersion() {
            return false;
        }

        public WorkspaceDir getWorkspaceDirConflict(WorkspaceDir workspaceDir) {
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                if (((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().equals((Object)this.moduleVersionMain)) {
                    return null;
                }
                return new WorkspaceDirUserModuleVersion(this.moduleVersionMain);
            }
            Path pathWorkspaceDir = this.pathDragomMetadataDir.resolve(((WorkspaceDirSystemModule)workspaceDir).getNodePath().getModuleName());
            WorkspaceDir workspaceDirOther = this.mapPathWorkspaceDir.get(pathWorkspaceDir);
            if (workspaceDirOther != null && !workspaceDirOther.equals(workspaceDir)) {
                return workspaceDirOther;
            }
            return null;
        }

        public boolean isWorkspaceDirExist(WorkspaceDir workspaceDir) {
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                return ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().equals((Object)this.moduleVersionMain);
            }
            return this.mapWorkspaceDirPath.containsKey(workspaceDir);
        }

        public Path getWorkspaceDir(WorkspaceDir workspaceDir, EnumSet<WorkspacePlugin.GetWorkspaceDirMode> enumSetGetWorkspaceDirMode, WorkspacePlugin.WorkspaceDirAccessMode workspaceDirAccessMode) {
            Path path;
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion && !((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().equals((Object)this.moduleVersionMain)) {
                throw new RuntimeException("Request for WorkspaceDirUserModuleVersion " + workspaceDir + " which does not correspond to main ModuleVersion of workspace " + this.moduleVersionMain + '.');
            }
            if (workspaceDirAccessMode != WorkspacePlugin.WorkspaceDirAccessMode.PEEK) {
                Integer readCount = this.mapWorkspaceDirAccessMode.get(workspaceDir);
                if (readCount != null) {
                    if (readCount == 0) {
                        throw new RuntimeException("Workspace directory " + workspaceDir + " already accessed for writing (and new acces is " + workspaceDirAccessMode + ").");
                    }
                    if (workspaceDirAccessMode == WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE) {
                        throw new RuntimeException("New access is for writing and workspace directory " + workspaceDir + " already accessed for reading (with level " + readCount + ").");
                    }
                    this.mapWorkspaceDirAccessMode.put(workspaceDir, readCount + 1);
                } else if (workspaceDirAccessMode == WorkspacePlugin.WorkspaceDirAccessMode.READ) {
                    this.mapWorkspaceDirAccessMode.put(workspaceDir, 1);
                } else {
                    this.mapWorkspaceDirAccessMode.put(workspaceDir, 0);
                }
            }
            if ((path = this.mapWorkspaceDirPath.get(workspaceDir)) == null && enumSetGetWorkspaceDirMode.contains(WorkspacePlugin.GetWorkspaceDirMode.MUST_EXIST)) {
                throw new RuntimeException("WorkspacePlugin directory " + workspaceDir + " does not exist and is assumed to exist.");
            }
            if (path != null && enumSetGetWorkspaceDirMode.contains(WorkspacePlugin.GetWorkspaceDirMode.MUST_NOT_EXIST)) {
                throw new RuntimeException("WorkspacePlugin directory " + workspaceDir + " exists and mapped to " + path + " but is assumed to not exist.");
            }
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                return this.pathWorkspace;
            }
            if (workspaceDir instanceof WorkspaceDirSystemModule) {
                path = this.getWorkspaceDirSystemModule((WorkspaceDirSystemModule)workspaceDir, enumSetGetWorkspaceDirMode);
                if (!(path == null || path.toFile().isDirectory() || enumSetGetWorkspaceDirMode.contains(WorkspacePlugin.GetWorkspaceDirMode.DO_NOT_CREATE_PATH) || path.toFile().mkdir())) {
                    throw new RuntimeException("The path " + path + " could not be created for an unknown reason.");
                }
                return path;
            }
            throw new RuntimeException("Unknown WorkspaceDir class " + workspaceDir.getClass().getName() + '.');
        }

        private Path getWorkspaceDirSystemModule(WorkspaceDirSystemModule workspaceDirSystemModule, EnumSet<WorkspacePlugin.GetWorkspaceDirMode> enumSetGetWorkspaceDirMode) {
            Path path = this.mapWorkspaceDirPath.get(workspaceDirSystemModule);
            if (path == null && enumSetGetWorkspaceDirMode.contains(WorkspacePlugin.GetWorkspaceDirMode.CREATE_IF_NOT_EXIST)) {
                path = this.pathDragomMetadataDir.resolve(workspaceDirSystemModule.getNodePath().getModuleName());
                WorkspaceDir workspaceDirOther = this.mapPathWorkspaceDir.get(path);
                if (workspaceDirOther != null) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MainModuleVersionWorkspacePluginFactory.MSG_PATTERN_KEY_SYSTEM_WORKSPACE_DIRECTORY_CONFLICT), workspaceDirSystemModule, path, workspaceDirOther));
                }
                logger.info("Path " + path + " is created for " + workspaceDirSystemModule + '.');
                if (path.toFile().isDirectory()) {
                    throw new RuntimeException("The path " + path + " for workspace directory for " + workspaceDirSystemModule + " already exists but is unknown to the workspace.");
                }
                this.mapWorkspaceDirPath.put((WorkspaceDir)workspaceDirSystemModule, path);
                this.mapPathWorkspaceDir.put(path, (WorkspaceDir)workspaceDirSystemModule);
                this.save();
            } else if (path != null && enumSetGetWorkspaceDirMode.contains(WorkspacePlugin.GetWorkspaceDirMode.RESET_IF_EXIST)) {
                logger.info("Existing path " + path + " is reset (deleted and recreated empty) for " + workspaceDirSystemModule + '.');
                try {
                    FileUtils.deleteDirectory((File)path.toFile());
                }
                catch (IOException ioe) {
                    throw new RuntimeException("IOException raised while trying to delete the workspace directory " + path + ": " + ioe);
                }
            }
            return path;
        }

        public void releaseWorkspaceDir(Path pathWorkspaceDir) {
            Object workspaceDir = pathWorkspaceDir.equals(this.pathWorkspace) ? new WorkspaceDirUserModuleVersion(this.moduleVersionMain) : this.mapPathWorkspaceDir.get(pathWorkspaceDir);
            if (workspaceDir == null) {
                throw new RuntimeException("The path " + pathWorkspaceDir + " does not correspond to a workspace directory.");
            }
            Integer readCount = this.mapWorkspaceDirAccessMode.get(workspaceDir);
            if (readCount == null) {
                throw new RuntimeException("Workspace directory " + workspaceDir + " is not accessed.");
            }
            if (readCount == 0 || readCount == 1) {
                this.mapWorkspaceDirAccessMode.remove(workspaceDir);
            } else {
                this.mapWorkspaceDirAccessMode.put((WorkspaceDir)workspaceDir, readCount - 1);
            }
        }

        public WorkspacePlugin.WorkspaceDirAccessMode getWorkspaceDirAccessMode(Path pathWorkspaceDir) {
            Object workspaceDir = pathWorkspaceDir.equals(this.pathWorkspace) ? new WorkspaceDirUserModuleVersion(this.moduleVersionMain) : this.mapPathWorkspaceDir.get(pathWorkspaceDir);
            if (workspaceDir == null) {
                throw new RuntimeException("The path " + pathWorkspaceDir + " does not correspond to a workspace directory.");
            }
            Integer readCount = this.mapWorkspaceDirAccessMode.get(workspaceDir);
            if (readCount == null) {
                return WorkspacePlugin.WorkspaceDirAccessMode.PEEK;
            }
            if (readCount >= 1) {
                return WorkspacePlugin.WorkspaceDirAccessMode.READ;
            }
            return WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE;
        }

        public void updateWorkspaceDir(WorkspaceDir workspaceDir, WorkspaceDir workspaceDirNew) {
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                throw new RuntimeException("Request for updating WorkspaceDirUserModuleVersion " + workspaceDir + " but only one WorkspaceDirUserModuleVersion is allowed and it cannot be updated.");
            }
            Integer readCount = this.mapWorkspaceDirAccessMode.get(workspaceDir);
            if (readCount == null || readCount != 0) {
                throw new RuntimeException("Workspace directory " + workspaceDir + " must be accessed for writing to update it.");
            }
            Path path = this.mapWorkspaceDirPath.get(workspaceDir);
            if (path == null) {
                throw new RuntimeException("No entry exists for workspace directory " + workspaceDir + '.');
            }
            if (workspaceDir instanceof WorkspaceDirSystemModule) {
                if (!(workspaceDirNew instanceof WorkspaceDirSystemModule)) {
                    throw new RuntimeException("New workspace directory " + workspaceDir + " must be of the same type as original one " + workspaceDirNew + '.');
                }
                if (!((WorkspaceDirSystemModule)workspaceDir).getNodePath().equals((Object)((WorkspaceDirSystemModule)workspaceDirNew).getNodePath())) {
                    throw new RuntimeException("New workspace directory " + workspaceDirNew + " must refer to the same module node path as original workspace directory " + workspaceDir + '.');
                }
            } else {
                throw new RuntimeException("Invalid workspace directory type " + workspaceDir + '.');
            }
        }

        public void deleteWorkspaceDir(WorkspaceDir workspaceDir) {
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                throw new RuntimeException("Request for deleting WorkspaceDirUserModuleVersion " + workspaceDir + " but only one WorkspaceDirUserModuleVersion is allowed and it cannot be deleted.");
            }
            Integer readCount = this.mapWorkspaceDirAccessMode.get(workspaceDir);
            if (readCount == null || readCount != 0) {
                throw new RuntimeException("Workspace directory " + workspaceDir + " must be accessed for writing to delete it.");
            }
            Path path = this.mapWorkspaceDirPath.get(workspaceDir);
            if (path != null) {
                try {
                    FileUtils.deleteDirectory((File)path.toFile());
                }
                catch (IOException ioe) {
                    throw new RuntimeException("IOException raised while trying to delete the workspace directory " + path + ": " + ioe);
                }
                this.mapWorkspaceDirPath.remove(workspaceDir);
                this.mapPathWorkspaceDir.remove(path);
                this.save();
                this.mapWorkspaceDirAccessMode.put(workspaceDir, null);
            }
        }

        public Set<WorkspaceDir> getSetWorkspaceDir(Class<? extends WorkspaceDir> workspaceDirClass) {
            if (workspaceDirClass == WorkspaceDirUserModuleVersion.class) {
                HashSet<WorkspaceDir> setWorkspaceDir = new HashSet<WorkspaceDir>();
                setWorkspaceDir.add((WorkspaceDir)new WorkspaceDirUserModuleVersion(this.moduleVersionMain));
                return setWorkspaceDir;
            }
            HashSet<WorkspaceDir> setWorkspaceDir = new HashSet<WorkspaceDir>(this.mapWorkspaceDirPath.keySet());
            if (workspaceDirClass == null) {
                setWorkspaceDir.add((WorkspaceDir)new WorkspaceDirUserModuleVersion(this.moduleVersionMain));
            }
            return setWorkspaceDir;
        }

        public Set<WorkspaceDir> getSetWorkspaceDir(WorkspaceDir workspaceDirIncomplete) {
            if (workspaceDirIncomplete != null && workspaceDirIncomplete instanceof WorkspaceDirUserModuleVersion) {
                WorkspaceDirUserModuleVersion workspaceDirUserModuleVersionIncomplete = (WorkspaceDirUserModuleVersion)workspaceDirIncomplete;
                NodePath nodePath = workspaceDirUserModuleVersionIncomplete.getModuleVersion().getNodePath();
                Version version = workspaceDirUserModuleVersionIncomplete.getModuleVersion().getVersion();
                if (nodePath != null && !nodePath.equals((Object)this.moduleVersionMain.getNodePath()) || version != null && !version.equals((Object)this.moduleVersionMain.getVersion())) {
                    return Collections.emptySet();
                }
                HashSet<WorkspaceDir> setWorkspaceDir = new HashSet<WorkspaceDir>();
                setWorkspaceDir.add((WorkspaceDir)new WorkspaceDirUserModuleVersion(this.moduleVersionMain));
                return setWorkspaceDir;
            }
            HashSet<WorkspaceDir> setWorkspaceDir = new HashSet<WorkspaceDir>(this.mapWorkspaceDirPath.keySet());
            if (workspaceDirIncomplete == null) {
                setWorkspaceDir.add((WorkspaceDir)new WorkspaceDirUserModuleVersion(this.moduleVersionMain));
            } else {
                WorkspaceDirSystemModule workspaceDirSystemModuleIncomplete = (WorkspaceDirSystemModule)workspaceDirIncomplete;
                Iterator iteratorWorkspaceDir = setWorkspaceDir.iterator();
                while (iteratorWorkspaceDir.hasNext()) {
                    WorkspaceDirSystemModule workspaceDirSystemModule = (WorkspaceDirSystemModule)iteratorWorkspaceDir.next();
                    if (workspaceDirSystemModuleIncomplete.getNodePath() == null || workspaceDirSystemModuleIncomplete.getNodePath().equals((Object)workspaceDirSystemModule.getNodePath())) continue;
                    iteratorWorkspaceDir.remove();
                }
            }
            return setWorkspaceDir;
        }

        public boolean isPathWorkspaceDirExists(Path pathWorkspaceDir) {
            return pathWorkspaceDir.equals(this.pathWorkspace) || this.mapPathWorkspaceDir.containsKey(pathWorkspaceDir);
        }

        public WorkspaceDir getWorkspaceDirFromPath(Path pathWorkspaceDir) {
            if (pathWorkspaceDir.equals(this.pathWorkspace)) {
                return new WorkspaceDirUserModuleVersion(this.moduleVersionMain);
            }
            if (!this.mapPathWorkspaceDir.containsKey(pathWorkspaceDir)) {
                throw new RuntimeException("No workspace directory corresponds to the path " + pathWorkspaceDir + '.');
            }
            return this.mapPathWorkspaceDir.get(pathWorkspaceDir);
        }

        public boolean isTransient() {
            return false;
        }

        public void startTool() {
            File workspaceLockedIndicatorFile = this.pathDragomMetadataDir.resolve(MainModuleVersionWorkspacePluginFactory.WORKSPACE_LOCKED_INDICATOR_FILE).toFile();
            try {
                if (!workspaceLockedIndicatorFile.createNewFile()) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MainModuleVersionWorkspacePluginFactory.MSG_PATTERN_KEY_WORKSPACE_LOCKED), this.pathWorkspace, workspaceLockedIndicatorFile));
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public void endTool() {
            File workspaceLockedIndicatorFile = this.pathDragomMetadataDir.resolve(MainModuleVersionWorkspacePluginFactory.WORKSPACE_LOCKED_INDICATOR_FILE).toFile();
            workspaceLockedIndicatorFile.delete();
        }
    }
}

