/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.plugin.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirSystemModule;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;

public class MapWorkspaceDirPathXmlAdapter
extends XmlAdapter<ListWorkspaceDirPath, Map<WorkspaceDir, Path>> {
    private Path pathWorkspace;

    public MapWorkspaceDirPathXmlAdapter(Path pathWorkspace) {
        this.pathWorkspace = pathWorkspace;
    }

    public ListWorkspaceDirPath marshal(Map<WorkspaceDir, Path> mapWorkspaceDirPath) {
        ArrayList<WorkspaceDirPath> listWorkspaceDirPath = new ArrayList<WorkspaceDirPath>();
        for (Map.Entry<WorkspaceDir, Path> mapEntry : mapWorkspaceDirPath.entrySet()) {
            WorkspaceDirPath workspaceDirPath = new WorkspaceDirPath();
            WorkspaceDir workspaceDir = mapEntry.getKey();
            workspaceDirPath.workspaceDirClass = mapEntry.getKey().getClass().getName();
            if (workspaceDir instanceof WorkspaceDirUserModuleVersion) {
                workspaceDirPath.stringNodePath = ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getNodePath().toString();
                workspaceDirPath.stringVersion = ((WorkspaceDirUserModuleVersion)workspaceDir).getModuleVersion().getVersion().toString();
            } else if (workspaceDir instanceof WorkspaceDirSystemModule) {
                workspaceDirPath.stringNodePath = ((WorkspaceDirSystemModule)workspaceDir).getNodePath().toString();
            } else {
                throw new RuntimeException("Unknown WorkspaceDir class " + workspaceDir.getClass().getName() + '.');
            }
            workspaceDirPath.stringPath = this.pathWorkspace.relativize(mapEntry.getValue()).toString();
            listWorkspaceDirPath.add(workspaceDirPath);
        }
        return new ListWorkspaceDirPath(listWorkspaceDirPath);
    }

    public Map<WorkspaceDir, Path> unmarshal(ListWorkspaceDirPath listWorkspaceDirPath) {
        HashMap<WorkspaceDir, Path> mapWorkspaceDirPath = new HashMap<WorkspaceDir, Path>();
        for (WorkspaceDirPath workspaceDirPath : listWorkspaceDirPath.getListWorkspaceDirPath()) {
            WorkspaceDirSystemModule workspaceDir;
            block5: {
                try {
                    Class<WorkspaceDir> classWorkspaceDir = Class.forName(workspaceDirPath.workspaceDirClass).asSubclass(WorkspaceDir.class);
                    if (classWorkspaceDir == WorkspaceDirUserModuleVersion.class) {
                        workspaceDir = new WorkspaceDirUserModuleVersion(new ModuleVersion(new NodePath(workspaceDirPath.stringNodePath), new Version(workspaceDirPath.stringVersion)));
                        break block5;
                    }
                    if (classWorkspaceDir == WorkspaceDirSystemModule.class) {
                        workspaceDir = new WorkspaceDirSystemModule(new NodePath(workspaceDirPath.stringNodePath));
                        break block5;
                    }
                    throw new RuntimeException("Unknown WorkspaceDir class " + workspaceDirPath.workspaceDirClass + '.');
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
            }
            Path path = this.pathWorkspace.resolve(Paths.get(workspaceDirPath.stringPath, new String[0]));
            mapWorkspaceDirPath.put((WorkspaceDir)workspaceDir, path);
        }
        return mapWorkspaceDirPath;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ListWorkspaceDirPath {
        @XmlElement(name="workspace-dir")
        private List<WorkspaceDirPath> listWorkspaceDirPath;

        public ListWorkspaceDirPath() {
        }

        public ListWorkspaceDirPath(List<WorkspaceDirPath> listWorkspaceDirPath) {
            this.listWorkspaceDirPath = listWorkspaceDirPath;
        }

        public List<WorkspaceDirPath> getListWorkspaceDirPath() {
            return this.listWorkspaceDirPath;
        }
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class WorkspaceDirPath {
        @XmlElement(name="workspace-dir-class")
        public String workspaceDirClass;
        @XmlElement(name="module-node-path")
        public String stringNodePath;
        @XmlElement(name="version")
        public String stringVersion;
        @XmlElement(name="path")
        public String stringPath;
    }
}

