/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.git.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.FileUtils;
import org.azyva.dragom.git.Git;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.util.Util;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGitImpl
implements Git {
    private static final Logger logger = LoggerFactory.getLogger(DefaultGitImpl.class);
    private static final Pattern patternExtractHttpReposUrlUser = Pattern.compile("([hH][tT][tT][pP][sS]?://)(?:([a-zA-Z0-9_\\.\\-]+)@)?([^/]+)/.*");
    private Path pathExecutable;
    private String reposUrl;
    private String user;
    private String password;
    private String httpCredentials;

    @Override
    public void setPathExecutable(Path pathExecutable) {
        this.pathExecutable = pathExecutable;
    }

    @Override
    public void setReposUrl(String reposUrl) {
        this.reposUrl = reposUrl;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeGitCommand(String[] arrayArg, boolean indProvideCredentials, Git.AllowExitCode allowExitCode, Path pathWorkingDirectory, StringBuilder stringBuilderOutput) {
        Path pathFileCredentials = null;
        try {
            int exitCode;
            CommandLine commandLine = new CommandLine(this.pathExecutable.toString());
            if (indProvideCredentials && this.user != null) {
                if (this.httpCredentials == null) {
                    Matcher matcher = patternExtractHttpReposUrlUser.matcher(this.reposUrl);
                    if (!matcher.matches()) {
                        throw new RuntimeException("Repository URL " + this.reposUrl + " does not match credential extraction pattern " + patternExtractHttpReposUrlUser.toString() + '.');
                    }
                    String userFromReposUrl = matcher.group(2);
                    if (userFromReposUrl != null && !userFromReposUrl.equals(this.user)) {
                        throw new RuntimeException("User " + userFromReposUrl + " extracted from repository URL " + this.reposUrl + " does not correspond to user provided in credentials " + this.user + '.');
                    }
                    this.httpCredentials = matcher.group(1) + this.user + ':' + this.password + '@' + matcher.group(3);
                }
                try {
                    if (Util.isPosix()) {
                        HashSet<PosixFilePermission> setPosixFilePermission = new HashSet<PosixFilePermission>();
                        setPosixFilePermission.add(PosixFilePermission.OWNER_READ);
                        setPosixFilePermission.add(PosixFilePermission.OWNER_WRITE);
                        pathFileCredentials = Files.createTempFile((String)null, (String)null, PosixFilePermissions.asFileAttribute(setPosixFilePermission));
                    } else {
                        pathFileCredentials = Files.createTempFile((String)null, (String)null, new FileAttribute[0]);
                    }
                    FileWriter writer = new FileWriter(pathFileCredentials.toFile());
                    ((Writer)writer).append(this.httpCredentials);
                    ((Writer)writer).close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                commandLine.addArgument("-c").addArgument("credential.helper=store --file=" + pathFileCredentials.toString());
            }
            for (String arg : arrayArg) {
                commandLine.addArgument(arg, false);
            }
            logger.trace(commandLine.toString());
            DefaultExecutor defaultExecutor = new DefaultExecutor();
            ByteArrayOutputStream byteArrayOutputStreamOut = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStreamErr = new ByteArrayOutputStream();
            defaultExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)byteArrayOutputStreamOut, (OutputStream)byteArrayOutputStreamErr));
            defaultExecutor.setExitValues(null);
            if (pathWorkingDirectory != null) {
                defaultExecutor.setWorkingDirectory(pathWorkingDirectory.toFile());
                logger.trace("Invoking Git command " + commandLine + " within " + pathWorkingDirectory + '.');
            } else {
                logger.trace("Invoking Git command " + commandLine + '.');
            }
            try {
                exitCode = defaultExecutor.execute(commandLine);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            if (!(exitCode == 0 || exitCode == 1 && allowExitCode == Git.AllowExitCode.ONE || exitCode != 0 && allowExitCode == Git.AllowExitCode.ALL)) {
                logger.error("Git command returned " + exitCode + '.');
                logger.error("Output of the command:");
                logger.error(byteArrayOutputStreamOut.toString());
                logger.error("Error output of the command:");
                logger.error(byteArrayOutputStreamErr.toString());
                throw new RuntimeException("Git command " + commandLine + " failed.");
            }
            if (stringBuilderOutput != null) {
                stringBuilderOutput.append(byteArrayOutputStreamOut.toString().trim());
                stringBuilderOutput.append(byteArrayOutputStreamErr.toString().trim());
            }
            int n = exitCode;
            return n;
        }
        finally {
            if (pathFileCredentials != null) {
                pathFileCredentials.toFile().delete();
            }
        }
    }

    @Override
    public boolean validateCredentials() {
        StringBuilder stringBuilderOutput = new StringBuilder();
        if (this.executeGitCommand(new String[]{"ls-remote", this.reposUrl, "dummy"}, true, Git.AllowExitCode.ALL, null, stringBuilderOutput) != 0) {
            String error = stringBuilderOutput.toString();
            return !error.contains("Authentication") && !error.contains("Authentification") && !error.contains("authentification");
        }
        return true;
    }

    @Override
    public boolean isReposExists() {
        boolean isReposExists;
        boolean bl = isReposExists = this.executeGitCommand(new String[]{"ls-remote", this.reposUrl, "dummy"}, true, Git.AllowExitCode.ALL, null, null) == 0;
        if (isReposExists) {
            logger.trace("Git repository " + this.reposUrl + " exists.");
            return true;
        }
        logger.trace("Git repository " + this.reposUrl + " does not exist.");
        return false;
    }

    @Override
    public String getBranch(Path pathWorkspace) {
        StringBuilder stringBuilder = new StringBuilder();
        int exitCode = this.executeGitCommand(new String[]{"symbolic-ref", "-q", "HEAD"}, false, Git.AllowExitCode.ONE, pathWorkspace, stringBuilder);
        if (exitCode == 0) {
            String branch = stringBuilder.toString();
            if (branch.startsWith("refs/heads/")) {
                return branch.substring(11);
            }
            throw new RuntimeException("Unrecognized branch reference " + branch + " returned by git symbolic-ref.");
        }
        return null;
    }

    @Override
    public void config(Path pathWorkspace, String param, String value) {
        this.executeGitCommand(new String[]{"config", param, value}, false, Git.AllowExitCode.NONE, pathWorkspace, null);
    }

    @Override
    public void clone(String reposUrl, Version version, Path pathWorkspace) {
        boolean isConfiguredReposUrl;
        if (reposUrl == null) {
            reposUrl = this.reposUrl;
            isConfiguredReposUrl = true;
        } else {
            isConfiguredReposUrl = false;
        }
        if (version == null) {
            this.executeGitCommand(new String[]{"clone", "--no-local", "--no-checkout", reposUrl, pathWorkspace.toString()}, isConfiguredReposUrl, Git.AllowExitCode.NONE, null, null);
        } else {
            this.executeGitCommand(new String[]{"clone", "--no-local", "-b", version.getVersion(), reposUrl, pathWorkspace.toString()}, isConfiguredReposUrl, Git.AllowExitCode.NONE, null, null);
        }
        if (version != null) {
            boolean isDetachedHead;
            boolean bl = isDetachedHead = this.getBranch(pathWorkspace) == null;
            if (version.getVersionType() == VersionType.DYNAMIC && isDetachedHead) {
                try {
                    FileUtils.deleteDirectory((File)pathWorkspace.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException("Requested version is dynamic but checked out version is a tag.");
            }
            if (version.getVersionType() == VersionType.STATIC && !isDetachedHead) {
                try {
                    FileUtils.deleteDirectory((File)pathWorkspace.toFile());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException("Requested version is static but checked out version is a branch.");
            }
        }
    }

    @Override
    public void fetch(Path pathWorkspace, String reposUrl, String refspec, boolean indFetchingIntoCurrentBranch) {
        ArrayList<String> listArg = new ArrayList<String>();
        listArg.add("fetch");
        if (indFetchingIntoCurrentBranch) {
            listArg.add("--update-head-ok");
        }
        if (reposUrl != null) {
            listArg.add(reposUrl);
        }
        if (refspec != null) {
            if (reposUrl == null) {
                listArg.add("origin");
            }
            listArg.add(refspec);
        }
        this.executeGitCommand(listArg.toArray(new String[0]), reposUrl != null, Git.AllowExitCode.NONE, pathWorkspace, null);
    }

    @Override
    public boolean pull(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        int exitCode = this.executeGitCommand(new String[]{"pull"}, true, Git.AllowExitCode.ONE, pathWorkspace, null);
        return exitCode == 1;
    }

    @Override
    public boolean rebaseSimple(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        int exitCode = this.executeGitCommand(new String[]{"rebase", "@{u}"}, false, Git.AllowExitCode.ONE, pathWorkspace, null);
        return exitCode == 1;
    }

    @Override
    public boolean mergeSimple(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        int exitCode = this.executeGitCommand(new String[]{"merge", "@{u}"}, false, Git.AllowExitCode.ONE, pathWorkspace, null);
        return exitCode == 1;
    }

    @Override
    public void push(Path pathWorkspace, String gitRef) {
        if (gitRef != null) {
            this.executeGitCommand(new String[]{"push", "--set-upstream", "origin", gitRef + ':' + gitRef}, true, Git.AllowExitCode.NONE, pathWorkspace, null);
        } else {
            this.executeGitCommand(new String[]{"push"}, true, Git.AllowExitCode.NONE, pathWorkspace, null);
        }
    }

    @Override
    public void checkout(Path pathWorkspace, Version version) {
        boolean isDetachedHead;
        this.executeGitCommand(new String[]{"checkout", version.getVersion()}, false, Git.AllowExitCode.NONE, pathWorkspace, null);
        boolean bl = isDetachedHead = this.getBranch(pathWorkspace) == null;
        if (version.getVersionType() == VersionType.DYNAMIC && isDetachedHead) {
            try {
                FileUtils.deleteDirectory((File)pathWorkspace.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Requested version is dynamic but checked out version is a tag.");
        }
        if (version.getVersionType() == VersionType.STATIC && !isDetachedHead) {
            try {
                FileUtils.deleteDirectory((File)pathWorkspace.toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException("Requested version is static but checked out version is a branch.");
        }
    }

    @Override
    public boolean isVersionExists(Path pathWorkspace, Version version) {
        if (this.executeGitCommand(new String[]{"rev-parse", this.convertToRef(version), "--"}, false, Git.AllowExitCode.ALL, pathWorkspace, null) == 0) {
            logger.trace("Version " + version + " exists.");
            return true;
        }
        logger.trace("Version " + version + " does not exist.");
        return false;
    }

    @Override
    public Git.AheadBehindInfo getAheadBehindInfo(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.executeGitCommand(new String[]{"for-each-ref", "--format=%(upstream:track)", "refs/heads/" + branch}, false, Git.AllowExitCode.NONE, pathWorkspace, stringBuilder);
        Git.AheadBehindInfo aheadBehindInfo = new Git.AheadBehindInfo();
        int index = stringBuilder.indexOf("ahead");
        if (index != -1) {
            int index2 = stringBuilder.indexOf(",", index + 6);
            if (index2 == -1) {
                index2 = stringBuilder.indexOf("]", index + 6);
            }
            aheadBehindInfo.ahead = Integer.parseInt(stringBuilder.substring(index + 6, index2));
        }
        if ((index = stringBuilder.indexOf("behind")) != -1) {
            aheadBehindInfo.behind = Integer.parseInt(stringBuilder.substring(index + 7, stringBuilder.indexOf("]", index + 7)));
        }
        return aheadBehindInfo;
    }

    @Override
    public boolean isLocalChanges(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.executeGitCommand(new String[]{"status", "-s"}, false, Git.AllowExitCode.NONE, pathWorkspace, stringBuilder);
        return stringBuilder.length() != 0;
    }

    @Override
    public void push(Path pathWorkspace) {
        this.executeGitCommand(new String[]{"push", "--all", "--set-upstream", "origin"}, true, Git.AllowExitCode.NONE, pathWorkspace, null);
        this.executeGitCommand(new String[]{"push", "--tags"}, true, Git.AllowExitCode.NONE, pathWorkspace, null);
    }

    @Override
    public Version getVersion(Path pathWorkspace) {
        String branch = this.getBranch(pathWorkspace);
        if (branch != null) {
            return new Version(VersionType.DYNAMIC, branch);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.executeGitCommand(new String[]{"describe", "--exact-match"}, false, Git.AllowExitCode.NONE, pathWorkspace, stringBuilder);
        return new Version(VersionType.STATIC, stringBuilder.toString());
    }

    @Override
    public List<Version> getListVersionStatic(Path pathWorkspace) {
        ArrayList<Version> listVersionStatic;
        try {
            String tagLine;
            StringBuilder stringBuilder = new StringBuilder();
            this.executeGitCommand(new String[]{"show-ref", "--tag", "-d"}, false, Git.AllowExitCode.NONE, pathWorkspace, stringBuilder);
            BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuilder.toString()));
            listVersionStatic = new ArrayList<Version>();
            while ((tagLine = bufferedReader.readLine()) != null) {
                String[] arrayTagLineComponent = tagLine.split("\\s+");
                String tagRef = arrayTagLineComponent[1];
                if (!tagRef.endsWith("^{}")) continue;
                String tagName = tagRef.substring(10, tagRef.length() - 3);
                listVersionStatic.add(new Version(VersionType.STATIC, tagName));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return listVersionStatic;
    }

    @Override
    public void createBranch(Path pathModuleWorkspace, String branch, boolean indSwitch) {
        this.executeGitCommand(new String[]{"branch", branch}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null);
        if (indSwitch) {
            this.checkout(pathModuleWorkspace, new Version(VersionType.DYNAMIC, branch));
        }
    }

    @Override
    public void createTag(Path pathModuleWorkspace, String tag, String message) {
        this.executeGitCommand(new String[]{"tag", "-m", message, tag}, false, Git.AllowExitCode.NONE, pathModuleWorkspace, null);
    }

    @Override
    public void addCommit(Path pathWorkspace, String message, Map<String, String> mapCommitAttr, boolean indPush) {
        String branch = this.getBranch(pathWorkspace);
        if (branch == null) {
            throw new RuntimeException("Within " + pathWorkspace + " the HEAD is not a branch.");
        }
        this.executeGitCommand(new String[]{"add", "--all"}, false, Git.AllowExitCode.NONE, pathWorkspace, null);
        if (mapCommitAttr != null) {
            message = new JSONObject(mapCommitAttr).toString() + ' ' + message;
        }
        message = message.replace("\"", "\\\"");
        this.executeGitCommand(new String[]{"commit", "-m", message}, false, Git.AllowExitCode.NONE, pathWorkspace, null);
        if (indPush) {
            this.push(pathWorkspace, "refs/heads/" + branch);
        }
    }

    @Override
    public String convertToRef(Version version) {
        if (version.getVersionType() == VersionType.STATIC) {
            return "refs/tags/" + version.getVersion() + "^{tag}";
        }
        return "refs/remotes/origin/" + version.getVersion();
    }
}

