/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.BuildReferenceGraph;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.util.AlwaysNeverYesNoAskUserResponse;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;

public class Checkout
extends RootModuleVersionJobAbstractImpl {
    private static final String MSG_PATTERN_KEY_COMPUTING_LIST_MODULE_VERSION = "COMPUTING_LIST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_MULTIPLE_MODULE_VERSIONS = "MULTIPLE_MODULE_VERSIONS";
    private static final String MSG_PATTERN_KEY_INPUT_MODULE_VERSION_TO_KEEP = "INPUT_MODULE_VERSION_TO_KEEP";
    private static final String MSG_PATTERN_KEY_VERSION_INDEX_OUT_OF_BOUNDS = "VERSION_INDEX_OUT_OF_BOUNDS";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_ALREADY_CHECKED_OUT = "MODULE_VERSION_ALREADY_CHECKED_OUT";
    private static final String MSG_PATTERN_KEY_CHECKING_OUT_MODULE_VERSION = "CHECKING_OUT_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_CANNOT_SWITCH_UNSYNC_LOCAL_CHANGES = "CANNOT_SWITCH_UNSYNC_LOCAL_CHANGES";
    private static final String MSG_PATTERN_KEY_DO_YOU_WANT_TO_SWITCH_MODULE_VERSION = "DO_YOU_WANT_TO_SWITCH_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SWITCHING_MODULE_VERSION = "SWITCHING_MODULE_VERSION";
    private static final String RUNTIME_PROPERTY_SWITCH_MODULE_VERSION = "SWITCH_MODULE_VERSION";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(Checkout.class.getName() + "ResourceBundle");

    public Checkout(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        this.setupReferencePathMatcherForProjectCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performJob() {
        ExecContext execContext = ExecContextHolder.get();
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_COMPUTING_LIST_MODULE_VERSION));
        BuildReferenceGraph buildReferenceGraph = new BuildReferenceGraph(null, this.listModuleVersionRoot);
        buildReferenceGraph.setReferencePathMatcherProvided(this.getReferencePathMatcher());
        buildReferenceGraph.setUnsyncChangesBehaviorLocal(RootModuleVersionJobAbstractImpl.UnsyncChangesBehavior.USER_ERROR);
        buildReferenceGraph.setUnsyncChangesBehaviorRemote(RootModuleVersionJobAbstractImpl.UnsyncChangesBehavior.INTERACT);
        buildReferenceGraph.performJob();
        if (buildReferenceGraph.isListModuleVersionRootChanged()) {
            this.setIndListModuleVersionRootChanged();
        }
        ReferenceGraph referenceGraph = buildReferenceGraph.getReferenceGraph();
        ArrayList<ModuleVersion> listModuleVersion = referenceGraph.getListModuleVersionMatched();
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        if (!workspacePlugin.isSupportMultipleModuleVersion()) {
            LinkedHashMap<NodePath, ArrayList<Version>> mapModuleVersion = new LinkedHashMap<NodePath, ArrayList<Version>>();
            for (ModuleVersion moduleVersion : listModuleVersion) {
                ArrayList<Version> listVersion = (ArrayList<Version>)mapModuleVersion.get(moduleVersion.getNodePath());
                if (listVersion == null) {
                    listVersion = new ArrayList<Version>();
                    mapModuleVersion.put(moduleVersion.getNodePath(), listVersion);
                }
                listVersion.add(moduleVersion.getVersion());
            }
            listModuleVersion = new ArrayList<ModuleVersion>();
            for (Map.Entry entry : mapModuleVersion.entrySet()) {
                if (((List)entry.getValue()).size() > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    int index = 1;
                    for (Version version : (List)entry.getValue()) {
                        if (index != 1) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(index++).append(" - ").append(version);
                    }
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MULTIPLE_MODULE_VERSIONS), entry.getKey(), stringBuilder));
                    Version versionSelected = null;
                    do {
                        String selectedVersion = userInteractionCallbackPlugin.getInfo(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_MODULE_VERSION_TO_KEEP));
                        try {
                            index = Integer.parseInt(selectedVersion);
                            if (index < 1 || index > ((List)entry.getValue()).size()) {
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSION_INDEX_OUT_OF_BOUNDS), selectedVersion, 1, ((List)entry.getValue()).size()));
                            } else {
                                versionSelected = (Version)((List)entry.getValue()).get(index - 1);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (versionSelected == null) {
                            try {
                                versionSelected = Version.parse((String)selectedVersion);
                            }
                            catch (ParseException pe) {
                                userInteractionCallbackPlugin.provideInfo(pe.getMessage());
                            }
                        }
                        if (versionSelected != null) continue;
                        userInteractionCallbackPlugin.provideInfo(Util.getLocalizedMsgPattern("TRY_AGAIN"));
                    } while (versionSelected == null);
                    listModuleVersion.add(new ModuleVersion((NodePath)entry.getKey(), versionSelected));
                    continue;
                }
                listModuleVersion.add(new ModuleVersion((NodePath)entry.getKey(), (Version)((List)entry.getValue()).get(0)));
            }
        }
        for (ModuleVersion moduleVersion : listModuleVersion) {
            Path pathModuleWorkspace;
            RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
            Module module = ExecContextHolder.get().getModel().getModule(moduleVersion.getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersion);
            WorkspaceDirUserModuleVersion workspaceDirUserModuleVersionConflict = (WorkspaceDirUserModuleVersion)workspacePlugin.getWorkspaceDirConflict((WorkspaceDir)workspaceDirUserModuleVersion);
            if (workspaceDirUserModuleVersionConflict != null && !workspaceDirUserModuleVersionConflict.getModuleVersion().getNodePath().equals((Object)moduleVersion.getNodePath())) {
                throw new RuntimeException("Workspace conflicts where two different Module's share the same workspace directory (same Module name) are not supported.");
            }
            if (workspacePlugin.isSupportMultipleModuleVersion() || workspaceDirUserModuleVersionConflict == null) {
                if (workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirUserModuleVersion)) {
                    pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                    try {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ALREADY_CHECKED_OUT), pathModuleWorkspace, moduleVersion));
                        continue;
                    }
                    finally {
                        if (pathModuleWorkspace != null) {
                            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                        }
                        continue;
                    }
                }
                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_CREATE_NEW_NO_PATH, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                try {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CHECKING_OUT_MODULE_VERSION), moduleVersion, pathModuleWorkspace));
                    scmPlugin.checkout(moduleVersion.getVersion(), pathModuleWorkspace);
                    continue;
                }
                catch (RuntimeException re) {
                    workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion);
                    pathModuleWorkspace = null;
                    throw re;
                }
                finally {
                    if (pathModuleWorkspace != null) {
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    }
                    continue;
                }
            }
            pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersionConflict, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            try {
                if (!scmPlugin.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.LOCAL_CHANGES_ONLY)) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CANNOT_SWITCH_UNSYNC_LOCAL_CHANGES), pathModuleWorkspace, workspaceDirUserModuleVersionConflict.getModuleVersion(), moduleVersion.getVersion()));
                }
                AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponse = Util.getInfoAlwaysNeverYesNoAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_SWITCH_MODULE_VERSION, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DO_YOU_WANT_TO_SWITCH_MODULE_VERSION), pathModuleWorkspace, workspaceDirUserModuleVersionConflict.getModuleVersion(), moduleVersion.getVersion()));
                if (!alwaysNeverYesNoAskUserResponse.isYes()) continue;
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SWITCHING_MODULE_VERSION), workspaceDirUserModuleVersionConflict.getModuleVersion(), pathModuleWorkspace, moduleVersion.getVersion()));
                scmPlugin.switchVersion(pathModuleWorkspace, moduleVersion.getVersion());
            }
            finally {
                if (pathModuleWorkspace == null) continue;
                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
            }
        }
    }
}

