/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeMain
extends RootModuleVersionJobAbstractImpl {
    private static final Logger logger = LoggerFactory.getLogger(MergeMain.class);
    private static final String RUNTIME_PROPERTY_CAN_REUSE_DEST_VERSION = "CAN_REUSE_DEST_VERSION";
    private static final String RUNTIME_PROPERTY_REUSE_DEST_VERSION = "REUSE_DEST_VERSION";
    private static final String RUNTIME_PROPERTY_CONTINUE_ON_MERGE_CONFLICTS = "CONTINUE_ON_MERGE_CONFLICTS";
    private static final String MSG_PATTERN_KEY_DEST_VERSION_AUTOMATICALLY_REUSED = "DEST_VERSION_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_INPUT_DEST_VERSION = "INPUT_DEST_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_DEST_VERSION = "AUTOMATICALLY_REUSE_DEST_VERSION";
    private static final String MSG_PATTERN_KEY_CHECKING_OUT_MODULE_VERSION = "CHECKING_OUT_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST = "SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST";
    private static final String MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS = "SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS";
    private static final String MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST = "SRC_MERGED_INTO_DEST";
    private static final String MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST_CONFLICTS = "SRC_MERGED_INTO_DEST_CONFLICTS";
    private static final String MSG_PATTERN_KEY_MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST = "MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUING_NEXT_MATCHING_SRC_MODULE_VERSION = "AUTOMATICALLY_CONTINUING_NEXT_MATCHING_SRC_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUE_NEXT_MATCHING_SRC_MODULE_VERSION = "AUTOMATICALLY_CONTINUE_NEXT_MATCHING_SRC_MODULE_VERSION";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(MergeMain.class.getName() + "ResourceBundle");

    public MergeMain(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        this.setupReferencePathMatcherForProjectCode();
        this.setIndHandleDynamicVersion(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean visitMatchedModuleVersion(Reference reference) {
        this.referencePath.add(reference);
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        Model model = execContext.getModel();
        ModuleVersion moduleVersionSrc = reference.getModuleVersion();
        Module module = model.getModule(moduleVersionSrc.getNodePath());
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        try {
            Path pathModuleWorkspace;
            Version versionDest;
            Version versionReuseDest;
            AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReuseDestVersion = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_CAN_REUSE_DEST_VERSION));
            String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_REUSE_DEST_VERSION);
            if (runtimeProperty != null) {
                versionReuseDest = new Version(runtimeProperty);
            } else {
                versionReuseDest = null;
                if (alwaysNeverAskUserResponseCanReuseDestVersion.isAlways()) {
                    alwaysNeverAskUserResponseCanReuseDestVersion = AlwaysNeverAskUserResponse.ASK;
                }
            }
            if (alwaysNeverAskUserResponseCanReuseDestVersion.isAlways()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DEST_VERSION_AUTOMATICALLY_REUSED), moduleVersionSrc, versionReuseDest));
                versionDest = versionReuseDest;
            } else {
                versionDest = Util.getInfoVersion(null, scmPlugin, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_DEST_VERSION), moduleVersionSrc), versionReuseDest);
                runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_REUSE_DEST_VERSION, versionDest.toString());
                Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_DEST_VERSION, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_DEST_VERSION), versionDest));
            }
            ModuleVersion moduleVersionDest = new ModuleVersion(module.getNodePath(), versionDest);
            WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersionDest);
            if (!workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirUserModuleVersion)) {
                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_CREATE_NEW_NO_PATH, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                try {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CHECKING_OUT_MODULE_VERSION), moduleVersionDest, pathModuleWorkspace));
                    scmPlugin.checkout(moduleVersionDest.getVersion(), pathModuleWorkspace);
                }
                catch (RuntimeException re) {
                    workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion);
                    pathModuleWorkspace = null;
                    throw re;
                }
                finally {
                    if (pathModuleWorkspace != null) {
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    }
                }
            } else {
                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
            }
            logger.info("Building list of version-changing commits to exclude before merging source ModuleVersion " + moduleVersionSrc + " into destination ModuleVersion " + moduleVersionDest + '.');
            List listCommit = scmPlugin.getListCommitDiverge(moduleVersionSrc.getVersion(), moduleVersionDest.getVersion(), null, EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR));
            Iterator iteratorCommit = listCommit.iterator();
            while (iteratorCommit.hasNext()) {
                ScmPlugin.Commit commit = (ScmPlugin.Commit)iteratorCommit.next();
                if (commit.mapAttr.containsKey("dragom-version-change")) continue;
                iteratorCommit.remove();
            }
            if (listCommit.isEmpty()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST), moduleVersionSrc, moduleVersionDest, pathModuleWorkspace));
            } else {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS), moduleVersionSrc, moduleVersionDest, pathModuleWorkspace, listCommit));
            }
            if (!Util.handleDoYouWantToContinue("MERGE")) {
                boolean bl = true;
                return bl;
            }
            if (!scmPlugin.merge(pathModuleWorkspace, moduleVersionSrc.getVersion(), listCommit, null)) {
                this.listActionsPerformed.add(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST_CONFLICTS), moduleVersionSrc, moduleVersionDest, pathModuleWorkspace));
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST), moduleVersionSrc, moduleVersionDest, pathModuleWorkspace));
                MergeMain.handleContinueOnMergeConflicts();
                boolean bl = true;
                return bl;
            }
            this.listActionsPerformed.add(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST), moduleVersionSrc, moduleVersionDest, pathModuleWorkspace));
        }
        finally {
            this.referencePath.removeLeafReference();
        }
        return true;
    }

    private static void handleContinueOnMergeConflicts() {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponseContinueOnMergeConflicts = Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CONTINUE_ON_MERGE_CONFLICTS, userInteractionCallbackPlugin, resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUE_NEXT_MATCHING_SRC_MODULE_VERSION));
        switch (alwaysNeverAskUserResponseContinueOnMergeConflicts) {
            case ALWAYS: {
                userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUING_NEXT_MATCHING_SRC_MODULE_VERSION));
                break;
            }
            case NEVER: {
                Util.setAbort();
                break;
            }
        }
    }
}

