/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.job.SwitchToDynamicVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeReferenceGraph
extends RootModuleVersionJobAbstractImpl {
    private static final Logger logger = LoggerFactory.getLogger(MergeReferenceGraph.class);
    private static final String RUNTIME_PROPERTY_CAN_REUSE_SRC_VERSION = "CAN_REUSE_SRC_VERSION";
    private static final String RUNTIME_PROPERTY_REUSE_SRC_VERSION = "REUSE_SRC_VERSION";
    private static final String RUNTIME_PROPERTY_CONTINUE_ON_MERGE_CONFLICTS = "CONTINUE_ON_MERGE_CONFLICTS";
    private static final String MSG_PATTERN_KEY_INITIATING_MERGE_FOR_DEST_TOP_LEVEL_MODULE_VERSION = "INITIATING_MERGE_FOR_DEST_TOP_LEVEL_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SRC_VERSION_AUTOMATICALLY_REUSED = "SRC_VERSION_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_INPUT_SRC_VERSION = "INPUT_SRC_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_SRC_VERSION = "AUTOMATICALLY_REUSE_SRC_VERSION";
    private static final String MSG_PATTERN_KEY_LOCATING_SRC_MODULE_VERSION = "LOCATING_SRC_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SRC_MODULE_VERSION_NOT_FOUND = "SRC_MODULE_VERSION_NOT_FOUND";
    private static final String MSG_PATTERN_KEY_MERGING_LEAF_MODULE_VERSION = "MERGING_LEAF_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_MERGE_ALREADY_PERFORMED = "MERGE_ALREADY_PERFORMED";
    private static final String MSG_PATTERN_KEY_CHECKING_OUT_MODULE_VERSION = "CHECKING_OUT_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST = "SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST";
    private static final String MSG_PATTERN_KEY_SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS = "SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS";
    private static final String MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST = "SRC_MERGED_INTO_DEST";
    private static final String MSG_PATTERN_KEY_SRC_MERGED_INTO_DEST_CONFLICTS = "SRC_MERGED_INTO_DEST_CONFLICTS";
    private static final String MSG_PATTERN_KEY_MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST = "MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUING_NEXT_MATCHING_DEST_MODULE_VERSION = "AUTOMATICALLY_CONTINUING_NEXT_MATCHING_DEST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUE_NEXT_MATCHING_DEST_MODULE_VERSION = "AUTOMATICALLY_CONTINUE_NEXT_MATCHING_DEST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_BOTH_SRC_AND_DEST_STATIC_REFERENCE_DIVERGE = "BOTH_SRC_AND_DEST_STATIC_REFERENCE_DIVERGE";
    private static final String MSG_PATTERN_KEY_SRC_STATIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE = "SRC_STATIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE";
    private static final String MSG_PATTERN_KEY_CHANGE_DEST_REFERENCE_VERSION = "CHANGE_DEST_REFERENCE_VERSION";
    private static final String MSG_PATTERN_KEY_SRC_DYNAMIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE = "SRC_DYNAMIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE";
    private static final String MSG_PATTERN_KEY_DEST_STATIC_REFERENCE_ALSO_DIVERGES_FROM_SRC_DYNAMIC_REFERENCE = "DEST_STATIC_REFERENCE_ALSO_DIVERGES_FROM_SRC_DYNAMIC_REFERENCE";
    private static final String MSG_PATTERN_KEY_DEST_STATIC_VERSION_NOT_SWITCHED = "DEST_STATIC_VERSION_NOT_SWITCHED";
    private static final String MSG_PATTERN_KEY_NEW_DEST_DYNAMIC_VERSION_DOES_NOT_INCLUDE_ORIGINALLY_DIVERGING_COMMITS = "NEW_DEST_DYNAMIC_VERSION_DOES_NOT_INCLUDE_ORIGINALLY_DIVERGING_COMMITS";
    private static final String MSG_PATTERN_KEY_DEST_REFERENCE_WILL_BE_CHANGED = "DEST_REFERENCE_WILL_BE_CHANGED";
    private static final String MSG_PATTERN_KEY_RECURSIVELY_MERGING_SRC_DYNAMIC_REFERENCE_INTO_DEST_DYNAMIC_REFERENCE = "RECURSIVELY_MERGING_SRC_DYNAMIC_REFERENCE_INTO_DEST_DYNAMIC_REFERENCE";
    private static final String MSG_PATTERN_KEY_VERIFYING_SRC_DIVERGES_FROM_DEST_MODULE_VERSION = "VERIFYING_SRC_DIVERGES_FROM_DEST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_NO_DIVERGENCES_FOUND_IN_SRC_COMPARED_TO_DEST_MODULE_VERSION = "NO_DIVERGENCES_FOUND_IN_SRC_COMPARED_TO_DEST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_SRC_DIVERGES_FROM_DEST_MODULE_VERSION = "SRC_DIVERGES_FROM_DEST_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_VERIFYING_DEST_DIVERGES_FROM_SRC_MODULE_VERSION = "VERIFYING_DEST_DIVERGES_FROM_SRC_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_NO_DIVERGENCES_FOUND_IN_DEST_COMPARED_TO_SRC_MODULE_VERSION = "NO_DIVERGENCES_FOUND_IN_DEST_COMPARED_TO_SRC_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_DEST_DIVERGES_FROM_SRC_MODULE_VERSION = "DEST_DIVERGES_FROM_SRC_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_NO_DIVERGENCES_BETWEEN_SRC_AND_DEST_MODULE_VERSIONS = "NO_DIVERGENCES_BETWEEN_SRC_AND_DEST_MODULE_VERSIONS";
    private static final String MSG_PATTERN_KEY_RECURSIVELY_VERIFYING_DIVERGENCES_BETWEEN_SRC_AND_DEST_REFERENCES = "RECURSIVELY_VERIFYING_DIVERGENCES_BETWEEN_SRC_AND_DEST_REFERENCES";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(MergeReferenceGraph.class.getName() + "ResourceBundle");
    private Set<ModuleVersionMerge> setModuleVersionMerge;

    public MergeReferenceGraph(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        this.setupReferencePathMatcherForProjectCode();
        this.setIndHandleStaticVersion(false);
        this.setModuleVersionMerge = new HashSet<ModuleVersionMerge>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean visitMatchedModuleVersion(Reference reference) {
        this.referencePath.add(reference);
        boolean indReferencePathAlreadyReverted = false;
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        Model model = execContext.getModel();
        UserInteractionCallbackPlugin.BracketHandle bracketHandle = null;
        try {
            Version versionSrc;
            Version versionReuseSrc;
            bracketHandle = userInteractionCallbackPlugin.startBracket(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INITIATING_MERGE_FOR_DEST_TOP_LEVEL_MODULE_VERSION), this.referencePath));
            ModuleVersion moduleVersionRootDest = this.referencePath.get(0).getModuleVersion();
            Module module = model.getModule(moduleVersionRootDest.getNodePath());
            ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
            AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReuseSrcVersion = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_CAN_REUSE_SRC_VERSION));
            String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_REUSE_SRC_VERSION);
            if (runtimeProperty != null) {
                versionReuseSrc = new Version(runtimeProperty);
            } else {
                versionReuseSrc = null;
                if (alwaysNeverAskUserResponseCanReuseSrcVersion.isAlways()) {
                    alwaysNeverAskUserResponseCanReuseSrcVersion = AlwaysNeverAskUserResponse.ASK;
                }
            }
            if (alwaysNeverAskUserResponseCanReuseSrcVersion.isAlways()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SRC_VERSION_AUTOMATICALLY_REUSED), moduleVersionRootDest, versionReuseSrc));
                versionSrc = versionReuseSrc;
            } else {
                versionSrc = Util.getInfoVersion(null, scmPlugin, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_SRC_VERSION), moduleVersionRootDest), versionReuseSrc);
                runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_REUSE_SRC_VERSION, versionSrc.toString());
                Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_SRC_VERSION, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_SRC_VERSION), versionSrc));
            }
            ModuleVersion moduleVersionSrc = new ModuleVersion(moduleVersionRootDest.getNodePath(), versionSrc);
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_LOCATING_SRC_MODULE_VERSION), moduleVersionSrc, this.referencePath));
            ReferencePath referencePathSrc = new ReferencePath();
            referencePathSrc.add(new Reference(moduleVersionSrc));
            for (int i = 1; i < this.referencePath.size(); ++i) {
                List listReferenceSrc;
                Reference referenceDest = this.referencePath.get(i);
                module = model.getModule(moduleVersionSrc.getNodePath());
                scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                Path pathModuleWorkspace = scmPlugin.checkoutSystem(moduleVersionSrc.getVersion());
                try {
                    if (!module.isNodePluginExists(ReferenceManagerPlugin.class, null)) {
                        listReferenceSrc = Collections.emptyList();
                    } else {
                        ReferenceManagerPlugin referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
                        listReferenceSrc = referenceManagerPlugin.getListReference(pathModuleWorkspace);
                    }
                }
                finally {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                }
                Reference referenceChildSrc = null;
                for (Reference referenceSrc : listReferenceSrc) {
                    if (!referenceSrc.equalsNoVersion(referenceDest)) continue;
                    referenceChildSrc = referenceSrc;
                    break;
                }
                if (referenceChildSrc == null) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SRC_MODULE_VERSION_NOT_FOUND), referencePathSrc, referenceDest));
                    boolean bl = false;
                    return bl;
                }
                referencePathSrc.add(referenceChildSrc);
            }
            this.referencePath.removeLeafReference();
            indReferencePathAlreadyReverted = true;
            bracketHandle.close();
            bracketHandle = null;
            this.mergeModuleVersion(referencePathSrc, reference);
        }
        finally {
            if (!indReferencePathAlreadyReverted) {
                this.referencePath.removeLeafReference();
            }
            if (bracketHandle != null) {
                bracketHandle.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean mergeModuleVersion(ReferencePath referencePathSrc, Reference referenceDest) {
        block63: {
            block61: {
                block62: {
                    block59: {
                        block60: {
                            block57: {
                                block58: {
                                    this.referencePath.add(referenceDest);
                                    execContext = ExecContextHolder.get();
                                    userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
                                    workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
                                    model = execContext.getModel();
                                    pathModuleWorkspace = null;
                                    pathModuleWorkspaceSrc = null;
                                    bracketHandle = null;
                                    moduleVersionDest = referenceDest.getModuleVersion();
                                    moduleVersionSrc = referencePathSrc.getLeafModuleVersion();
                                    if (this.setModuleVersionMerge.add(new ModuleVersionMerge(moduleVersionDest, moduleVersionSrc.getVersion()))) break block57;
                                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("MERGE_ALREADY_PERFORMED"), new Object[]{moduleVersionDest, moduleVersionSrc.getVersion()}));
                                    var17_12 = false;
                                    if (pathModuleWorkspace == null) break block58;
                                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                }
                                if (pathModuleWorkspaceSrc != null) {
                                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                                }
                                this.referencePath.removeLeafReference();
                                if (bracketHandle != null) {
                                    bracketHandle.close();
                                }
                                return var17_12;
                            }
                            module = model.getModule(moduleVersionDest.getNodePath());
                            scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                            bracketHandle = userInteractionCallbackPlugin.startBracket(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("MERGING_LEAF_MODULE_VERSION"), new Object[]{referencePathSrc, this.referencePath}));
                            workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersionDest);
                            if (!workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirUserModuleVersion)) {
                                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_CREATE_NEW_NO_PATH, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                                try {
                                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("CHECKING_OUT_MODULE_VERSION"), new Object[]{moduleVersionDest, pathModuleWorkspace}));
                                    scmPlugin.checkout(moduleVersionDest.getVersion(), pathModuleWorkspace);
                                }
                                catch (RuntimeException re) {
                                    workspacePlugin.deleteWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion);
                                    pathModuleWorkspace = null;
                                    throw re;
                                }
                                finally {
                                    if (pathModuleWorkspace != null) {
                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                    }
                                }
                            } else {
                                pathModuleWorkspace = workspacePlugin.getWorkspaceDir((WorkspaceDir)workspaceDirUserModuleVersion, WorkspacePlugin.GetWorkspaceDirMode.ENUM_SET_GET_EXISTING, WorkspacePlugin.WorkspaceDirAccessMode.READ_WRITE);
                            }
                            MergeReferenceGraph.logger.info("Building list of version-changing commits to exclude before merging source ModuleVersion " + moduleVersionSrc + " into destination ModuleVersion " + moduleVersionDest + '.');
                            listCommit = scmPlugin.getListCommitDiverge(moduleVersionSrc.getVersion(), moduleVersionDest.getVersion(), null, EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR));
                            iteratorCommit = listCommit.iterator();
                            while (iteratorCommit.hasNext()) {
                                commit = (ScmPlugin.Commit)iteratorCommit.next();
                                if (commit.mapAttr.containsKey("dragom-version-change") || commit.mapAttr.containsKey("dragom-reference-version-change")) continue;
                                iteratorCommit.remove();
                            }
                            if (listCommit.isEmpty()) {
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST"), new Object[]{moduleVersionSrc, moduleVersionDest, pathModuleWorkspace}));
                            } else {
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SHALLOW_MERGING_SRC_MODULE_VERSION_INTO_DEST_EXCLUDING_VERSION_CHANGING_COMMITS"), new Object[]{moduleVersionSrc, moduleVersionDest, pathModuleWorkspace, listCommit}));
                            }
                            if (Util.handleDoYouWantToContinue("MERGE")) break block59;
                            commit = true;
                            if (pathModuleWorkspace == null) break block60;
                            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                        }
                        if (pathModuleWorkspaceSrc != null) {
                            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                        }
                        this.referencePath.removeLeafReference();
                        if (bracketHandle != null) {
                            bracketHandle.close();
                        }
                        return commit;
                    }
                    if (scmPlugin.merge(pathModuleWorkspace, moduleVersionSrc.getVersion(), listCommit, null)) break block61;
                    this.listActionsPerformed.add(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SRC_MERGED_INTO_DEST_CONFLICTS"), new Object[]{moduleVersionSrc, moduleVersionDest, pathModuleWorkspace}));
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("MERGE_CONFLICTS_WHILE_MERGING_SRC_MODULE_VERSION_INTO_DEST"), new Object[]{moduleVersionSrc, moduleVersionDest, pathModuleWorkspace}));
                    MergeReferenceGraph.handleContinueOnMergeConflicts();
                    commit = true;
                    if (pathModuleWorkspace == null) break block62;
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                }
                if (pathModuleWorkspaceSrc != null) {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                }
                this.referencePath.removeLeafReference();
                if (bracketHandle != null) {
                    bracketHandle.close();
                }
                return commit;
            }
            try {
                this.listActionsPerformed.add(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SRC_MERGED_INTO_DEST"), new Object[]{moduleVersionSrc, moduleVersionDest, pathModuleWorkspace}));
                if (!module.isNodePluginExists(ReferenceManagerPlugin.class, null)) break block63;
                referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
                listReferenceDest = referenceManagerPlugin.getListReference(pathModuleWorkspace);
                pathModuleWorkspaceSrc = scmPlugin.checkoutSystem(moduleVersionSrc.getVersion());
                listReferenceSrc = referenceManagerPlugin.getListReference(pathModuleWorkspaceSrc);
                for (Reference referenceChildDest : listReferenceDest) {
                    referenceChildSrc = null;
                    if (referenceChildDest.getModuleVersion() == null) {
                        MergeReferenceGraph.logger.info("Reference " + referenceChildDest + " within ReferencePath " + this.referencePath + " does not include a source reference known to Dragom. It is not processed.");
                        continue;
                    }
                    for (Reference referenceSrc : listReferenceSrc) {
                        if (!referenceSrc.equalsNoVersion(referenceDest)) continue;
                        referenceChildSrc = referenceSrc;
                        break;
                    }
                    if (referenceChildSrc == null) {
                        MergeReferenceGraph.logger.info("A reference in the source ModuleVersion " + moduleVersionSrc + " in " + pathModuleWorkspaceSrc + " corresponding to reference " + referenceChildDest + " in the destination ModuleVersion " + moduleVersionDest + " in " + pathModuleWorkspace + " could not be found. Destination reference skipped.");
                        continue;
                    }
                    if (referenceChildSrc.getModuleVersion().getVersion().equals((Object)referenceChildDest.getModuleVersion().getVersion())) {
                        MergeReferenceGraph.logger.info("The reference source ModuleVersion " + referenceChildSrc.getModuleVersion() + " is the same as that in the destination. Not recursing.");
                        continue;
                    }
                    if (referenceChildSrc.getModuleVersion().getVersion().getVersionType() != VersionType.STATIC || referenceChildDest.getModuleVersion().getVersion().getVersionType() != VersionType.STATIC) ** GOTO lbl167
                    byReferenceBooleanSrcDiverges = new ByReference();
                    byReferenceBooleanDestDiverges = new ByReference();
                    this.verifyDivergences(referenceChildDest.getModuleVersion().getNodePath(), referenceChildSrc.getModuleVersion().getVersion(), referenceChildDest.getModuleVersion().getVersion(), (ByReference<Boolean>)byReferenceBooleanSrcDiverges, (ByReference<Boolean>)byReferenceBooleanDestDiverges);
                    if (!((Boolean)byReferenceBooleanSrcDiverges.object).booleanValue()) ** GOTO lbl243
                    if (!((Boolean)byReferenceBooleanDestDiverges.object).booleanValue()) break block64;
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("BOTH_SRC_AND_DEST_STATIC_REFERENCE_DIVERGE"), new Object[]{referencePathSrc, referenceChildSrc, this.referencePath, referenceChildDest}));
                    MergeReferenceGraph.handleContinueOnMergeConflicts();
                    var25_31 = true;
                    if (pathModuleWorkspace == null) break block65;
                }
            }
            catch (Throwable var34_44) {
                if (pathModuleWorkspace != null) {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                }
                if (pathModuleWorkspaceSrc != null) {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                }
                this.referencePath.removeLeafReference();
                if (bracketHandle != null) {
                    bracketHandle.close();
                }
                throw var34_44;
            }
            {
                block74: {
                    block75: {
                        block72: {
                            block73: {
                                block70: {
                                    block71: {
                                        block68: {
                                            block69: {
                                                block66: {
                                                    block67: {
                                                        block64: {
                                                            block65: {
                                                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                                            }
                                                            if (pathModuleWorkspaceSrc != null) {
                                                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                                                            }
                                                            this.referencePath.removeLeafReference();
                                                            if (bracketHandle != null) {
                                                                bracketHandle.close();
                                                            }
                                                            return var25_31;
                                                        }
                                                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SRC_STATIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE"), new Object[]{referencePathSrc, referenceChildSrc, this.referencePath, referenceChildDest}));
                                                        if (Util.handleDoYouWantToContinue("UPDATE_REFERENCE")) break block66;
                                                        var27_35 = true;
                                                        if (pathModuleWorkspace == null) break block67;
                                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                                    }
                                                    if (pathModuleWorkspaceSrc != null) {
                                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                                                    }
                                                    this.referencePath.removeLeafReference();
                                                    if (bracketHandle != null) {
                                                        bracketHandle.close();
                                                    }
                                                    return var27_35;
                                                }
                                                if (!referenceManagerPlugin.updateReferenceVersion(pathModuleWorkspace, referenceChildDest, referenceChildSrc.getModuleVersion().getVersion(), null)) {
                                                    throw new RuntimeException("Updating the version of reference " + referenceChildDest + " in " + pathModuleWorkspace + " to the ArtifactVersion equivalent to " + referenceChildSrc.getModuleVersion().getVersion() + " did not result in any change. This is unexpected in the context of this job.");
                                                }
                                                message = MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("CHANGE_DEST_REFERENCE_VERSION"), new Object[]{this.referencePath, referenceChildDest, referenceChildSrc.getModuleVersion().getVersion()});
                                                mapCommitAttr = new HashMap<String, String>();
                                                mapCommitAttr.put("dragom-reference-version-change", "true");
                                                scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                                                userInteractionCallbackPlugin.provideInfo(message);
                                                this.listActionsPerformed.add(message);
                                                message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), new Object[]{pathModuleWorkspace});
                                                userInteractionCallbackPlugin.provideInfo(message);
                                                this.listActionsPerformed.add(message);
                                                ** GOTO lbl243
lbl167:
                                                // 1 sources

                                                if (referenceChildSrc.getModuleVersion().getVersion().getVersionType() != VersionType.DYNAMIC || referenceChildDest.getModuleVersion().getVersion().getVersionType() != VersionType.STATIC) ** GOTO lbl243
                                                byReferenceBooleanSrcDiverges = new ByReference();
                                                byReferenceBooleanDestDiverges = new ByReference();
                                                this.verifyDivergences(referenceChildDest.getModuleVersion().getNodePath(), referenceChildSrc.getModuleVersion().getVersion(), referenceChildDest.getModuleVersion().getVersion(), (ByReference<Boolean>)byReferenceBooleanSrcDiverges, (ByReference<Boolean>)byReferenceBooleanDestDiverges);
                                                if (!((Boolean)byReferenceBooleanSrcDiverges.object).booleanValue()) ** GOTO lbl243
                                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("SRC_DYNAMIC_REFERENCE_DIVERGES_FROM_DEST_STATIC_REFERENCE"), new Object[]{referencePathSrc, referenceChildSrc, this.referencePath, referenceChildDest}));
                                                if (((Boolean)byReferenceBooleanDestDiverges.object).booleanValue()) {
                                                    userInteractionCallbackPlugin.provideInfo(MergeReferenceGraph.resourceBundle.getString("DEST_STATIC_REFERENCE_ALSO_DIVERGES_FROM_SRC_DYNAMIC_REFERENCE"));
                                                }
                                                listModuleVersion = new ArrayList<ModuleVersion>();
                                                listModuleVersion.add(referenceChildDest.getModuleVersion());
                                                switchToDynamicVersion = new SwitchToDynamicVersion(listModuleVersion);
                                                switchToDynamicVersion.performJob();
                                                if (switchToDynamicVersion.isListModuleVersionRootChanged()) break block68;
                                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("DEST_STATIC_VERSION_NOT_SWITCHED"), new Object[]{this.referencePath, referenceChildDest}));
                                                MergeReferenceGraph.handleContinueOnMergeConflicts();
                                                var32_40 = true;
                                                if (pathModuleWorkspace == null) break block69;
                                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                            }
                                            if (pathModuleWorkspaceSrc != null) {
                                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                                            }
                                            this.referencePath.removeLeafReference();
                                            if (bracketHandle != null) {
                                                bracketHandle.close();
                                            }
                                            return var32_40;
                                        }
                                        versionDynamicNew = ((ModuleVersion)listModuleVersion.get(0)).getVersion();
                                        byReferenceBooleanOldDestDiverges = new ByReference();
                                        this.verifyDivergences(referenceChildDest.getModuleVersion().getNodePath(), referenceChildDest.getModuleVersion().getVersion(), versionDynamicNew, (ByReference<Boolean>)byReferenceBooleanOldDestDiverges, null);
                                        if (((Boolean)byReferenceBooleanOldDestDiverges.object).booleanValue()) {
                                            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("NEW_DEST_DYNAMIC_VERSION_DOES_NOT_INCLUDE_ORIGINALLY_DIVERGING_COMMITS"), new Object[]{referencePathSrc, referenceChildSrc, this.referencePath, referenceChildDest, versionDynamicNew}));
                                        }
                                        if (Util.handleDoYouWantToContinue("MAY_LOOSE_COMMITS")) break block70;
                                        var32_41 = true;
                                        if (pathModuleWorkspace == null) break block71;
                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                    }
                                    if (pathModuleWorkspaceSrc != null) {
                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                                    }
                                    this.referencePath.removeLeafReference();
                                    if (bracketHandle != null) {
                                        bracketHandle.close();
                                    }
                                    return var32_41;
                                }
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("DEST_REFERENCE_WILL_BE_CHANGED"), new Object[]{this.referencePath, referenceChildDest, versionDynamicNew}));
                                if (Util.handleDoYouWantToContinue("UPDATE_REFERENCE")) break block72;
                                var32_42 = true;
                                if (pathModuleWorkspace == null) break block73;
                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                            }
                            if (pathModuleWorkspaceSrc != null) {
                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                            }
                            this.referencePath.removeLeafReference();
                            if (bracketHandle != null) {
                                bracketHandle.close();
                            }
                            return var32_42;
                        }
                        byReferenceReference = new ByReference();
                        if (!referenceManagerPlugin.updateReferenceVersion(pathModuleWorkspace, referenceChildDest, versionDynamicNew, byReferenceReference)) {
                            throw new RuntimeException("Updating the version of reference " + referenceChildDest + " in " + pathModuleWorkspace + " to the ArtifactVersion equivalent to " + referenceChildSrc.getModuleVersion().getVersion() + " did not result in any change. This is unexpected in the context of this job.");
                        }
                        message = MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("CHANGE_DEST_REFERENCE_VERSION"), new Object[]{this.referencePath, referenceChildDest, versionDynamicNew});
                        mapCommitAttr = new HashMap<String, String>();
                        mapCommitAttr.put("dragom-reference-version-change", "true");
                        scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                        userInteractionCallbackPlugin.provideInfo(message);
                        this.listActionsPerformed.add(message);
                        message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), new Object[]{pathModuleWorkspace});
                        userInteractionCallbackPlugin.provideInfo(message);
                        this.listActionsPerformed.add(message);
                        referenceChildDest = (Reference)byReferenceReference.object;
lbl243:
                        // 5 sources

                        if (referenceChildDest.getModuleVersion().getVersion().getVersionType() != VersionType.DYNAMIC) continue;
                        referencePathSrc.add(referenceChildSrc);
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(MergeReferenceGraph.resourceBundle.getString("RECURSIVELY_MERGING_SRC_DYNAMIC_REFERENCE_INTO_DEST_DYNAMIC_REFERENCE"), new Object[]{referencePathSrc, referenceChildSrc, this.referencePath, referenceChildDest}));
                        if (!this.mergeModuleVersion(referencePathSrc, referenceChildDest)) break block74;
                        var25_32 = true;
                        referencePathSrc.removeLeafReference();
                        if (pathModuleWorkspace == null) break block75;
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    }
                    if (pathModuleWorkspaceSrc != null) {
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                    }
                    this.referencePath.removeLeafReference();
                    if (bracketHandle != null) {
                        bracketHandle.close();
                    }
                    return var25_32;
                }
                referencePathSrc.removeLeafReference();
                continue;
                {
                    catch (Throwable var33_43) {
                        referencePathSrc.removeLeafReference();
                        throw var33_43;
                    }
                }
            }
        }
        if (pathModuleWorkspace != null) {
            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
        }
        if (pathModuleWorkspaceSrc != null) {
            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
        }
        this.referencePath.removeLeafReference();
        if (bracketHandle != null) {
            bracketHandle.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyDivergences(NodePath nodePathModule, Version versionSrc, Version versionDest, ByReference<Boolean> byReferenceBooleanSrcDiverges, ByReference<Boolean> byReferenceBooleanDestDiverges) {
        block19: {
            ExecContext execContext = ExecContextHolder.get();
            UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
            WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
            Model model = execContext.getModel();
            Path pathModuleWorkspaceDest = null;
            Path pathModuleWorkspaceSrc = null;
            try {
                ScmPlugin.Commit commit;
                Iterator iterCommit;
                List listCommit;
                ModuleVersion moduleVersionDest = new ModuleVersion(nodePathModule, versionDest);
                ModuleVersion moduleVersionSrc = new ModuleVersion(nodePathModule, versionSrc);
                Module module = model.getModule(nodePathModule);
                ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                if (byReferenceBooleanSrcDiverges != null) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERIFYING_SRC_DIVERGES_FROM_DEST_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    listCommit = scmPlugin.getListCommitDiverge(versionSrc, versionDest, null, EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR, ScmPlugin.GetListCommitFlag.IND_INCLUDE_MESSAGE));
                    iterCommit = listCommit.iterator();
                    while (iterCommit.hasNext()) {
                        commit = (ScmPlugin.Commit)iterCommit.next();
                        if (commit.mapAttr.containsKey("dragom-version-change") || commit.mapAttr.containsKey("dragom-reference-version-change")) continue;
                        iterCommit.remove();
                    }
                    if (listCommit.isEmpty()) {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_DIVERGENCES_FOUND_IN_SRC_COMPARED_TO_DEST_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    } else {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SRC_DIVERGES_FROM_DEST_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    }
                    byReferenceBooleanSrcDiverges.object = !listCommit.isEmpty();
                }
                if (byReferenceBooleanDestDiverges != null) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERIFYING_DEST_DIVERGES_FROM_SRC_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    listCommit = scmPlugin.getListCommitDiverge(versionDest, versionSrc, null, EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR, ScmPlugin.GetListCommitFlag.IND_INCLUDE_MESSAGE));
                    iterCommit = listCommit.iterator();
                    while (iterCommit.hasNext()) {
                        commit = (ScmPlugin.Commit)iterCommit.next();
                        if (commit.mapAttr.containsKey("dragom-version-change") || commit.mapAttr.containsKey("dragom-reference-version-change")) continue;
                        iterCommit.remove();
                    }
                    if (listCommit.isEmpty()) {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_DIVERGENCES_FOUND_IN_DEST_COMPARED_TO_SRC_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    } else {
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DEST_DIVERGES_FROM_SRC_MODULE_VERSION), moduleVersionSrc, moduleVersionDest));
                    }
                    byReferenceBooleanDestDiverges.object = !listCommit.isEmpty();
                }
                if ((byReferenceBooleanSrcDiverges == null || ((Boolean)byReferenceBooleanSrcDiverges.object).booleanValue()) && (byReferenceBooleanDestDiverges == null || ((Boolean)byReferenceBooleanDestDiverges.object).booleanValue())) break block19;
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_DIVERGENCES_BETWEEN_SRC_AND_DEST_MODULE_VERSIONS), moduleVersionSrc, moduleVersionDest));
                pathModuleWorkspaceDest = scmPlugin.checkoutSystem(versionDest);
                pathModuleWorkspaceSrc = scmPlugin.checkoutSystem(versionSrc);
                if (!module.isNodePluginExists(ReferenceManagerPlugin.class, null)) break block19;
                ReferenceManagerPlugin referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
                List listReferenceDest = referenceManagerPlugin.getListReference(pathModuleWorkspaceDest);
                List listReferenceSrc = referenceManagerPlugin.getListReference(pathModuleWorkspaceSrc);
                for (Reference referenceChildDest : listReferenceDest) {
                    Reference referenceChildSrc = null;
                    if (referenceChildDest.getModuleVersion() == null) {
                        logger.info("Reference " + referenceChildDest + " does not include a source reference known to Dragom. It is not processed.");
                        continue;
                    }
                    for (Reference referenceSrc : listReferenceSrc) {
                        if (!referenceSrc.equalsNoVersion(referenceChildDest)) continue;
                        referenceChildSrc = referenceSrc;
                        break;
                    }
                    if (referenceChildSrc == null) {
                        logger.info("A reference in the source ModuleVersion " + moduleVersionSrc + " in " + pathModuleWorkspaceSrc + " corresponding to reference " + referenceChildDest + " in the destination ModuleVersion " + moduleVersionDest + " in " + pathModuleWorkspaceDest + " could not be found. Destination reference skipped.");
                        continue;
                    }
                    if (referenceChildSrc.getModuleVersion().getVersion().equals((Object)referenceChildDest.getModuleVersion().getVersion())) {
                        logger.info("The reference source ModuleVersion " + referenceChildSrc.getModuleVersion() + " is the same as that in the destination. Not recursing.");
                        continue;
                    }
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_RECURSIVELY_VERIFYING_DIVERGENCES_BETWEEN_SRC_AND_DEST_REFERENCES), referenceChildSrc, referenceChildDest));
                    this.verifyDivergences(referenceChildDest.getModuleVersion().getNodePath(), referenceChildSrc.getModuleVersion().getVersion(), referenceChildDest.getModuleVersion().getVersion(), byReferenceBooleanSrcDiverges, byReferenceBooleanDestDiverges);
                    if (byReferenceBooleanSrcDiverges == null || !((Boolean)byReferenceBooleanSrcDiverges.object).booleanValue()) {
                        if (byReferenceBooleanDestDiverges == null || !((Boolean)byReferenceBooleanDestDiverges.object).booleanValue()) continue;
                    }
                    break;
                }
            }
            finally {
                if (pathModuleWorkspaceSrc != null) {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceSrc);
                }
                if (pathModuleWorkspaceDest != null) {
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspaceDest);
                }
            }
        }
    }

    private static void handleContinueOnMergeConflicts() {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponseContinueOnMergeConflicts = Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CONTINUE_ON_MERGE_CONFLICTS, userInteractionCallbackPlugin, resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUE_NEXT_MATCHING_DEST_MODULE_VERSION));
        switch (alwaysNeverAskUserResponseContinueOnMergeConflicts) {
            case ALWAYS: {
                userInteractionCallbackPlugin.provideInfo(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_CONTINUING_NEXT_MATCHING_DEST_MODULE_VERSION));
                break;
            }
            case NEVER: {
                Util.setAbort();
                break;
            }
        }
    }

    private static class ModuleVersionMerge {
        ModuleVersion moduleVersionDest;
        Version versionSrc;

        public ModuleVersionMerge(ModuleVersion moduleVersionDest, Version versionSrc) {
            this.moduleVersionDest = moduleVersionDest;
            this.versionSrc = versionSrc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.moduleVersionDest.hashCode();
            result = 31 * result + this.versionSrc.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModuleVersionMerge)) {
                return false;
            }
            ModuleVersionMerge moduleVersionMergeOther = (ModuleVersionMerge)other;
            if (!this.moduleVersionDest.equals((Object)moduleVersionMergeOther.moduleVersionDest)) {
                return false;
            }
            return this.versionSrc.equals((Object)moduleVersionMergeOther.versionSrc);
        }
    }
}

