/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDir;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ArtifactVersionManagerPlugin;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.BuilderPlugin;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectStaticVersionPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.util.AlwaysNeverYesNoAskUserResponse;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Release
extends RootModuleVersionJobAbstractImpl {
    private static final Logger logger = LoggerFactory.getLogger(Release.class);
    private static final String RUNTIME_PROPERTY_RELEASE_ISOLATION_MODE = "RELEASE_ISOLATION_MODE";
    private static final String RUNTIME_PROPERTY_RELEASE_VERSION_BUILD_CONTEXT = "RELEASE_VERSION_BUILD_CONTEXT";
    private static final String RUNTIME_PROPERTY_IND_NO_PRE_RELEASE_VERSION_VALIDATION_BUILD = "IND_NO_PRE_RELEASE_VERSION_VALIDATION_BUILD";
    private static final String RUNTIME_PROPERTY_REVERT_ARTIFACT_VERSION = "REVERT_ARTIFACT_VERSION";
    private static final String MSG_PATTERN_KEY_REUSING_ALREADY_SELECTED_STATIC_VERSION = "REUSING_ALREADY_SELECTED_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_PARENT_WILL_BE_UPDATED_BECAUSE_REFERENCE_CHANGED = "PARENT_WILL_BE_UPDATED_BECAUSE_REFERENCE_CHANGED";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY = "MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY";
    private static final String MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION = "CHANGE_REFERENCE_VERSION";
    private static final String MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE = "CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE";
    private static final String MSG_PATTERN_KEY_REFERENCE_DYNAMIC_VERSION_EXTERNAL_MODULE = "REFERENCE_DYNAMIC_VERSION_EXTERNAL_MODULE";
    private static final String MSG_PATTERN_KEY_COMMIT_REFERENCE_CHANGE_AFTER_ABORT = "COMMIT_REFERENCE_CHANGE_AFTER_ABORT";
    private static final String MSG_PATTERN_KEY_TEMP_DYNAMIC_VERSION_CREATED = "TEMP_DYNAMIC_VERSION_CREATED";
    private static final String MSG_PATTERN_KEY_REFERENCES_UPDATED = "REFERENCES_UPDATED";
    private static final String MSG_PATTERN_KEY_EXISTING_STATIC_VERSION_SELECTED = "EXISTING_STATIC_VERSION_SELECTED";
    private static final String MSG_PATTERN_KEY_CREATING_NEW_STATIC_VERSION = "CREATING_NEW_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_ARTIFACT_VERSION_CHANGED = "ARTIFACT_VERSION_CHANGED";
    private static final String MSG_PATTERN_KEY_NO_ARTIFACT_VERSION_CHANGE = "NO_ARTIFACT_VERSION_CHANGE";
    private static final String MSG_PATTERN_KEY_INITIATING_BUILD = "INITIATING_BUILD";
    private static final String MSG_PATTERN_KEY_BUILD_FAILED = "BUILD_FAILED";
    private static final String MSG_PATTERN_KEY_STATIC_VERSION_CREATED = "STATIC_VERSION_CREATED";
    private static final String MSG_PATTERN_KEY_DO_YOU_WANT_TO_REVERT_ARTIFACT_VERSION = "DO_YOU_WANT_TO_REVERT_ARTIFACT_VERSION";
    private static final String MSG_PATTERN_KEY_ARTIFACT_VERSION_REVERTED = "ARTIFACT_VERSION_REVERTED";
    private static final String MSG_PATTERN_KEY_NO_REVERTED_ARTIFACT_VERSION_CHANGE = "NO_REVERTED_ARTIFACT_VERSION_CHANGE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(Release.class.getName() + "ResourceBundle");
    private Map<ModuleVersion, Version> mapModuleVersionStatic = new HashMap<ModuleVersion, Version>();

    public Release(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
    }

    @Override
    protected boolean visitModuleVersion(Reference reference, ByReference<Version> byReferenceVersion) {
        return this.visitModuleVersionInternal(reference, byReferenceVersion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean visitModuleVersionInternal(Reference reference, ByReference<Version> byReferenceVersion, boolean indRelease) {
        block45: {
            block46: {
                block41: {
                    block44: {
                        block42: {
                            block43: {
                                block39: {
                                    block40: {
                                        pathModuleWorkspace = null;
                                        if (reference.getModuleVersion().getVersion().getVersionType() != VersionType.DYNAMIC) {
                                            if (indRelease) {
                                                throw new RuntimeException("ModuleVersion " + reference.getModuleVersion() + " within ReferencePath " + this.referencePath + " is not dynamic.");
                                            }
                                            return false;
                                        }
                                        execContext = ExecContextHolder.get();
                                        userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
                                        workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
                                        runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
                                        module = execContext.getModel().getModule(reference.getModuleVersion().getNodePath());
                                        scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                                        this.referencePath.add(reference);
                                        bracketHandle = null;
                                        indTempDynamicVersionCreated = false;
                                        bracketHandle = userInteractionCallbackPlugin.startBracket(MessageFormat.format(RootModuleVersionJobAbstractImpl.resourceBundle.getString("VISITING_LEAF_MODULE_VERSION"), new Object[]{this.referencePath, reference.getModuleVersion()}));
                                        if (!this.handleAlreadyCreatedStaticVersion(reference.getModuleVersion(), byReferenceVersion)) break block39;
                                        var15_13 = true;
                                        if (!indTempDynamicVersionCreated) break block40;
                                        scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
                                    }
                                    if (pathModuleWorkspace != null) {
                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                    }
                                    this.referencePath.removeLeafReference();
                                    if (bracketHandle != null) {
                                        bracketHandle.close();
                                    }
                                    return var15_13;
                                }
                                try {
                                    if (!indRelease && this.getReferencePathMatcher().matches(this.referencePath)) {
                                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(RootModuleVersionJobAbstractImpl.resourceBundle.getString("VISITING_LEAF_REFERENCE_MATCHED"), new Object[]{this.referencePath}));
                                        indRelease = true;
                                    }
                                    releaseIsolationMode = (property = runtimePropertiesPlugin.getProperty((Node)module, "RELEASE_ISOLATION_MODE")) == null ? ReleaseIsolationMode.NONE : ReleaseIsolationMode.valueOf(property);
                                    if (!indRelease && !this.getReferencePathMatcher().canMatchChildren(this.referencePath)) break block41;
                                    referenceManagerPlugin = null;
                                    pathModuleWorkspace = scmPlugin.checkoutSystem(reference.getModuleVersion().getVersion());
                                    if (!scmPlugin.isSync(pathModuleWorkspace, ScmPlugin.IsSyncFlag.ALL_CHANGES)) {
                                        throw new RuntimeExceptionUserError(MessageFormat.format(Util.getLocalizedMsgPattern("WORKSPACE_DIRECTORY_NOT_SYNC"), new Object[]{pathModuleWorkspace}));
                                    }
                                    indUserWorkspaceDir = workspacePlugin.getWorkspaceDirFromPath(pathModuleWorkspace) instanceof WorkspaceDirUserModuleVersion;
                                    if (indUserWorkspaceDir) {
                                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Release.resourceBundle.getString("MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY"), new Object[]{reference.getModuleVersion(), pathModuleWorkspace}));
                                    }
                                    if (!module.isNodePluginExists(ReferenceManagerPlugin.class, null)) {
                                        listReference = Collections.emptyList();
                                    } else {
                                        referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
                                        listReference = referenceManagerPlugin.getListReference(pathModuleWorkspace);
                                    }
                                    indReferenceUpdated = false;
                                    indAbort = false;
                                    byReferenceReference = new ByReference();
                                    for (Reference referenceChild : listReference) {
                                        if (referenceChild.getModuleVersion() == null) {
                                            if (referenceChild.getArtifactVersion().getVersionType() == VersionType.DYNAMIC) {
                                                throw new RuntimeExceptionUserError(MessageFormat.format(Release.resourceBundle.getString("REFERENCE_DYNAMIC_VERSION_EXTERNAL_MODULE"), new Object[]{this.referencePath, referenceChild}));
                                            }
                                            Release.logger.info("Reference " + referenceChild + " within ReferencePath " + this.referencePath + " does not include a source reference known to Dragom. It is not processed.");
                                            continue;
                                        }
                                        if (referenceChild.getModuleVersion().getVersion().getVersionType() == VersionType.STATIC) continue;
                                        Release.logger.info("Processing reference " + referenceChild + " within ReferencePath " + this.referencePath + '.');
                                        byReferenceVersionChild = new ByReference();
                                        indVersionChanged = this.visitModuleVersionInternal(referenceChild, (ByReference<Version>)byReferenceVersionChild, indRelease);
                                        if (indRelease) {
                                            if (!indVersionChanged) {
                                                indAbort = true;
                                                break;
                                            }
                                        } else if (Util.isAbort()) {
                                            indAbort = true;
                                            break;
                                        }
                                        if (!indVersionChanged) continue;
                                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Release.resourceBundle.getString("PARENT_WILL_BE_UPDATED_BECAUSE_REFERENCE_CHANGED"), new Object[]{this.referencePath, referenceChild, byReferenceVersionChild.object}));
                                        if (!Util.handleDoYouWantToContinue("UPDATE_REFERENCE")) {
                                            indAbort = true;
                                            break;
                                        }
                                        if (referenceManagerPlugin.updateReferenceVersion(pathModuleWorkspace, referenceChild, (Version)byReferenceVersionChild.object, byReferenceReference)) {
                                            message = MessageFormat.format(Release.resourceBundle.getString("CHANGE_REFERENCE_VERSION"), new Object[]{this.referencePath, referenceChild, byReferenceVersionChild.object, byReferenceReference});
                                            userInteractionCallbackPlugin.provideInfo(message);
                                            this.listActionsPerformed.add(message);
                                            indReferenceUpdated = true;
                                            continue;
                                        }
                                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Release.resourceBundle.getString("CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE"), new Object[]{this.referencePath, referenceChild, byReferenceVersionChild.object}));
                                    }
                                    if (!indReferenceUpdated) ** GOTO lbl126
                                    if (!indAbort) break block42;
                                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Release.resourceBundle.getString("COMMIT_REFERENCE_CHANGE_AFTER_ABORT"), new Object[]{this.referencePath}));
                                    if (Util.handleDoYouWantToContinue("COMMIT_REFERENCE_CHANGE_AFTER_ABORT")) break block42;
                                    var23_27 = false;
                                    if (!indTempDynamicVersionCreated) break block43;
                                }
                                catch (Throwable var26_30) {
                                    if (indTempDynamicVersionCreated) {
                                        scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
                                    }
                                    if (pathModuleWorkspace != null) {
                                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                                    }
                                    this.referencePath.removeLeafReference();
                                    if (bracketHandle != null) {
                                        bracketHandle.close();
                                    }
                                    throw var26_30;
                                }
                                scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
                            }
                            if (pathModuleWorkspace != null) {
                                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                            }
                            this.referencePath.removeLeafReference();
                            if (bracketHandle != null) {
                                bracketHandle.close();
                            }
                            return var23_27;
                        }
                        if (releaseIsolationMode == ReleaseIsolationMode.USE_TEMP_DYNAMIC_VERSION) {
                            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(Release.resourceBundle.getString("TEMP_DYNAMIC_VERSION_CREATED"), new Object[]{this.referencePath}));
                            scmPlugin.createTempDynamicVersion(pathModuleWorkspace);
                            indTempDynamicVersionCreated = true;
                        }
                        message = MessageFormat.format(Release.resourceBundle.getString("REFERENCES_UPDATED"), new Object[]{this.referencePath});
                        mapCommitAttr = new HashMap<String, String>();
                        mapCommitAttr.put("dragom-reference-version-change", "true");
                        scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                        userInteractionCallbackPlugin.provideInfo(message);
                        this.listActionsPerformed.add(message);
                        if (indUserWorkspaceDir) {
                            message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), new Object[]{pathModuleWorkspace});
                            userInteractionCallbackPlugin.provideInfo(message);
                            this.listActionsPerformed.add(message);
                        } else {
                            Release.logger.info("The previous changes were performed in " + pathModuleWorkspace + " and were committed to the SCM.");
                        }
lbl126:
                        // 3 sources

                        if (!indAbort) break block41;
                        var21_24 = false;
                        if (!indTempDynamicVersionCreated) break block44;
                        scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
                    }
                    if (pathModuleWorkspace != null) {
                        workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    }
                    this.referencePath.removeLeafReference();
                    if (bracketHandle != null) {
                        bracketHandle.close();
                    }
                    return var21_24;
                }
                if (!indRelease) break block45;
                indVersionChanged = this.processSelectStaticVersion(pathModuleWorkspace, reference.getModuleVersion(), byReferenceVersion, releaseIsolationMode, indTempDynamicVersionCreated);
                if (indVersionChanged) {
                    indTempDynamicVersionCreated = false;
                }
                var16_18 = indVersionChanged;
                if (!indTempDynamicVersionCreated) break block46;
                scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
            }
            if (pathModuleWorkspace != null) {
                workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
            }
            this.referencePath.removeLeafReference();
            if (bracketHandle != null) {
                bracketHandle.close();
            }
            return var16_18;
        }
        if (indTempDynamicVersionCreated) {
            scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
        }
        if (pathModuleWorkspace != null) {
            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
        }
        this.referencePath.removeLeafReference();
        if (bracketHandle != null) {
            bracketHandle.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processSelectStaticVersion(Path pathModuleWorkspace, ModuleVersion moduleVersion, ByReference<Version> byReferenceVersion, ReleaseIsolationMode releaseIsolationMode, boolean indTempDynamicVersionCreated) {
        ArtifactVersion artifactVersion = null;
        ArtifactVersion artifactVersionPrevious = null;
        ArtifactVersionManagerPlugin artifactVersionManagerPlugin = null;
        ArtifactVersionMapperPlugin artifactVersionMapperPlugin = null;
        String message = null;
        ExecContext execContext = ExecContextHolder.get();
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        logger.info("Processing request to select a static version for ModuleVersion " + moduleVersion + '.');
        Module module = execContext.getModel().getModule(moduleVersion.getNodePath());
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        SelectStaticVersionPlugin selectStaticVersionPlugin = (SelectStaticVersionPlugin)module.getNodePlugin(SelectStaticVersionPlugin.class, null);
        Version versionStaticSelected = selectStaticVersionPlugin.selectStaticVersion(moduleVersion.getVersion());
        if (versionStaticSelected == null) {
            return false;
        }
        if (scmPlugin.isVersionExists(versionStaticSelected)) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_EXISTING_STATIC_VERSION_SELECTED), moduleVersion, versionStaticSelected));
            this.mapModuleVersionStatic.put(moduleVersion, versionStaticSelected);
            byReferenceVersion.object = versionStaticSelected;
            return true;
        }
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
        WorkspaceDirUserModuleVersion workspaceDirUserModuleVersion = new WorkspaceDirUserModuleVersion(moduleVersion);
        boolean indUserWorkspaceDir = workspacePlugin.isWorkspaceDirExist((WorkspaceDir)workspaceDirUserModuleVersion);
        UserInteractionCallbackPlugin.BracketHandle bracketHandle = null;
        boolean indTempDynamicVersionCreatedLocally = false;
        try {
            HashMap<String, String> mapVersionAttr;
            String projectCode;
            bracketHandle = userInteractionCallbackPlugin.startBracket(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CREATING_NEW_STATIC_VERSION), moduleVersion, versionStaticSelected));
            if (!Util.handleDoYouWantToContinue("CREATE_STATIC_VERSION")) {
                boolean bl = false;
                return bl;
            }
            boolean indCommitRequired = false;
            if (!module.isNodePluginExists(ArtifactVersionManagerPlugin.class, null)) {
                logger.info("The module " + module + " does not expose the ArtifactVersionManagerPlugin plugin which implies that it does not manage artifact version and that there is no need to update it.");
            } else {
                artifactVersionManagerPlugin = (ArtifactVersionManagerPlugin)module.getNodePlugin(ArtifactVersionManagerPlugin.class, null);
                artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)module.getNodePlugin(ArtifactVersionMapperPlugin.class, null);
                artifactVersion = artifactVersionMapperPlugin.mapVersionToArtifactVersion(versionStaticSelected);
                artifactVersionPrevious = artifactVersionManagerPlugin.getArtifactVersion(pathModuleWorkspace);
                indCommitRequired = artifactVersionManagerPlugin.setArtifactVersion(pathModuleWorkspace, artifactVersion);
                if (indCommitRequired) {
                    message = MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_VERSION_CHANGED), moduleVersion.getNodePath(), versionStaticSelected, artifactVersionPrevious, artifactVersion);
                    userInteractionCallbackPlugin.provideInfo(message);
                } else {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_ARTIFACT_VERSION_CHANGE), moduleVersion, artifactVersion, versionStaticSelected));
                }
            }
            if (!Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_IND_NO_PRE_RELEASE_VERSION_VALIDATION_BUILD)) && module.isNodePluginExists(BuilderPlugin.class, null)) {
                boolean indBuildSuccessful;
                BuilderPlugin builderPlugin = (BuilderPlugin)module.getNodePlugin(BuilderPlugin.class, null);
                String buildContext = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_RELEASE_VERSION_BUILD_CONTEXT);
                try (Writer writerLog = userInteractionCallbackPlugin.provideInfoWithWriter(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INITIATING_BUILD), moduleVersion, pathModuleWorkspace, versionStaticSelected));){
                    indBuildSuccessful = builderPlugin.build(pathModuleWorkspace, buildContext, writerLog);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                if (!indBuildSuccessful) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_BUILD_FAILED), moduleVersion, pathModuleWorkspace, versionStaticSelected));
                    if (indCommitRequired) {
                        artifactVersionManagerPlugin.setArtifactVersion(pathModuleWorkspace, artifactVersionPrevious);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (indCommitRequired) {
                if (releaseIsolationMode == ReleaseIsolationMode.USE_TEMP_DYNAMIC_VERSION && !indTempDynamicVersionCreated) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_TEMP_DYNAMIC_VERSION_CREATED), this.referencePath));
                    scmPlugin.createTempDynamicVersion(pathModuleWorkspace);
                    indTempDynamicVersionCreatedLocally = true;
                }
                HashMap<String, String> mapCommitAttr = new HashMap<String, String>();
                mapCommitAttr.put("dragom-version-change", "true");
                scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                this.listActionsPerformed.add(message);
                if (indUserWorkspaceDir) {
                    message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), pathModuleWorkspace);
                    userInteractionCallbackPlugin.provideInfo(message);
                    this.listActionsPerformed.add(message);
                } else {
                    logger.info("The previous changes were performed in " + pathModuleWorkspace + " and were committed to the SCM.");
                }
            }
            if ((projectCode = this.getProjectCode()) != null) {
                mapVersionAttr = new HashMap<String, String>();
                mapVersionAttr.put("dragom-project-code", projectCode);
            } else {
                mapVersionAttr = null;
            }
            scmPlugin.createVersion(pathModuleWorkspace, versionStaticSelected, mapVersionAttr, false);
            indTempDynamicVersionCreatedLocally = false;
            message = MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATIC_VERSION_CREATED), moduleVersion, versionStaticSelected);
            userInteractionCallbackPlugin.provideInfo(message);
            this.listActionsPerformed.add(message);
            if (artifactVersionManagerPlugin != null && releaseIsolationMode == ReleaseIsolationMode.REVERT_ARTIFACT_VERSION_ASK || releaseIsolationMode == ReleaseIsolationMode.REVERT_ARTIFACT_VERSION_NO_ASK) {
                AlwaysNeverYesNoAskUserResponse alwaysNeverYesNoAskUserResponsRevertArtifactVersion = null;
                artifactVersion = artifactVersionMapperPlugin.mapVersionToArtifactVersion(moduleVersion.getVersion());
                if (!artifactVersion.equals((Object)artifactVersionManagerPlugin.getArtifactVersion(pathModuleWorkspace))) {
                    if (releaseIsolationMode == ReleaseIsolationMode.REVERT_ARTIFACT_VERSION_ASK) {
                        alwaysNeverYesNoAskUserResponsRevertArtifactVersion = Util.getInfoAlwaysNeverYesNoAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_REVERT_ARTIFACT_VERSION, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DO_YOU_WANT_TO_REVERT_ARTIFACT_VERSION), moduleVersion, artifactVersion, versionStaticSelected));
                    }
                    if (releaseIsolationMode == ReleaseIsolationMode.REVERT_ARTIFACT_VERSION_NO_ASK || alwaysNeverYesNoAskUserResponsRevertArtifactVersion.isYes()) {
                        artifactVersionManagerPlugin.setArtifactVersion(pathModuleWorkspace, artifactVersion);
                        message = MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_VERSION_REVERTED), moduleVersion, artifactVersion, versionStaticSelected);
                        HashMap<String, String> mapCommitAttr = new HashMap<String, String>();
                        mapCommitAttr.put("dragom-equivalent-static-version", versionStaticSelected.toString());
                        mapCommitAttr.put("dragom-version-change", "true");
                        scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                        userInteractionCallbackPlugin.provideInfo(message);
                        this.listActionsPerformed.add(message);
                        if (indUserWorkspaceDir) {
                            message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), pathModuleWorkspace);
                            userInteractionCallbackPlugin.provideInfo(message);
                            this.listActionsPerformed.add(message);
                        } else {
                            logger.info("The previous changes were performed in " + pathModuleWorkspace + " and were committed to the SCM.");
                        }
                    }
                } else {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NO_REVERTED_ARTIFACT_VERSION_CHANGE), moduleVersion, artifactVersion, versionStaticSelected));
                }
            }
        }
        finally {
            if (indTempDynamicVersionCreatedLocally) {
                scmPlugin.releaseTempDynamicVersion(pathModuleWorkspace);
            }
            if (bracketHandle != null) {
                bracketHandle.close();
            }
        }
        this.mapModuleVersionStatic.put(moduleVersion, versionStaticSelected);
        byReferenceVersion.object = versionStaticSelected;
        return true;
    }

    private boolean handleAlreadyCreatedStaticVersion(ModuleVersion moduleVersion, ByReference<Version> byReferenceVersion) {
        Version versionStaticSelected = this.mapModuleVersionStatic.get(moduleVersion);
        if (versionStaticSelected != null) {
            byReferenceVersion.object = versionStaticSelected;
            ((UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class)).provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REUSING_ALREADY_SELECTED_STATIC_VERSION), moduleVersion, byReferenceVersion.object));
            return true;
        }
        return false;
    }

    private static enum ReleaseIsolationMode {
        NONE,
        REVERT_ARTIFACT_VERSION_ASK,
        REVERT_ARTIFACT_VERSION_NO_ASK,
        USE_TEMP_DYNAMIC_VERSION;

    }
}

