/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.maven;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Pom {
    private Path pathPom;
    private Document documentPom;
    private String before;
    private String after;
    private Path pathPomLoaded;

    public void setPathPom(Path pathPom) {
        this.pathPom = pathPom;
    }

    public void loadPom() {
        DocumentBuilder documentBuilder;
        if (this.pathPom == null) {
            throw new RuntimeException("pathPom is null.");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/namespaces", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        try {
            this.documentPom = documentBuilder.parse(this.pathPom.toFile());
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        StringBuilder stringBuilderBefore = new StringBuilder();
        StringBuilder stringBuilderAfter = new StringBuilder();
        try {
            int aByte;
            FileInputStream inputStream = new FileInputStream(this.pathPom.toFile());
            BeforeAfterReadState beforeAfterReadState = BeforeAfterReadState.INIT;
            while ((aByte = ((InputStream)inputStream).read()) != -1) {
                switch (beforeAfterReadState) {
                    case INIT: {
                        if (aByte != 60) {
                            stringBuilderBefore.append((char)aByte);
                            break;
                        }
                        beforeAfterReadState = BeforeAfterReadState.MAYBE_BODY;
                        break;
                    }
                    case MAYBE_BODY: {
                        if (aByte == 63) {
                            stringBuilderBefore.append("<?");
                            beforeAfterReadState = BeforeAfterReadState.XML_HEADER;
                            break;
                        }
                        if (aByte == 33) {
                            aByte = ((InputStream)inputStream).read();
                            if (aByte != 45) {
                                stringBuilderBefore.append("<!").append((char)aByte);
                                beforeAfterReadState = BeforeAfterReadState.XML_HEADER;
                                break;
                            }
                            beforeAfterReadState = BeforeAfterReadState.BODY;
                            break;
                        }
                        beforeAfterReadState = BeforeAfterReadState.BODY;
                        break;
                    }
                    case XML_HEADER: {
                        if (aByte != 60) {
                            stringBuilderBefore.append((char)aByte);
                            break;
                        }
                        beforeAfterReadState = BeforeAfterReadState.MAYBE_BODY;
                        break;
                    }
                    case BODY: {
                        if (Character.isWhitespace((char)aByte)) {
                            stringBuilderAfter.append((char)aByte);
                            break;
                        }
                        stringBuilderAfter.setLength(0);
                    }
                }
            }
            ((InputStream)inputStream).close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.before = stringBuilderBefore.toString();
        this.after = stringBuilderAfter.toString();
        this.pathPomLoaded = this.pathPom;
    }

    public void savePom() {
        Transformer transformer;
        if (this.documentPom == null) {
            throw new RuntimeException("documentPom is null.");
        }
        if (this.pathPom == null) {
            throw new RuntimeException("pathPom is null.");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            FileOutputStream outputStream = new FileOutputStream(this.pathPom.toFile());
            ((OutputStream)outputStream).write(this.before.getBytes());
            transformer.transform(new DOMSource(this.documentPom), new StreamResult(outputStream));
            ((OutputStream)outputStream).write(this.after.getBytes());
            ((OutputStream)outputStream).close();
        }
        catch (IOException | TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public String getGroupId() {
        return this.getSimpleElement("project/groupId");
    }

    public String getResolvedGroupId() {
        String groupId = this.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        return this.getParentReferencedArtifact().groupId;
    }

    public String getArtifactId() {
        return this.getSimpleElement("project/artifactId");
    }

    public String getVersion() {
        String version;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            version = xPath.evaluate("/project/version", this.documentPom);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        if (version.isEmpty()) {
            return null;
        }
        return version;
    }

    public void setVersion(String version) {
        Node nodeVersion;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            nodeVersion = (Node)xPath.evaluate("/project/version", this.documentPom, XPathConstants.NODE);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        if (nodeVersion == null) {
            throw new RuntimeException("The POM " + this.pathPomLoaded + " does not contain a version element.");
        }
        nodeVersion.setTextContent(version);
    }

    public String getResolvedVersion() {
        String version = this.getVersion();
        if (version != null) {
            return version;
        }
        return this.getParentReferencedArtifact().version;
    }

    public String getSimpleElement(String elementPath) {
        String elementValue;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            elementValue = xPath.evaluate(elementPath, this.documentPom);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        if (elementValue.isEmpty()) {
            return null;
        }
        return elementValue;
    }

    public List<ReferencedArtifact> getListReferencedArtifact(EnumSet<ReferencedArtifactType> enumSetReferencedArtifactType, String filterGroupId, String filterArtifactId, String filterVersion) {
        String version;
        Node nodeDependency;
        int i;
        int length;
        NodeList nodeListDependencies;
        ReferencedArtifact referencedArtifact;
        ArrayList<ReferencedArtifact> listReferencedArtifact = new ArrayList<ReferencedArtifact>();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        if (enumSetReferencedArtifactType.contains((Object)ReferencedArtifactType.PARENT)) {
            Node nodeParent;
            try {
                nodeParent = (Node)xPath.evaluate("/project/parent", this.documentPom, XPathConstants.NODE);
            }
            catch (XPathExpressionException xpee) {
                throw new RuntimeException(xpee);
            }
            if (nodeParent != null) {
                try {
                    referencedArtifact = new ReferencedArtifact(ReferencedArtifactType.PARENT, xPath.evaluate("groupId", nodeParent), xPath.evaluate("artifactId", nodeParent), xPath.evaluate("version", nodeParent));
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (Pom.referencedArtifactFiltered(referencedArtifact, filterGroupId, filterArtifactId, filterVersion)) {
                    listReferencedArtifact.add(referencedArtifact);
                }
            }
        }
        if (enumSetReferencedArtifactType.contains((Object)ReferencedArtifactType.DEPENDENCY)) {
            try {
                nodeListDependencies = (NodeList)xPath.evaluate("/project/dependencies/dependency", this.documentPom, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpee) {
                throw new RuntimeException(xpee);
            }
            length = nodeListDependencies.getLength();
            for (i = 0; i < length; ++i) {
                nodeDependency = nodeListDependencies.item(i);
                try {
                    version = xPath.evaluate("version", nodeDependency);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (version.isEmpty()) {
                    version = null;
                }
                if (version == null) continue;
                try {
                    referencedArtifact = new ReferencedArtifact(ReferencedArtifactType.DEPENDENCY, xPath.evaluate("groupId", nodeDependency), xPath.evaluate("artifactId", nodeDependency), version);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (!Pom.referencedArtifactFiltered(referencedArtifact, filterGroupId, filterArtifactId, filterVersion)) continue;
                listReferencedArtifact.add(referencedArtifact);
            }
        }
        if (enumSetReferencedArtifactType.contains((Object)ReferencedArtifactType.DEPENDENCY_MANAGEMENT)) {
            try {
                nodeListDependencies = (NodeList)xPath.evaluate("/project/dependencyManagement/dependency", this.documentPom, XPathConstants.NODESET);
            }
            catch (XPathExpressionException xpee) {
                throw new RuntimeException(xpee);
            }
            length = nodeListDependencies.getLength();
            for (i = 0; i < length; ++i) {
                nodeDependency = nodeListDependencies.item(i);
                try {
                    version = xPath.evaluate("version", nodeDependency);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (version == null) continue;
                try {
                    referencedArtifact = new ReferencedArtifact(ReferencedArtifactType.DEPENDENCY_MANAGEMENT, xPath.evaluate("groupId", nodeDependency), xPath.evaluate("artifactId", nodeDependency), version);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (!Pom.referencedArtifactFiltered(referencedArtifact, filterGroupId, filterArtifactId, filterVersion)) continue;
                listReferencedArtifact.add(referencedArtifact);
            }
        }
        return listReferencedArtifact;
    }

    private static boolean referencedArtifactFiltered(ReferencedArtifact referencedArtifact, String filterGroupId, String filterArtifactId, String filterVersion) {
        if (filterGroupId != null && !referencedArtifact.groupId.equals(filterGroupId)) {
            return false;
        }
        if (filterArtifactId != null && !referencedArtifact.artifactId.equals(filterArtifactId)) {
            return false;
        }
        return filterVersion == null || referencedArtifact.version.equals(filterVersion);
    }

    public ReferencedArtifact getParentReferencedArtifact() {
        List<ReferencedArtifact> listReferencedArtifact = this.getListReferencedArtifact(EnumSet.of(ReferencedArtifactType.PARENT), null, null, null);
        if (listReferencedArtifact.isEmpty()) {
            return null;
        }
        return listReferencedArtifact.get(0);
    }

    public void setReferencedArtifactVersion(ReferencedArtifact referencedArtifact, String version) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        switch (referencedArtifact.referencedArtifactType) {
            case PARENT: {
                Node nodeVersion;
                try {
                    nodeVersion = (Node)xPath.evaluate("/project/parent[groupId='" + referencedArtifact.groupId + "' and artifactId='" + referencedArtifact.artifactId + "' and version='" + referencedArtifact.version + "']/version", this.documentPom, XPathConstants.NODE);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (nodeVersion == null) {
                    throw new RuntimeException("The POM " + this.pathPomLoaded + " does not contain a parent element which matches the specified GAV " + referencedArtifact.groupId + ":" + referencedArtifact.artifactId + ":" + referencedArtifact.version + " to modify.");
                }
                nodeVersion.setTextContent(version);
                break;
            }
            case DEPENDENCY: {
                Node nodeVersion;
                try {
                    nodeVersion = (Node)xPath.evaluate("/project/dependencies/dependency[groupId='" + referencedArtifact.groupId + "' and artifactId='" + referencedArtifact.artifactId + "' and version='" + referencedArtifact.version + "']/version", this.documentPom, XPathConstants.NODE);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (nodeVersion == null) {
                    throw new RuntimeException("The POM " + this.pathPomLoaded + " does not contain a dependencies/dependency element which matches the specified GAV " + referencedArtifact.groupId + ":" + referencedArtifact.artifactId + ":" + referencedArtifact.version + " to modify.");
                }
                nodeVersion.setTextContent(version);
                break;
            }
            case DEPENDENCY_MANAGEMENT: {
                Node nodeVersion;
                try {
                    nodeVersion = (Node)xPath.evaluate("/project/dependencyManagement/dependency[groupId='" + referencedArtifact.groupId + "' and artifactId='" + referencedArtifact.artifactId + "' and version='" + referencedArtifact.version + "']/version", this.documentPom, XPathConstants.NODE);
                }
                catch (XPathExpressionException xpee) {
                    throw new RuntimeException(xpee);
                }
                if (nodeVersion == null) {
                    throw new RuntimeException("The POM " + this.pathPomLoaded + " does not contain a dependencyManagement/dependency element which matches the specified GAV " + referencedArtifact.groupId + ":" + referencedArtifact.artifactId + ":" + referencedArtifact.version + " to modify.");
                }
                nodeVersion.setTextContent(version);
            }
        }
    }

    public List<String> getListSubmodule() {
        NodeList nodeListSubmodules;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            nodeListSubmodules = (NodeList)xPath.evaluate("/project/modules/module", this.documentPom, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpee) {
            throw new RuntimeException(xpee);
        }
        int length = nodeListSubmodules.getLength();
        ArrayList<String> listSubmodule = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            Node nodeSubmodule = nodeListSubmodules.item(i);
            listSubmodule.add(nodeSubmodule.getTextContent());
        }
        return listSubmodule;
    }

    public static void main(String[] args) {
        Pom pom = new Pom();
        pom.setPathPom(Paths.get("C:/Projects/test.xml", new String[0]));
        pom.loadPom();
        pom.savePom();
    }

    static enum BeforeAfterReadState {
        INIT,
        MAYBE_BODY,
        XML_HEADER,
        BODY;

    }

    public static class ReferencedArtifact {
        private ReferencedArtifactType referencedArtifactType;
        private String groupId;
        private String artifactId;
        private String version;

        public ReferencedArtifact(ReferencedArtifactType referencedArtifactType, String groupId, String artifactId, String version) {
            this.referencedArtifactType = referencedArtifactType;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public ReferencedArtifactType getReferencedArtifactType() {
            return this.referencedArtifactType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return (Object)((Object)this.referencedArtifactType) + "/" + this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.referencedArtifactType == null ? 0 : this.referencedArtifactType.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof ReferencedArtifact)) {
                return false;
            }
            ReferencedArtifact referencedArtifactOther = (ReferencedArtifact)other;
            if (this.artifactId == null ? referencedArtifactOther.artifactId != null : !this.artifactId.equals(referencedArtifactOther.artifactId)) {
                return false;
            }
            if (this.groupId == null ? referencedArtifactOther.groupId != null : !this.groupId.equals(referencedArtifactOther.groupId)) {
                return false;
            }
            if (this.referencedArtifactType != referencedArtifactOther.referencedArtifactType) {
                return false;
            }
            return !(this.version == null ? referencedArtifactOther.version != null : !this.version.equals(referencedArtifactOther.version));
        }

        public boolean equalsNoVersion(ReferencedArtifact referencedArtifactOther) {
            if (this == referencedArtifactOther) {
                return true;
            }
            if (referencedArtifactOther == null) {
                return false;
            }
            if (this.artifactId == null ? referencedArtifactOther.artifactId != null : !this.artifactId.equals(referencedArtifactOther.artifactId)) {
                return false;
            }
            if (this.groupId == null ? referencedArtifactOther.groupId != null : !this.groupId.equals(referencedArtifactOther.groupId)) {
                return false;
            }
            return this.referencedArtifactType == referencedArtifactOther.referencedArtifactType;
        }
    }

    public static enum ReferencedArtifactType {
        PARENT,
        DEPENDENCY,
        DEPENDENCY_MANAGEMENT;

    }
}

