/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.azyva.dragom.model.config.NodeConfig;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.config.PluginKey;
import org.azyva.dragom.model.config.PropertyDefConfig;
import org.azyva.dragom.model.config.impl.xml.MapXmlPluginDefConfigAdapter;
import org.azyva.dragom.model.config.impl.xml.MapXmlPropertyDefConfigAdapter;
import org.azyva.dragom.model.plugin.NodePlugin;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class XmlNodeConfig
implements NodeConfig {
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="properties", type=MapXmlPropertyDefConfigAdapter.ListProperty.class)
    @XmlJavaTypeAdapter(value=MapXmlPropertyDefConfigAdapter.class)
    private Map<String, PropertyDefConfig> mapPropertyDefConfig;
    @XmlElement(name="plugins", type=MapXmlPluginDefConfigAdapter.ListPluginDefConfigXml.class)
    @XmlJavaTypeAdapter(value=MapXmlPluginDefConfigAdapter.class)
    private Map<PluginKey, PluginDefConfig> mapPluginDefConfig;

    protected void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.mapPropertyDefConfig == null) {
            this.mapPropertyDefConfig = Collections.emptyMap();
        }
        if (this.mapPluginDefConfig == null) {
            this.mapPluginDefConfig = Collections.emptyMap();
        }
    }

    public String getName() {
        return this.name;
    }

    public PropertyDefConfig getPropertyDefConfig(String name) {
        return this.mapPropertyDefConfig.get(name);
    }

    public boolean isPropertyExists(String name) {
        return this.mapPropertyDefConfig.containsKey(name);
    }

    public List<PropertyDefConfig> getListPropertyDefConfig() {
        return new ArrayList<PropertyDefConfig>(this.mapPropertyDefConfig.values());
    }

    public PluginDefConfig getPluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.get(new PluginKey(classNodePlugin, pluginId));
    }

    public boolean isPluginDefConfigExists(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.containsKey(new PluginKey(classNodePlugin, pluginId));
    }

    public List<PluginDefConfig> getListPluginDefConfig() {
        return new ArrayList<PluginDefConfig>(this.mapPluginDefConfig.values());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }
}

