/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.xml;

import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.util.Util;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="plugin")
public class XmlPluginDefConfig
implements PluginDefConfig {
    @XmlElement(name="plugin-interface")
    private String stringClassNodePluginFromXml;
    private Class<? extends NodePlugin> classNodePlugin;
    @XmlElement(name="plugin-id")
    private String pluginIdFromXml;
    private String pluginId;
    @XmlElement(name="plugin-class")
    private String pluginClass;
    @XmlElement(name="ind-only-this-node")
    private boolean indOnlyThisNode;

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.stringClassNodePluginFromXml == null) {
            this.classNodePlugin = Util.getDefaultClassNodePlugin(this.pluginClass);
        } else {
            try {
                this.classNodePlugin = Class.forName(this.stringClassNodePluginFromXml).asSubclass(NodePlugin.class);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(cnfe);
            }
        }
        this.pluginId = this.pluginIdFromXml == null ? Util.getDefaultPluginId(this.classNodePlugin, this.pluginClass) : this.pluginIdFromXml;
    }

    public Class<? extends NodePlugin> getClassNodePlugin() {
        return this.classNodePlugin;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public boolean isOnlyThisNode() {
        return this.indOnlyThisNode;
    }

    public String toString() {
        return "XmlPluginDefConfig [classNodePlugin=" + this.classNodePlugin.getName() + ", pluginId=" + this.pluginId + ", pluginClass=" + this.pluginClass + ", indOnlyThisNode=" + this.indOnlyThisNode + "]";
    }
}

