/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.impl.simple;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.azyva.dragom.execcontext.plugin.EventPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.ClassificationNode;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.MutableNode;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.config.DuplicateNodeException;
import org.azyva.dragom.model.config.MutableNodeConfig;
import org.azyva.dragom.model.config.NodeConfig;
import org.azyva.dragom.model.config.NodeConfigTransferObject;
import org.azyva.dragom.model.config.NodeType;
import org.azyva.dragom.model.config.OptimisticLockException;
import org.azyva.dragom.model.config.OptimisticLockHandle;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.config.PropertyDefConfig;
import org.azyva.dragom.model.event.NodeEvent;
import org.azyva.dragom.model.event.NodeEventListener;
import org.azyva.dragom.model.event.support.EventManager;
import org.azyva.dragom.model.impl.simple.SimpleClassificationNode;
import org.azyva.dragom.model.impl.simple.SimpleModel;
import org.azyva.dragom.model.plugin.ClassificationNodePlugin;
import org.azyva.dragom.model.plugin.ModulePlugin;
import org.azyva.dragom.model.plugin.NodeInitPlugin;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.model.plugin.NodePluginFactory;
import org.azyva.dragom.util.Util;

public abstract class SimpleNode
implements Node,
MutableNode {
    private static final String PARENT_REFERENCE = "$parent";
    protected boolean indMutable;
    protected State state;
    private NodeConfig nodeConfig;
    private SimpleClassificationNode simpleClassificationNodeParent;
    private String name;
    private SimpleModel simpleModel;
    private NodePath nodePath;
    private Map<String, Property> mapProperty;
    private Map<String, NodePlugin> mapNodePluginConstructor;
    private EventManager eventManager;

    protected SimpleNode(SimpleModel simpleModel) {
        this.indMutable = false;
        this.state = State.DYNAMICALLY_BEING_COMPLETED;
        this.simpleModel = simpleModel;
        this.mapProperty = new HashMap<String, Property>();
    }

    protected SimpleNode(NodeConfig nodeConfig, SimpleModel simpleModel) {
        if (simpleModel.getClassificationNodeRoot() != null) {
            throw new RuntimeException("The model for node " + nodeConfig.getName() + " must not already have a root classification node.");
        }
        this.nodeConfig = nodeConfig;
        this.indMutable = this.nodeConfig instanceof MutableNodeConfig;
        this.state = this.indMutable && ((MutableNodeConfig)nodeConfig).isNew() ? State.CONFIG_NEW : State.CONFIG;
        this.name = nodeConfig.getName();
        this.simpleModel = simpleModel;
    }

    protected SimpleNode(NodeConfig nodeConfig, SimpleClassificationNode simpleClassificationNodeParent) {
        if (simpleClassificationNodeParent == null) {
            throw new RuntimeException("The parent of node " + nodeConfig.getName() + " cannot be null.");
        }
        this.nodeConfig = nodeConfig;
        if (this.nodeConfig instanceof MutableNodeConfig) {
            this.indMutable = true;
        }
        this.state = this.indMutable && ((MutableNodeConfig)nodeConfig).isNew() ? State.CONFIG_NEW : State.CONFIG;
        this.simpleClassificationNodeParent = simpleClassificationNodeParent;
        this.name = nodeConfig.getName();
        this.simpleModel = (SimpleModel)simpleClassificationNodeParent.getModel();
    }

    void setSimpleClassificationNodeParent(SimpleClassificationNode simpleClassificationNodeParent) {
        if (this.state != State.DYNAMICALLY_BEING_COMPLETED) {
            throw new IllegalStateException("State must be DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        if (simpleClassificationNodeParent.getModel() != this.getModel()) {
            throw new RuntimeException("Parent classification node is not from the same model as the module being built.");
        }
        this.simpleClassificationNodeParent = simpleClassificationNodeParent;
    }

    void setName(String name) {
        if (this.state != State.DYNAMICALLY_BEING_COMPLETED) {
            throw new IllegalStateException("State must be DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        this.name = name;
    }

    void setProperty(String name, String value, boolean indOnlyThisNode) {
        if (this.state != State.DYNAMICALLY_BEING_COMPLETED) {
            throw new IllegalStateException("State must be DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        this.mapProperty.put(name, new Property(value, indOnlyThisNode));
    }

    void init() {
        if (this.state != State.CONFIG && this.state != State.DYNAMICALLY_BEING_COMPLETED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        if (this.state == State.DYNAMICALLY_BEING_COMPLETED) {
            this.state = State.DYNAMICALLY_CREATED;
        }
        List<String> listPluginId = this.getListPluginId(NodeInitPlugin.class);
        for (String pluginId : listPluginId) {
            NodeInitPlugin nodeInitPlugin = this.getNodePlugin(NodeInitPlugin.class, pluginId);
            nodeInitPlugin.init();
        }
    }

    protected NodeConfig getNodeConfig() {
        if (this.state != State.CONFIG && this.state != State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        return this.nodeConfig;
    }

    public ClassificationNode getClassificationNodeParent() {
        this.checkNotDeleted();
        return this.simpleClassificationNodeParent;
    }

    public String getName() {
        this.checkNotDeleted();
        if (this.state == State.CONFIG_NEW) {
            throw new IllegalStateException("State must not be CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        return this.name;
    }

    public Model getModel() {
        this.checkNotDeleted();
        return this.simpleModel;
    }

    public NodePath getNodePath() {
        this.checkNotDeleted();
        if (this.simpleClassificationNodeParent == null) {
            return null;
        }
        if (this.nodePath == null) {
            this.nodePath = new NodePath(this.simpleClassificationNodeParent.getNodePath(), this.name, this.getNodeType() == NodeType.CLASSIFICATION);
        }
        return this.nodePath;
    }

    public String getProperty(String name) {
        this.checkNotDeleted();
        if (this.state == State.CONFIG_NEW) {
            throw new IllegalStateException("State must not be CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        String[] arrayNodeName = this.getNodePath() == null ? new String[]{} : this.getNodePath().getArrayNodeName();
        StringBuilder stringBuilder = new StringBuilder("org.azyva.dragom.model-property.");
        Properties propertiesInit = this.simpleModel.getInitProperties();
        String value = propertiesInit.getProperty(stringBuilder.toString() + name);
        for (String nodeName : arrayNodeName) {
            stringBuilder.append(nodeName).append('.');
            String value2 = propertiesInit.getProperty(stringBuilder.toString() + name);
            if (value2 == null) continue;
            value = value2;
        }
        SimpleNode simpleNodeCurrent = null;
        if (value == null) {
            value = null;
            for (simpleNodeCurrent = this; simpleNodeCurrent != null && value == null; simpleNodeCurrent = (SimpleNode)simpleNodeCurrent.getClassificationNodeParent()) {
                if (simpleNodeCurrent.state == State.CONFIG) {
                    PropertyDefConfig propertyDefConfig = simpleNodeCurrent.getNodeConfig().getPropertyDefConfig(name);
                    if (propertyDefConfig == null) continue;
                    if (propertyDefConfig.isOnlyThisNode() && this != simpleNodeCurrent) {
                        return null;
                    }
                    value = propertyDefConfig.getValue();
                    continue;
                }
                Property property = simpleNodeCurrent.mapProperty.get(name);
                if (property == null) continue;
                if (property.indOnlyThisNode && this != simpleNodeCurrent) {
                    return null;
                }
                value = property.value;
            }
        }
        if (value != null) {
            int indexParentReference;
            while ((indexParentReference = value.indexOf(PARENT_REFERENCE)) != -1) {
                String valueParent = simpleNodeCurrent == null ? "" : simpleNodeCurrent.getProperty(name);
                value = value.substring(0, indexParentReference) + valueParent + value.substring(indexParentReference + PARENT_REFERENCE.length());
            }
        }
        return value;
    }

    private PluginDefConfig getPluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        for (SimpleNode simpleNodeCurrent = this; simpleNodeCurrent != null; simpleNodeCurrent = (SimpleNode)simpleNodeCurrent.getClassificationNodeParent()) {
            PluginDefConfig pluginDefConfig;
            if (simpleNodeCurrent.state != State.CONFIG || (pluginDefConfig = simpleNodeCurrent.getNodeConfig().getPluginDefConfig(classNodePlugin, pluginId)) == null) continue;
            if (pluginDefConfig.isOnlyThisNode() && this != simpleNodeCurrent) {
                return null;
            }
            return pluginDefConfig;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <NodePluginInterface extends NodePlugin> NodePluginInterface getNodePlugin(Class<NodePluginInterface> classNodePlugin, String pluginId) {
        NodePlugin nodePlugin;
        Class<?> classPlugin;
        this.checkNotDeleted();
        if (this.state == State.CONFIG_NEW) {
            throw new IllegalStateException("State must not be CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        switch (this.getNodeType()) {
            case CLASSIFICATION: {
                classNodePlugin.asSubclass(ClassificationNodePlugin.class);
                break;
            }
            case MODULE: {
                classNodePlugin.asSubclass(ModulePlugin.class);
            }
        }
        PluginDefConfig pluginDefConfig = this.getPluginDefConfig(classNodePlugin, pluginId);
        if (pluginDefConfig == null) {
            throw new RuntimeException("Plugin " + classNodePlugin + ":" + pluginId + " is not defined for node " + this + '.');
        }
        try {
            classPlugin = Class.forName(pluginDefConfig.getPluginClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
        if (NodePluginFactory.class.isAssignableFrom(classPlugin)) {
            NodePluginFactory pluginFactory = Util.getNodePluginFactory(pluginDefConfig.getPluginClass());
            nodePlugin = pluginFactory.getPlugin(pluginDefConfig.getClassNodePlugin(), (Node)this);
            return (NodePluginInterface)((NodePlugin)nodePlugin.getClass().asSubclass(classNodePlugin).cast(nodePlugin));
        }
        if (!NodePlugin.class.isAssignableFrom(classPlugin)) throw new RuntimeException("The plugin class " + pluginDefConfig.getPluginClass() + " does not implement NodePluginFactory and cannot be instantiated as a NodePlugin.");
        if (!pluginDefConfig.getClassNodePlugin().isAssignableFrom(classPlugin)) {
            throw new RuntimeException("The plugin class " + pluginDefConfig.getPluginClass() + " cannot be instantiated as a " + pluginDefConfig.getClassNodePlugin() + '.');
        }
        try {
            if (this.mapNodePluginConstructor == null) {
                this.mapNodePluginConstructor = new HashMap<String, NodePlugin>();
            }
            if ((nodePlugin = this.mapNodePluginConstructor.get(pluginDefConfig.getPluginClass())) != null) return (NodePluginInterface)((NodePlugin)nodePlugin.getClass().asSubclass(classNodePlugin).cast(nodePlugin));
            Constructor<NodePlugin> constructorNodePlugin = classPlugin.asSubclass(NodePlugin.class).getConstructor(this.getNodeType() == NodeType.CLASSIFICATION ? ClassificationNode.class : Module.class);
            nodePlugin = constructorNodePlugin.newInstance(this);
            this.mapNodePluginConstructor.put(pluginDefConfig.getPluginClass(), nodePlugin);
            return (NodePluginInterface)((NodePlugin)nodePlugin.getClass().asSubclass(classNodePlugin).cast(nodePlugin));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isNodePluginExists(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        this.checkNotDeleted();
        if (this.state == State.CONFIG_NEW) {
            throw new IllegalStateException("State must not be CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        switch (this.getNodeType()) {
            case CLASSIFICATION: {
                classNodePlugin.asSubclass(ClassificationNodePlugin.class);
                break;
            }
            case MODULE: {
                classNodePlugin.asSubclass(ModulePlugin.class);
            }
        }
        PluginDefConfig pluginDefConfig = this.getPluginDefConfig(classNodePlugin, pluginId);
        return pluginDefConfig != null;
    }

    public List<String> getListPluginId(Class<? extends NodePlugin> classNodePlugin) {
        this.checkNotDeleted();
        if (this.state == State.CONFIG_NEW) {
            throw new IllegalStateException("State must not be CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        ArrayList<String> listPluginId = new ArrayList<String>();
        HashSet<String> setPluginIdEncountered = new HashSet<String>();
        for (SimpleNode nodeCurrent = this; nodeCurrent != null; nodeCurrent = (SimpleNode)nodeCurrent.getClassificationNodeParent()) {
            if (nodeCurrent.state != State.CONFIG) continue;
            List listPluginDefConfig = nodeCurrent.getNodeConfig().getListPluginDefConfig();
            for (PluginDefConfig pluginDefConfig : listPluginDefConfig) {
                String pluginId;
                if (pluginDefConfig.getClassNodePlugin() != classNodePlugin || setPluginIdEncountered.contains(pluginId = pluginDefConfig.getPluginId())) continue;
                setPluginIdEncountered.add(pluginId);
                if (pluginDefConfig.getPluginClass() == null || pluginDefConfig.isOnlyThisNode() && nodeCurrent != this) continue;
                listPluginId.add(pluginId);
            }
        }
        return listPluginId;
    }

    public <NodeEventClass extends NodeEvent> void registerListener(NodeEventListener<NodeEventClass> nodeEventListener, boolean indChildrenAlso) {
        if (this.state != State.CONFIG && this.state != State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_CREATED. State: " + (Object)((Object)this.state));
        }
        if (this.eventManager == null) {
            this.eventManager = new EventManager();
        }
        this.eventManager.registerListener(this, nodeEventListener, indChildrenAlso);
    }

    public void raiseNodeEvent(NodeEvent nodeEvent) {
        EventPlugin eventPlugin;
        if (this.state != State.CONFIG && this.state != State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_CREATED. State: " + (Object)((Object)this.state));
        }
        if (nodeEvent.getNode() != this) {
            throw new RuntimeException("Node event must be raised on target node.");
        }
        if (this.eventManager != null) {
            this.eventManager.raiseNodeEvent(nodeEvent);
        }
        if ((eventPlugin = (EventPlugin)ExecContextHolder.get().getExecContextPlugin(EventPlugin.class)) != null) {
            eventPlugin.raiseNodeEvent(nodeEvent);
        }
    }

    public boolean isCreatedDynamically() {
        this.checkNotDeleted();
        return this.state == State.DYNAMICALLY_CREATED || this.state == State.DYNAMICALLY_BEING_COMPLETED;
    }

    public boolean isNew() {
        this.checkMutable();
        this.checkNotDeleted();
        return this.state == State.CONFIG_NEW;
    }

    public OptimisticLockHandle createOptimisticLockHandle(boolean indLock) {
        return ((MutableNodeConfig)this.getNodeConfig()).createOptimisticLockHandle(indLock);
    }

    public boolean isOptimisticLockValid(OptimisticLockHandle optimisticLockHandle) {
        return ((MutableNodeConfig)this.getNodeConfig()).isOptimisticLockValid(optimisticLockHandle);
    }

    public NodeConfigTransferObject getNodeConfigTransferObject(OptimisticLockHandle optimisticLockHandle) throws OptimisticLockException {
        this.checkMutable();
        this.checkNotDeleted();
        if (this.state != State.CONFIG && this.state != State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        return ((MutableNodeConfig)this.getNodeConfig()).getNodeConfigTransferObject(optimisticLockHandle);
    }

    protected void extractNodeConfigTransferObject(NodeConfigTransferObject nodeConfigTransferObject, OptimisticLockHandle optimisticLockHandle) throws OptimisticLockException, DuplicateNodeException {
        this.checkMutable();
        if (this.state != State.CONFIG && this.state != State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        String newName = nodeConfigTransferObject.getName();
        if (this.state == State.CONFIG) {
            if (this.simpleClassificationNodeParent != null) {
                if (newName == null) {
                    throw new RuntimeException("Name of NodeConfigTrnmsferObject must not be null for non-root SimpleClassificationNode.");
                }
                String currentName = this.name;
                if (!newName.equals(currentName)) {
                    if (this.simpleClassificationNodeParent.getNodeChild(newName) != null) {
                        throw new DuplicateNodeException();
                    }
                    this.simpleClassificationNodeParent.renameSimpleNodeChild(currentName, newName);
                }
            }
            try {
                ((MutableNodeConfig)this.getNodeConfig()).setNodeConfigTransferObject(nodeConfigTransferObject, optimisticLockHandle);
            }
            catch (DuplicateNodeException dne) {
                throw new RuntimeException(dne);
            }
            this.name = newName;
        } else {
            if (this.simpleClassificationNodeParent != null) {
                if (newName == null) {
                    throw new RuntimeException("Name of NodeConfigTrnmsferObject must not be null for non-root SimpleClassificationNode.");
                }
                SimpleNode simpleNodeExisting = (SimpleNode)this.simpleClassificationNodeParent.getNodeChild(newName);
                if (simpleNodeExisting != null) {
                    if (!simpleNodeExisting.isCreatedDynamically()) {
                        throw new DuplicateNodeException();
                    }
                    this.simpleClassificationNodeParent.removeChildNode(newName);
                    simpleNodeExisting.cleanCaches(true);
                }
            }
            try {
                ((MutableNodeConfig)this.getNodeConfig()).setNodeConfigTransferObject(nodeConfigTransferObject, optimisticLockHandle);
            }
            catch (DuplicateNodeException dne) {
                throw new RuntimeException(dne);
            }
            this.name = newName;
            if (this.simpleClassificationNodeParent != null) {
                this.simpleClassificationNodeParent.setSimpleNodeChild(newName, this);
            }
        }
        this.cleanCaches(false);
    }

    public void delete() {
        this.checkMutable();
        if (this.state != State.CONFIG && this.state != State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        if (this.state == State.CONFIG) {
            this.simpleClassificationNodeParent.removeChildNode(this.name);
            ((MutableNodeConfig)this.getNodeConfig()).delete();
        }
        this.cleanCaches(true);
    }

    public boolean isDeleted() {
        this.checkMutable();
        return this.state == State.DELETED;
    }

    protected void checkNotDeleted() {
        if (this.state == State.DELETED) {
            throw new IllegalStateException("MutableNode is deleted.");
        }
    }

    protected void checkMutable() {
        if (!this.indMutable) {
            throw new IllegalStateException("MutableNode must be mutable.");
        }
    }

    protected void cleanCaches(boolean indDelete) {
        this.nodePath = null;
        this.mapProperty = null;
        this.mapNodePluginConstructor = null;
        this.simpleModel.cleanCaches(this);
        if (indDelete) {
            this.name = null;
            this.simpleClassificationNodeParent = null;
            this.simpleModel = null;
            this.eventManager = null;
            this.indMutable = true;
            this.state = State.DELETED;
        }
    }

    public String toString() {
        if (this.simpleClassificationNodeParent == null) {
            return "[root]";
        }
        return this.getNodePath().toString();
    }

    private static class Property {
        String value;
        boolean indOnlyThisNode;

        Property(String value, boolean indOnlyThisNode) {
            this.value = value;
            this.indOnlyThisNode = indOnlyThisNode;
        }
    }

    protected static enum State {
        CONFIG_NEW,
        CONFIG,
        DYNAMICALLY_BEING_COMPLETED,
        DYNAMICALLY_CREATED,
        DELETED;

    }
}

