/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.SelectStaticVersionPlugin;
import org.azyva.dragom.model.plugin.impl.SelectStaticVersionPluginBaseImpl;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousReleaseSelectStaticVersionPluginImpl
extends SelectStaticVersionPluginBaseImpl
implements SelectStaticVersionPlugin {
    private static final Logger logger = LoggerFactory.getLogger(ContinuousReleaseSelectStaticVersionPluginImpl.class);
    private static final String RUNTIME_PROPERTY_CONTINUOUS_RELEASE_MAPPINGS = "CONTINOUS_RELEASE_MAPPINGS";
    private static final String RUNTIME_PROPERTY_PREFIX_CONTINUOUS_RELEASE_MAPPING = "CONTINUOUS_RELEASE_MAPPING.";
    private static final String RUNTIME_PROPERTY_IND_FORCE_REUSE_EXISTING_STATIC_VERSION = "FORCE_REUSE_STATIC_VERSION";
    private static final int DEFAULT_INITIAL_REVISION = 1;
    private static final int DEFAULT_REVISION_DECIMAL_POSITION_COUNT = 5;
    private static final String TRANSIENT_DATA_PREFIX_LIST_CONTINUOUS_RELEASE_MAPPING = ContinuousReleaseSelectStaticVersionPluginImpl.class.getName() + ".ListContinuousReleaseMapping.";

    public ContinuousReleaseSelectStaticVersionPluginImpl(Module module) {
        super(module);
        this.setDefaultInitialRevision(1);
        this.setDefaultRevisionDecimalPositionCount(5);
    }

    public Version selectStaticVersion(Version versionDynamic) {
        this.validateVersionDynamic(versionDynamic);
        Version versionNewStatic = this.handleSpecificStaticVersion(versionDynamic);
        if (versionNewStatic != null) {
            return versionNewStatic;
        }
        versionNewStatic = this.handleExistingEquivalentStaticVersion(versionDynamic);
        if (versionNewStatic != null) {
            return versionNewStatic;
        }
        Version versionStaticPrefix = this.handleSpecificStaticVersionPrefix(versionDynamic);
        if (versionStaticPrefix == null) {
            versionStaticPrefix = this.mapDynamicVersionToStaticVersionPrefix(versionDynamic);
        }
        Version versionLatestStatic = this.getVersionLatestMatchingVersionStaticPrefix(this.getListVersionStaticGlobal(), versionStaticPrefix);
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_IND_FORCE_REUSE_EXISTING_STATIC_VERSION))) {
            return versionLatestStatic;
        }
        return this.getNewStaticVersionFromPrefix(versionLatestStatic, versionStaticPrefix);
    }

    private Version mapDynamicVersionToStaticVersionPrefix(Version versionDynamic) {
        for (ContinuousReleaseMapping continuousReleaseMapping : this.getListContinuousReleaseMapping()) {
            logger.debug("Attempting to match dynamic Version {} to Version matching pattern {}.", (Object)versionDynamic, (Object)continuousReleaseMapping.patternSrcDynamicVersion);
            Matcher matcher = continuousReleaseMapping.patternSrcDynamicVersion.matcher(versionDynamic.toString());
            if (!matcher.matches()) continue;
            String stringStaticVersionPrefix = matcher.replaceAll(continuousReleaseMapping.destinationStaticVersionPrefix);
            logger.debug("Version {} mapped to static Version prefix {}.", (Object)versionDynamic, (Object)stringStaticVersionPrefix);
            return new Version(stringStaticVersionPrefix);
        }
        throw new RuntimeException("No corresponding static Version prefix is mapped to dynamic Version " + versionDynamic + " for Module " + this.getModule() + '.');
    }

    private List<ContinuousReleaseMapping> getListContinuousReleaseMapping() {
        String[] arrayContinuousReleaseMappingKey;
        ExecContext execContext = ExecContextHolder.get();
        Module module = this.getModule();
        ArrayList<ContinuousReleaseMapping> listContinuousReleaseMapping = (ArrayList<ContinuousReleaseMapping>)execContext.getTransientData(TRANSIENT_DATA_PREFIX_LIST_CONTINUOUS_RELEASE_MAPPING + module.getNodePath());
        if (listContinuousReleaseMapping != null) {
            return listContinuousReleaseMapping;
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        listContinuousReleaseMapping = new ArrayList<ContinuousReleaseMapping>();
        String continuousReleaseMappingKeys = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_CONTINUOUS_RELEASE_MAPPINGS);
        if (continuousReleaseMappingKeys == null) {
            throw new RuntimeException("The runtime property CONTINOUS_RELEASE_MAPPINGS is not defined for module " + module + '.');
        }
        for (String continuousReleaseMappingKey : arrayContinuousReleaseMappingKey = continuousReleaseMappingKeys.split(",")) {
            String property = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_PREFIX_CONTINUOUS_RELEASE_MAPPING + continuousReleaseMappingKey);
            if (property == null) {
                throw new RuntimeException("The runtime property CONTINUOUS_RELEASE_MAPPING." + continuousReleaseMappingKey + " is not defined for module " + module + '.');
            }
            String[] arrayMappingComponent = property.split(":");
            if (arrayMappingComponent.length != 2) {
                throw new RuntimeException("The mapping " + property + " is not composed of two components separated by \":\".");
            }
            ContinuousReleaseMapping continuousReleaseMapping = new ContinuousReleaseMapping();
            continuousReleaseMapping.patternSrcDynamicVersion = Pattern.compile(arrayMappingComponent[0]);
            continuousReleaseMapping.destinationStaticVersionPrefix = arrayMappingComponent[1];
            listContinuousReleaseMapping.add(continuousReleaseMapping);
        }
        execContext.setTransientData(TRANSIENT_DATA_PREFIX_LIST_CONTINUOUS_RELEASE_MAPPING + module.getNodePath(), listContinuousReleaseMapping);
        return listContinuousReleaseMapping;
    }

    private static class ContinuousReleaseMapping {
        Pattern patternSrcDynamicVersion;
        String destinationStaticVersionPrefix;

        private ContinuousReleaseMapping() {
        }
    }
}

