/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.maven.PomUtil;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.plugin.ArtifactVersionManagerPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;

public class MavenArtifactVersionManagerPluginImpl
extends ModulePluginAbstractImpl
implements ArtifactVersionManagerPlugin {
    public MavenArtifactVersionManagerPluginImpl(Module module) {
        super(module);
    }

    public ArtifactVersion getArtifactVersion(Path pathModuleWorkspace) {
        Pom pom = new Pom();
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        pom.setPathPom(pathPom);
        pom.loadPom();
        String version = pom.getVersion();
        if (version == null) {
            throw new RuntimeException("The version of the artifacts is not explicitely set within POM " + pathPom + " of module " + pathModuleWorkspace + ". Maven allows this (the version being inherited from the parent), but Dragom does not allow this for a top-level module.");
        }
        if (version.contains("${")) {
            throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ".");
        }
        return new ArtifactVersion(version);
    }

    public boolean setArtifactVersion(Path pathModuleWorkspace, ArtifactVersion artifactVersion) {
        Pom pom = new Pom();
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        pom.setPathPom(pathModuleWorkspace.resolve("pom.xml"));
        pom.loadPom();
        String priorVersion = pom.getVersion();
        if (priorVersion == null) {
            throw new RuntimeException("The version of the artifacts is not explicitely set within POM " + pathPom + " of module " + pathModuleWorkspace + ". Maven allows this (the version being inherited from the parent), but Dragom does not allow this for a top-level module.");
        }
        if (priorVersion.contains("${")) {
            throw new RuntimeException("A property reference was found within version " + priorVersion + " in the POM " + pathPom + ".");
        }
        if (artifactVersion.toString().equals(priorVersion)) {
            return false;
        }
        Set<ArtifactGroupId> setArtifactGroupIdAggregator = PomUtil.getSetArtifactGroupIdAggregator(pathPom);
        this.setArtifactVersionOnSubmodule(pathModuleWorkspace, setArtifactGroupIdAggregator, priorVersion, pathModuleWorkspace, artifactVersion.toString());
        return true;
    }

    private void setArtifactVersionOnSubmodule(Path pathModuleWorkspace, Set<ArtifactGroupId> setArtifactGroupIdAggregator, String priorVersion, Path pathSubmoduleWorkspace, String newVersion) {
        ArtifactGroupId artifactGroupId;
        Pom pom = new Pom();
        Path pathPom = pathSubmoduleWorkspace.resolve("pom.xml");
        pom.setPathPom(pathPom);
        pom.loadPom();
        String version = pom.getVersion();
        if (version != null && version.contains("${")) {
            throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ".");
        }
        Pom.ReferencedArtifact referencedArtifactParent = pom.getParentReferencedArtifact();
        if (referencedArtifactParent != null) {
            if (referencedArtifactParent.getGroupId().contains("${") || referencedArtifactParent.getArtifactId().contains("${") || referencedArtifactParent.getVersion().contains("${")) {
                throw new RuntimeException("A property reference was found within referenced artifact " + referencedArtifactParent + " in the POM " + pathPom + ".");
            }
            artifactGroupId = new ArtifactGroupId(referencedArtifactParent.getGroupId(), referencedArtifactParent.getArtifactId());
            if (setArtifactGroupIdAggregator.contains(artifactGroupId)) {
                if (!referencedArtifactParent.getVersion().equals(priorVersion)) {
                    throw new RuntimeException("The parent " + referencedArtifactParent + " identified within " + pathPom + " is within the aggregation but its version does not match that of the main aggregator module " + pathModuleWorkspace + '.');
                }
                if (version != null && !version.equals(priorVersion)) {
                    throw new RuntimeException("The parent " + referencedArtifactParent + " identified within " + pathPom + " is within the aggregation rooted at " + pathModuleWorkspace + ", the module also specifies a version but this version does not match that of the parent.");
                }
                pom.setReferencedArtifactVersion(referencedArtifactParent, newVersion);
            }
        } else {
            if (version == null) {
                throw new RuntimeException("The POM " + pathPom + " within the aggregation rooted at " + pathModuleWorkspace + " does not specify a parent and its version is not specified.");
            }
            if (!version.equals(priorVersion)) {
                throw new RuntimeException("The version of the POM " + pathPom + " does not match that of the main aggregator module " + pathModuleWorkspace + '.');
            }
        }
        if (version != null) {
            pom.setVersion(newVersion);
        }
        List<Pom.ReferencedArtifact> listReferencedArtifact = pom.getListReferencedArtifact(EnumSet.of(Pom.ReferencedArtifactType.DEPENDENCY, Pom.ReferencedArtifactType.DEPENDENCY_MANAGEMENT), null, null, null);
        for (Pom.ReferencedArtifact referencedArtifact : listReferencedArtifact) {
            if (referencedArtifact.getGroupId().contains("${") || referencedArtifact.getArtifactId().contains("${")) {
                throw new RuntimeException("A property reference was found within referenced artifact " + referencedArtifact + " in the POM " + pathPom + ".");
            }
            artifactGroupId = new ArtifactGroupId(referencedArtifact.getGroupId(), referencedArtifact.getArtifactId());
            if (setArtifactGroupIdAggregator.contains(artifactGroupId)) {
                if (referencedArtifact.getVersion().equals("${version}") || referencedArtifact.getVersion().equals("${pom.version}") || referencedArtifact.getVersion().equals("${project.version}")) continue;
                if (referencedArtifact.getVersion().contains("${")) {
                    throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ".");
                }
                if (!referencedArtifact.getVersion().equals(priorVersion)) {
                    throw new RuntimeException("The referenced module " + referencedArtifact + " identified within " + pathPom + " is within the aggregation but its version does not match that of the main aggregator module " + pathModuleWorkspace + " and is not one of the property references ${version}, ${pom.version} or ${project.version}.");
                }
                pom.setReferencedArtifactVersion(referencedArtifact, newVersion);
                continue;
            }
            if (!referencedArtifact.getVersion().contains("${")) continue;
            throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ".");
        }
        pom.savePom();
        List<String> listSubmodules = pom.getListSubmodule();
        for (String submodule : listSubmodules) {
            this.setArtifactVersionOnSubmodule(pathModuleWorkspace, setArtifactGroupIdAggregator, priorVersion, pathSubmoduleWorkspace.resolve(submodule), newVersion);
        }
    }
}

