/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.maven.PomUtil;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.reference.Reference;

public class MavenReferenceManagerPluginImpl
extends ModulePluginAbstractImpl
implements ReferenceManagerPlugin {
    public MavenReferenceManagerPluginImpl(Module module) {
        super(module);
    }

    public List<Reference> getListReference(Path pathModuleWorkspace) {
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        Set<ArtifactGroupId> setArtifactGroupIdAggregator = PomUtil.getSetArtifactGroupIdAggregator(pathPom);
        return this.getListReference(pathModuleWorkspace, setArtifactGroupIdAggregator, Paths.get("pom.xml", new String[0]), null);
    }

    private List<Reference> getListReference(Path pathModuleWorkspace, Set<ArtifactGroupId> setArtifactGroupIdAggregator, Path pathPomRelative, String versionContainer) {
        Model model = this.getModule().getModel();
        ArrayList<Reference> listReference = new ArrayList<Reference>();
        Pom pom = new Pom();
        Path pathPom = pathModuleWorkspace.resolve(pathPomRelative);
        pom.setPathPom(pathPom);
        pom.loadPom();
        String version = pom.getResolvedVersion();
        if (version == null) {
            throw new RuntimeException("The module " + this.getModule() + " does not define its artifact version in the POM " + pathPom + '.');
        }
        if (versionContainer != null && !version.equals(versionContainer)) {
            throw new RuntimeException("The submodule POM " + pathPom + " of module " + this.getModule() + " has version " + version + " which is not the same as that of its container " + versionContainer + '.');
        }
        for (Pom.ReferencedArtifact referencedArtifact : pom.getListReferencedArtifact(EnumSet.allOf(Pom.ReferencedArtifactType.class), null, null, null)) {
            ModuleVersion moduleVersion;
            if (referencedArtifact.getGroupId().contains("${") || referencedArtifact.getArtifactId().contains("${")) {
                throw new RuntimeException("A property reference was found within referenced artifact " + referencedArtifact + " in the POM " + pathPom + ".");
            }
            ArtifactGroupId artifactGroupId = new ArtifactGroupId(referencedArtifact.getGroupId(), referencedArtifact.getArtifactId());
            if (setArtifactGroupIdAggregator.contains(artifactGroupId)) continue;
            if (referencedArtifact.getVersion().contains("${")) {
                throw new RuntimeException("A property reference was found within referenced artifact " + referencedArtifact + " in the POM " + pathPom + ".");
            }
            Module module = model.findModuleByArtifactGroupId(artifactGroupId);
            if (module != null) {
                ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)module.getNodePlugin(ArtifactVersionMapperPlugin.class, null);
                moduleVersion = new ModuleVersion(module.getNodePath(), artifactVersionMapperPlugin.mapArtifactVersionToVersion(new ArtifactVersion(referencedArtifact.getVersion())));
            } else {
                moduleVersion = null;
            }
            Reference reference = new Reference(moduleVersion, artifactGroupId, new ArtifactVersion(referencedArtifact.getVersion()), (Object)new ReferenceImplData(pathPomRelative, referencedArtifact.getReferencedArtifactType()));
            listReference.add(reference);
        }
        for (String submodule : pom.getListSubmodule()) {
            listReference.addAll(this.getListReference(pathModuleWorkspace, setArtifactGroupIdAggregator, pathPomRelative.resolveSibling(submodule).resolve("pom.xml"), version));
        }
        return listReference;
    }

    public boolean updateReferenceVersion(Path pathModuleWorkspace, Reference reference, Version version, ByReference<Reference> byReferenceReference) {
        if (!(reference.getImplData() instanceof ReferenceImplData)) {
            throw new RuntimeException("Within " + this + ", reference extra implementation data must be of type ReferenceImplData.");
        }
        ReferenceImplData referenceImplData = (ReferenceImplData)reference.getImplData();
        if (referenceImplData.getReferenceManagerPluginImpl() != this) {
            throw new RuntimeException("Within " + this + ", reference must have been produced by the same plugin instance.");
        }
        Path pathPom = pathModuleWorkspace.resolve(referenceImplData.pathPom);
        Pom pom = new Pom();
        pom.setPathPom(pathPom);
        pom.loadPom();
        ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)this.getModule().getModel().getModule(reference.getModuleVersion().getNodePath()).getNodePlugin(ArtifactVersionMapperPlugin.class, null);
        ArtifactVersion artifactVersion = artifactVersionMapperPlugin.mapVersionToArtifactVersion(version);
        if (byReferenceReference != null) {
            byReferenceReference.object = new Reference(new ModuleVersion(reference.getModuleVersion().getNodePath(), version), reference.getArtifactGroupId(), artifactVersion, (Object)referenceImplData);
        }
        if (!artifactVersion.toString().equals(reference.getArtifactVersion())) {
            pom.setReferencedArtifactVersion(new Pom.ReferencedArtifact(referenceImplData.referencedArtifactType, reference.getArtifactGroupId().getGroupId(), reference.getArtifactGroupId().getArtifactId(), reference.getArtifactVersion().getVersion()), artifactVersion.toString());
            pom.savePom();
            return true;
        }
        return false;
    }

    public boolean updateReferenceArtifactVersion(Path pathModuleWorkspace, Reference reference, ArtifactVersion artifactVersion, ByReference<Reference> byReferenceReference) {
        throw new RuntimeException("Not implemented yet.");
    }

    private class ReferenceImplData {
        private Path pathPom;
        private Pom.ReferencedArtifactType referencedArtifactType;

        public ReferenceImplData(Path pathPom, Pom.ReferencedArtifactType referencedArtifactType) {
            this.pathPom = pathPom;
            this.referencedArtifactType = referencedArtifactType;
        }

        private MavenReferenceManagerPluginImpl getReferenceManagerPluginImpl() {
            return MavenReferenceManagerPluginImpl.this;
        }

        public String toString() {
            return "ref " + this.pathPom + " " + (Object)((Object)this.referencedArtifactType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pathPom.hashCode();
            result = 31 * result + this.referencedArtifactType.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReferenceImplData)) {
                return false;
            }
            ReferenceImplData referenceImplDataOther = (ReferenceImplData)other;
            if (!this.pathPom.equals(referenceImplDataOther.pathPom)) {
                return false;
            }
            return this.referencedArtifactType.equals((Object)referenceImplDataOther.referencedArtifactType);
        }
    }
}

