/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.plugin.ModulePlugin;
import org.azyva.dragom.model.plugin.NodePlugin;
import org.azyva.dragom.model.plugin.NodePluginFactory;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;

public class RuntimeSelectionPluginFactory
implements NodePluginFactory {
    private static final String RUNTIME_PROPERTY_PREFIX_SPECIFIC_PLUGIN_ID = "SPECIFIC_PLUGIN_ID.";
    private static final String RUNTIME_PROPERTY_PREFIX_IND_ALLOW_USER_SPECIFIED_PLUGIN_ID = "IND_ALLOW_USER_SPECIFIED_PLUGIN_ID.";
    private static final String RUNTIME_PROPERTY_PREFIX_CAN_REUSE_PLUGIN_ID = "CAN_REUSE_PLUGIN_ID.";
    private static final String RUNTIME_PROPERTY_PREFIX_REUSE_PLUGIN_ID = "REUSE_PLUGIN_ID.";
    private static final String MSG_PATTERN_KEY_PLUGIN_ID_SPECIFIED = "PLUGIN_ID_SPECIFIED";
    private static final String MSG_PATTERN_KEY_PLUGIN_ID_AUTOMATICALLY_REUSED = "PLUGIN_ID_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_INPUT_PLUGIN_ID = "INPUT_PLUGIN_ID";
    private static final String MSG_PATTERN_KEY_INPUT_PLUGIN_ID_WITH_DEFAULT = "INPUT_PLUGIN_ID_WITH_DEFAULT";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_PLUGIN_ID = "AUTOMATICALLY_REUSE_PLUGIN_ID";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(RuntimeSelectionPluginFactory.class.getName() + "ResourceBundle");
    private static RuntimeSelectionPluginFactory runtimeSelectionPluginFactory;
    private static ThreadLocal<Set<CurrentPluginRequest>> threadLocalCurrentPluginRequest;

    public static synchronized NodePluginFactory getInstance() {
        if (runtimeSelectionPluginFactory == null) {
            runtimeSelectionPluginFactory = new RuntimeSelectionPluginFactory();
        }
        return runtimeSelectionPluginFactory;
    }

    public Class<? extends NodePlugin> getDefaultClassNodePlugin() {
        return null;
    }

    public String getDefaultPluginId(Class<? extends NodePlugin> classNodePlugin) {
        return null;
    }

    public <NodePluginInterface extends NodePlugin> boolean isPluginSupported(Class<NodePluginInterface> classNodePlugin) {
        return classNodePlugin == ModulePlugin.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NodePluginInterface extends NodePlugin> NodePluginInterface getPlugin(Class<NodePluginInterface> classNodePlugin, Node node) {
        CurrentPluginRequest currentPluginRequest = new CurrentPluginRequest(classNodePlugin, node);
        Set<CurrentPluginRequest> setCurrentPluginRequest = threadLocalCurrentPluginRequest.get();
        if (setCurrentPluginRequest == null) {
            setCurrentPluginRequest = new HashSet<CurrentPluginRequest>();
            threadLocalCurrentPluginRequest.set(setCurrentPluginRequest);
        }
        if (!setCurrentPluginRequest.add(currentPluginRequest)) {
            throw new RuntimeException("Cycle detected when resolving NodePlugin for class " + classNodePlugin + " and Node " + node + '.');
        }
        try {
            RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
            UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
            String stringClassNodePlugin = classNodePlugin.getName();
            String specificPluginId = runtimePropertiesPlugin.getProperty(node, RUNTIME_PROPERTY_PREFIX_SPECIFIC_PLUGIN_ID + stringClassNodePlugin);
            if (specificPluginId != null) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_PLUGIN_ID_SPECIFIED), stringClassNodePlugin, node, specificPluginId));
                NodePlugin nodePlugin = node.getNodePlugin(classNodePlugin, specificPluginId);
                return (NodePluginInterface)nodePlugin;
            }
            String pluginId = null;
            if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty(node, RUNTIME_PROPERTY_PREFIX_IND_ALLOW_USER_SPECIFIED_PLUGIN_ID + stringClassNodePlugin))) {
                AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReusePluginId = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty(node, RUNTIME_PROPERTY_PREFIX_CAN_REUSE_PLUGIN_ID + stringClassNodePlugin));
                String reusePluginId = runtimePropertiesPlugin.getProperty(node, RUNTIME_PROPERTY_PREFIX_REUSE_PLUGIN_ID + stringClassNodePlugin);
                if (reusePluginId == null && alwaysNeverAskUserResponseCanReusePluginId.isAlways()) {
                    alwaysNeverAskUserResponseCanReusePluginId = AlwaysNeverAskUserResponse.ASK;
                }
                if (alwaysNeverAskUserResponseCanReusePluginId.isAlways()) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_PLUGIN_ID_AUTOMATICALLY_REUSED), stringClassNodePlugin, node, reusePluginId));
                    pluginId = reusePluginId;
                } else {
                    pluginId = reusePluginId == null ? userInteractionCallbackPlugin.getInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_PLUGIN_ID), stringClassNodePlugin, node)) : userInteractionCallbackPlugin.getInfoWithDefault(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_PLUGIN_ID_WITH_DEFAULT), stringClassNodePlugin, node, reusePluginId), reusePluginId);
                    runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_PREFIX_REUSE_PLUGIN_ID + stringClassNodePlugin, pluginId);
                    Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_PREFIX_CAN_REUSE_PLUGIN_ID + stringClassNodePlugin, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_PLUGIN_ID), stringClassNodePlugin, pluginId));
                }
            }
            NodePlugin nodePlugin = node.getNodePlugin(classNodePlugin, pluginId);
            return (NodePluginInterface)nodePlugin;
        }
        finally {
            setCurrentPluginRequest.remove(currentPluginRequest);
        }
    }

    static {
        threadLocalCurrentPluginRequest = new ThreadLocal();
    }

    private static class CurrentPluginRequest {
        private Class<? extends NodePlugin> classNodePlugin;
        private Node node;

        public CurrentPluginRequest(Class<? extends NodePlugin> classNodePlugin, Node node) {
            this.classNodePlugin = classNodePlugin;
            this.node = node;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.classNodePlugin.hashCode();
            result = 31 * result + this.node.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            CurrentPluginRequest currentPluginRequestOther = (CurrentPluginRequest)other;
            return this.classNodePlugin == currentPluginRequestOther.classNodePlugin && this.node == currentPluginRequestOther.node;
        }
    }
}

