/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.List;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectStaticVersionPlugin;
import org.azyva.dragom.model.plugin.VersionClassifierPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.Util;
import org.azyva.dragom.util.YesAlwaysNoUserResponse;

public abstract class SelectStaticVersionPluginBaseImpl
extends ModulePluginAbstractImpl
implements SelectStaticVersionPlugin {
    private static final String RUNTIME_PROPERTY_SPECIFIC_STATIC_VERSION = "SPECIFIC_STATIC_VERSION";
    private static final String RUNTIME_PROPERTY_CAN_REUSE_EXISTING_EQUIVALENT_STATIC_VERSION = "CAN_REUSE_EXISTING_EQUIVALENT_STATIC_VERSION";
    private static final String RUNTIME_PROPERTY_SPECIFIC_STATIC_VERSION_PREFIX = "SPECIFIC_STATIC_VERSION_PREFIX";
    private static final String RUNTIME_PROPERTY_INITIAL_REVISION = "INITIAL_REVISION";
    private static final String RUNTIME_PROPERTY_REVISION_DECIMAL_POSITION_COUNT = "REVISION_DECIMAL_POSITION_COUNT";
    private static final String MSG_PATTERN_KEY_STATIC_VERSION_SPECIFIED = "STATIC_VERSION_SPECIFIED";
    private static final String MSG_PATTERN_KEY_EQUIVALENT_STATIC_VERSION_AUTOMATICALLY_REUSED = "EQUIVALENT_STATIC_VERSION_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_REUSE_EQUIVALENT_STATIC_VERSION = "REUSE_EQUIVALENT_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_EQUIVALENT_STATIC_VERSION = "AUTOMATICALLY_REUSE_EQUIVALENT_STATIC_VERSION";
    private static final String MSG_PATTERN_KEY_NEW_STATIC_VERSION_PREFIX_SPECIFIED = "NEW_STATIC_VERSION_PREFIX_SPECIFIED";
    private static final String MSG_PATTERN_KEY_EXISTING_EQUIVALENT_STATIC_VERSION_EXCLUDE_VESION_CHANGING_COMMITS = "EXISTING_EQUIVALENT_STATIC_VERSION_EXCLUDE_VESION_CHANGING_COMMITS";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelectStaticVersionPluginBaseImpl.class.getName() + "ResourceBundle");
    private int defaultInitialRevision;
    private int defaultRevisionDecimalPositionCount;

    public SelectStaticVersionPluginBaseImpl(Module module) {
        super(module);
    }

    protected void setDefaultInitialRevision(int defaultInitialRevision) {
        this.defaultInitialRevision = defaultInitialRevision;
    }

    protected void setDefaultRevisionDecimalPositionCount(int defaultRevisionDecimalPositionCount) {
        this.defaultRevisionDecimalPositionCount = defaultRevisionDecimalPositionCount;
    }

    protected void validateVersionDynamic(Version versionDynamic) {
        if (versionDynamic.getVersionType() != VersionType.DYNAMIC) {
            throw new RuntimeException("Version " + versionDynamic + " of module " + this.getModule() + " is not dynamic.");
        }
    }

    protected Version handleSpecificStaticVersion(Version versionDynamic) {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (versionDynamic.getVersionType() != VersionType.DYNAMIC) {
            throw new RuntimeException("Version " + versionDynamic + " of module " + this.getModule() + " is not dynamic.");
        }
        String stringSpecificStaticVersion = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_SPECIFIC_STATIC_VERSION);
        if (stringSpecificStaticVersion != null) {
            Version versionNewStatic = new Version(stringSpecificStaticVersion);
            if (versionNewStatic.getVersionType() != VersionType.STATIC) {
                throw new RuntimeException("Version " + versionNewStatic + " must be static.");
            }
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_STATIC_VERSION_SPECIFIED), new ModuleVersion(this.getModule().getNodePath(), versionDynamic), versionNewStatic));
            return versionNewStatic;
        }
        return null;
    }

    protected Version handleExistingEquivalentStaticVersion(Version versionDynamic) {
        Version versionExistingEquivalentStatic;
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReuseExistingEquivalentStaticVersion = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_CAN_REUSE_EXISTING_EQUIVALENT_STATIC_VERSION));
        if (!alwaysNeverAskUserResponseCanReuseExistingEquivalentStaticVersion.isNever() && (versionExistingEquivalentStatic = this.getVersionExistingEquivalentStatic(versionDynamic)) != null) {
            if (alwaysNeverAskUserResponseCanReuseExistingEquivalentStaticVersion.isAlways()) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_EQUIVALENT_STATIC_VERSION_AUTOMATICALLY_REUSED), new ModuleVersion(this.getModule().getNodePath(), versionDynamic), versionExistingEquivalentStatic));
                return versionExistingEquivalentStatic;
            }
            YesAlwaysNoUserResponse yesAlwaysNoUserResponse = Util.getInfoYesNoUserResponse(userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REUSE_EQUIVALENT_STATIC_VERSION), new ModuleVersion(this.getModule().getNodePath(), versionDynamic), versionExistingEquivalentStatic), YesAlwaysNoUserResponse.YES);
            Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_EXISTING_EQUIVALENT_STATIC_VERSION, userInteractionCallbackPlugin, resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_EQUIVALENT_STATIC_VERSION));
            if (yesAlwaysNoUserResponse.isYes()) {
                return versionExistingEquivalentStatic;
            }
        }
        return null;
    }

    protected Version handleSpecificStaticVersionPrefix(Version versionDynamic) {
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        String stringStaticVersionPrefix = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_SPECIFIC_STATIC_VERSION_PREFIX);
        if (stringStaticVersionPrefix != null) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_NEW_STATIC_VERSION_PREFIX_SPECIFIED), new ModuleVersion(this.getModule().getNodePath(), versionDynamic), stringStaticVersionPrefix));
            return new Version(stringStaticVersionPrefix);
        }
        return null;
    }

    private Version getVersionExistingEquivalentStatic(Version versionDynamic) {
        Module module = this.getModule();
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        if (scmPlugin.isTempDynamicVersion(versionDynamic)) {
            return null;
        }
        List listCommit = scmPlugin.getListCommit(versionDynamic, new ScmPlugin.CommitPaging(1), EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR, ScmPlugin.GetListCommitFlag.IND_INCLUDE_VERSION_STATIC));
        Version versionExistingEquivalentStatic = null;
        if (!listCommit.isEmpty()) {
            ScmPlugin.Commit commitCurrent = (ScmPlugin.Commit)listCommit.get(0);
            String stringEquivalentStaticVersion = (String)commitCurrent.mapAttr.get("dragom-equivalent-static-version");
            if (stringEquivalentStaticVersion != null && (versionExistingEquivalentStatic = new Version(stringEquivalentStaticVersion)).getVersionType() != VersionType.STATIC) {
                throw new RuntimeException("Version " + versionExistingEquivalentStatic + " must be static.");
            }
            if (versionExistingEquivalentStatic == null) {
                listCommit = scmPlugin.getListCommit(versionDynamic, new ScmPlugin.CommitPaging(16), EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_MAP_ATTR, ScmPlugin.GetListCommitFlag.IND_INCLUDE_VERSION_STATIC));
                for (ScmPlugin.Commit commit : listCommit) {
                    stringEquivalentStaticVersion = (String)commit.mapAttr.get("dragom-equivalent-static-version");
                    if (stringEquivalentStaticVersion == null && (commit.mapAttr.get("dragom-reference-version-change") != null || commit.mapAttr.get("dragom-version-change") != null)) continue;
                    break;
                }
                if (stringEquivalentStaticVersion != null && module.isNodePluginExists(ReferenceManagerPlugin.class, null)) {
                    Version versionStatic = new Version(stringEquivalentStaticVersion);
                    if (versionStatic.getVersionType() != VersionType.STATIC) {
                        throw new RuntimeException("Version " + versionStatic + " must be static.");
                    }
                    WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
                    ReferenceManagerPlugin referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
                    Path pathModuleWorkspace = scmPlugin.checkoutSystem(versionStatic);
                    List listReferenceStaticVersion = referenceManagerPlugin.getListReference(pathModuleWorkspace);
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    pathModuleWorkspace = scmPlugin.checkoutSystem(versionDynamic);
                    List listReferenceDynamicVersion = referenceManagerPlugin.getListReference(pathModuleWorkspace);
                    workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
                    if (listReferenceStaticVersion.equals(listReferenceDynamicVersion)) {
                        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
                        userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_EXISTING_EQUIVALENT_STATIC_VERSION_EXCLUDE_VESION_CHANGING_COMMITS), new ModuleVersion(module.getNodePath(), versionDynamic), versionStatic));
                        versionExistingEquivalentStatic = versionStatic;
                    }
                }
            }
            if (versionExistingEquivalentStatic == null && commitCurrent.arrayVersionStatic.length >= 1) {
                versionExistingEquivalentStatic = commitCurrent.arrayVersionStatic[0];
            }
        }
        return versionExistingEquivalentStatic;
    }

    protected Version getNewStaticVersionFromPrefix(Version versionLatestStatic, Version versionStaticPrefix) {
        int revision;
        if (versionStaticPrefix.getVersionType() != VersionType.STATIC) {
            throw new RuntimeException("Version " + versionStaticPrefix + " must be static.");
        }
        if (!(versionLatestStatic == null || versionLatestStatic.getVersionType() == VersionType.STATIC && versionLatestStatic.getVersion().startsWith(versionStaticPrefix.getVersion()))) {
            throw new RuntimeException("Version " + versionLatestStatic + " must be static and must have as a prefix Version " + versionStaticPrefix + '.');
        }
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        ScmPlugin scmPlugin = (ScmPlugin)this.getModule().getNodePlugin(ScmPlugin.class, null);
        String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_REVISION_DECIMAL_POSITION_COUNT);
        int revisionDecimalPositionCount = runtimeProperty == null ? this.defaultRevisionDecimalPositionCount : Integer.parseInt(runtimeProperty);
        String revisionFormat = revisionDecimalPositionCount == 0 ? "%d" : "%0" + revisionDecimalPositionCount + "d";
        runtimeProperty = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_INITIAL_REVISION);
        int initialRevision = runtimeProperty == null ? this.defaultInitialRevision : Integer.parseInt(runtimeProperty);
        if (versionLatestStatic == null) {
            revision = initialRevision;
        } else {
            String suffix = versionLatestStatic.getVersion().substring(versionStaticPrefix.getVersion().length());
            revision = -1;
            if (suffix.matches("\\.\\d+")) {
                try {
                    revision = Integer.parseInt(suffix.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (revision == -1) {
                throw new RuntimeException("The suffix " + suffix + " of the latest static version " + versionLatestStatic + " is not in the format \".<decimal revision>\".");
            }
            if (revision < initialRevision) {
                revision = initialRevision;
            }
            if (revisionDecimalPositionCount != 0 && (double)revision == Math.pow(10.0, revisionDecimalPositionCount) - 1.0) {
                throw new RuntimeException("The suffix " + suffix + " of the latest static version " + versionLatestStatic + " is already the maximum revision allowed.");
            }
            ++revision;
        }
        Formatter formatter = new Formatter();
        formatter.format(revisionFormat, new Integer(revision));
        Version versionNewStatic = new Version(VersionType.STATIC, versionStaticPrefix.getVersion() + '.' + formatter.out().toString());
        formatter.close();
        if (scmPlugin.isVersionExists(versionNewStatic)) {
            throw new RuntimeException("New static version " + versionNewStatic + " already exists for module " + this.getModule() + '.');
        }
        return versionNewStatic;
    }

    protected Version getVersionLatestMatchingVersionStaticPrefix(List<Version> listVersionStatic, Version versionStaticPrefix) {
        for (Version version : listVersionStatic) {
            if (!version.getVersion().startsWith(versionStaticPrefix.getVersion())) continue;
            return version;
        }
        return null;
    }

    protected List<Version> getListVersionStaticForDynamicVersion(Version versionDynamic) {
        ScmPlugin scmPlugin = (ScmPlugin)this.getModule().getNodePlugin(ScmPlugin.class, null);
        ArrayList<Version> listVersionStatic = new ArrayList<Version>();
        List listCommit = scmPlugin.getListCommit(versionDynamic, null, EnumSet.of(ScmPlugin.GetListCommitFlag.IND_INCLUDE_VERSION_STATIC));
        for (ScmPlugin.Commit commit : listCommit) {
            listVersionStatic.addAll(Arrays.asList(commit.arrayVersionStatic));
        }
        return listVersionStatic;
    }

    protected List<Version> getListVersionStaticGlobal() {
        Module module = this.getModule();
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        VersionClassifierPlugin versionClassifierPlugin = (VersionClassifierPlugin)module.getNodePlugin(VersionClassifierPlugin.class, null);
        List listVersionStatic = scmPlugin.getListVersionStatic();
        Collections.sort(listVersionStatic, versionClassifierPlugin);
        return listVersionStatic;
    }
}

