/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.support;

import java.util.Properties;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.ModelFactory;
import org.azyva.dragom.model.support.DefaultModelFactory;
import org.azyva.dragom.util.Util;

public class ModelFactoryHolder {
    private static final String SYS_PROPERTY_DEFAULT_MODEL_FACTORY = "org.azyva.dragom.DefaultModelFactory";
    private static ModelFactory modelFactory;
    private static Model model;
    private static ModelFactory modelFactoryForLocalModel;

    public static void setModelFactory(ModelFactory modelFactory) {
        ModelFactoryHolder.modelFactory = modelFactory;
    }

    public static void setModel(Model model) {
        ModelFactoryHolder.model = model;
    }

    public static ModelFactory getModelFactory() {
        if (modelFactory != null) {
            return modelFactory;
        }
        if (model != null) {
            return modelFactoryForLocalModel;
        }
        String modelFactoryClass = System.getProperty(SYS_PROPERTY_DEFAULT_MODEL_FACTORY);
        if (modelFactoryClass != null) {
            try {
                Class<ModelFactory> classModelFactory = Class.forName(modelFactoryClass).asSubclass(ModelFactory.class);
                return classModelFactory.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        modelFactory = new DefaultModelFactory();
        return modelFactory;
    }

    static {
        modelFactoryForLocalModel = new ModelFactory(){

            public Model getModel(Properties propertiesInit) {
                return model;
            }
        };
        Util.applyDragomSystemProperties();
    }
}

