/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.util.ModuleReentryAvoider;

public class SimpleReferenceGraph
implements ReferenceGraph {
    private Map<ModuleVersion, ReferenceGraphNode> mapReferenceGraphNode = new LinkedHashMap<ModuleVersion, ReferenceGraphNode>();
    private Set<ModuleVersion> setModuleVersionRoot = new LinkedHashSet<ModuleVersion>();
    private Set<ModuleVersion> setModuleVersionMatched = new LinkedHashSet<ModuleVersion>();

    public boolean moduleVersionExists(ModuleVersion moduleVersion) {
        return this.mapReferenceGraphNode.containsKey(moduleVersion);
    }

    public List<ModuleVersion> getListModuleVersionRoot() {
        return new ArrayList<ModuleVersion>(this.setModuleVersionRoot);
    }

    public boolean isRootModuleVersion(ModuleVersion moduleVersion) {
        return this.setModuleVersionRoot.contains(moduleVersion);
    }

    public List<ModuleVersion> getListModuleVersionMatched() {
        return new ArrayList<ModuleVersion>(this.setModuleVersionMatched);
    }

    public boolean isMatchedModuleVersion(ModuleVersion moduleVersion) {
        return this.setModuleVersionMatched.contains(moduleVersion);
    }

    public List<ModuleVersion> getListModuleVersion(NodePath nodePath) {
        Set<ModuleVersion> setModuleVersion = this.mapReferenceGraphNode.keySet();
        if (nodePath == null) {
            return new ArrayList<ModuleVersion>(setModuleVersion);
        }
        ArrayList<ModuleVersion> listModuleVersion = new ArrayList<ModuleVersion>();
        for (ModuleVersion moduleVersion : setModuleVersion) {
            if (!moduleVersion.getNodePath().equals((Object)nodePath)) continue;
            listModuleVersion.add(moduleVersion);
        }
        return listModuleVersion;
    }

    public List<ReferenceGraph.Referrer> getListReferrer(ModuleVersion moduleVersionReferred) {
        ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(moduleVersionReferred);
        if (referenceGraphNode == null) {
            throw new RuntimeException("ModuleVersion " + moduleVersionReferred + " not in ReferenceGraph.");
        }
        if (referenceGraphNode.listReferrer == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(referenceGraphNode.listReferrer);
    }

    public List<Reference> getListReference(ModuleVersion moduleVersionReferrer) {
        ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(moduleVersionReferrer);
        if (referenceGraphNode == null) {
            throw new RuntimeException("ModuleVersion " + moduleVersionReferrer + " not in ReferenceGraph.");
        }
        if (referenceGraphNode.listReference == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(referenceGraphNode.listReference);
    }

    public boolean traverseReferenceGraph(ModuleVersion moduleVersion, boolean indDepthFirst, ReferenceGraph.ReentryMode reentryMode, ReferenceGraph.Visitor visitor) {
        ModuleReentryAvoider moduleReentryAvoider = new ModuleReentryAvoider();
        if (moduleVersion == null) {
            ReferencePath referencePath = new ReferencePath();
            for (ModuleVersion moduleVersion2 : this.setModuleVersionRoot) {
                if (this.traverseReferenceGraph(referencePath, new Reference(moduleVersion2), indDepthFirst, reentryMode, moduleReentryAvoider, visitor) != ReferenceGraph.VisitControl.ABORT) continue;
                return true;
            }
            return false;
        }
        ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(moduleVersion);
        if (referenceGraphNode == null) {
            throw new RuntimeException("ModuleVersion " + moduleVersion + " not in ReferenceGraph.");
        }
        return this.traverseReferenceGraph(new ReferencePath(), new Reference(referenceGraphNode.moduleVersion), indDepthFirst, reentryMode, moduleReentryAvoider, visitor) == ReferenceGraph.VisitControl.ABORT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReferenceGraph.VisitControl traverseReferenceGraph(ReferencePath referencePath, Reference reference, boolean indDepthFirst, ReferenceGraph.ReentryMode reentryMode, ModuleReentryAvoider moduleReentryAvoider, ReferenceGraph.Visitor visitor) {
        boolean isAlreadyProcessed = moduleReentryAvoider != null && !moduleReentryAvoider.processModule(reference.getModuleVersion());
        try {
            Object object;
            referencePath.add(reference);
            boolean isMatched = this.setModuleVersionMatched.contains(referencePath.getLeafModuleVersion());
            ReferenceGraph.VisitControl visitControl = ReferenceGraph.VisitControl.CONTINUE;
            if (!(indDepthFirst || isAlreadyProcessed && reentryMode == ReferenceGraph.ReentryMode.NO_REENTRY)) {
                visitControl = visitor.visit((ReferenceGraph)this, referencePath, isAlreadyProcessed ? (isMatched ? ReferenceGraph.VisitAction.ENUM_SET_REPEATED_VISIT_MATCHED : ReferenceGraph.VisitAction.ENUM_SET_REPEATED_VISIT) : (isMatched ? ReferenceGraph.VisitAction.ENUM_SET_VISIT_MATCHED : ReferenceGraph.VisitAction.ENUM_SET_VISIT));
                if (visitControl == ReferenceGraph.VisitControl.ABORT || visitControl == ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) {
                    ReferenceGraph.VisitControl visitControl2 = visitControl;
                    return visitControl2;
                }
            }
            if (!isAlreadyProcessed && visitControl != ReferenceGraph.VisitControl.SKIP_CHILDREN) {
                ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(reference.getModuleVersion());
                if (referenceGraphNode.listReference != null) {
                    visitControl = visitor.visit((ReferenceGraph)this, referencePath, ReferenceGraph.VisitAction.ENUM_SET_STEP_IN);
                    if (visitControl == ReferenceGraph.VisitControl.ABORT || visitControl == ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) {
                        ReferenceGraph.VisitControl visitControl3 = visitControl;
                        return visitControl3;
                    }
                    if (visitControl != ReferenceGraph.VisitControl.SKIP_CHILDREN) {
                        for (Reference reference2 : referenceGraphNode.listReference) {
                            visitControl = this.traverseReferenceGraph(referencePath, reference2, indDepthFirst, reentryMode, moduleReentryAvoider, visitor);
                            if (visitControl != ReferenceGraph.VisitControl.ABORT || visitControl != ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) continue;
                            ReferenceGraph.VisitControl visitControl4 = visitControl;
                            return visitControl4;
                        }
                    }
                    if ((visitControl = visitor.visit((ReferenceGraph)this, referencePath, ReferenceGraph.VisitAction.ENUM_SET_STEP_OUT)) == ReferenceGraph.VisitControl.ABORT || visitControl == ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) {
                        object = visitControl;
                        return object;
                    }
                    if (visitControl == ReferenceGraph.VisitControl.SKIP_CHILDREN) {
                        throw new RuntimeException("VisitControl.SKIP_CHILDREN not allowed for VisitAction.STEP_OUT.");
                    }
                }
            }
            if (indDepthFirst && (!isAlreadyProcessed || reentryMode != ReferenceGraph.ReentryMode.NO_REENTRY)) {
                visitControl = visitor.visit((ReferenceGraph)this, referencePath, isAlreadyProcessed ? (isMatched ? ReferenceGraph.VisitAction.ENUM_SET_REPEATED_VISIT_MATCHED : ReferenceGraph.VisitAction.ENUM_SET_REPEATED_VISIT) : (isMatched ? ReferenceGraph.VisitAction.ENUM_SET_VISIT_MATCHED : ReferenceGraph.VisitAction.ENUM_SET_VISIT));
                if (visitControl == ReferenceGraph.VisitControl.ABORT || visitControl == ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) {
                    object = visitControl;
                    return object;
                }
                if (visitControl == ReferenceGraph.VisitControl.SKIP_CHILDREN) {
                    throw new RuntimeException("VisitControl.SKIP_CHILDREN not allowed for depth-first traversal.");
                }
            }
            object = ReferenceGraph.VisitControl.CONTINUE;
            return object;
        }
        finally {
            referencePath.removeLeafReference();
        }
    }

    public boolean visitLeafModuleVersionReferencePaths(ModuleVersion moduleVersion, ReferenceGraph.Visitor visitor) {
        ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(moduleVersion);
        if (referenceGraphNode == null) {
            throw new RuntimeException("ModuleVersion " + moduleVersion + " not in ReferenceGraph.");
        }
        return this.traverseReferenceGraphForLeafModuleVersionReferencePaths(new ReferencePath(), moduleVersion, visitor) == ReferenceGraph.VisitControl.ABORT;
    }

    private ReferenceGraph.VisitControl traverseReferenceGraphForLeafModuleVersionReferencePaths(ReferencePath referencePath, ModuleVersion moduleVersion, ReferenceGraph.Visitor visitor) {
        ReferencePath referencePathIncludingParent;
        if (this.setModuleVersionRoot.contains(moduleVersion)) {
            referencePathIncludingParent = new ReferencePath();
            referencePathIncludingParent.add(new Reference(moduleVersion));
            referencePathIncludingParent.add(referencePath);
            ReferenceGraph.VisitControl visitControl = visitor.visit((ReferenceGraph)this, referencePathIncludingParent, this.setModuleVersionMatched.contains(referencePathIncludingParent.getLeafModuleVersion()) ? ReferenceGraph.VisitAction.ENUM_SET_VISIT_MATCHED : ReferenceGraph.VisitAction.ENUM_SET_VISIT);
            if (visitControl == ReferenceGraph.VisitControl.SKIP_CHILDREN || visitControl == ReferenceGraph.VisitControl.SKIP_CURRENT_ROOT) {
                throw new RuntimeException("VisitControl.SKIP_CHILDREN and VisitControl.SKIP_CURRENT_ROOT not allowed with visitLeafModuleVersionReferencePaths.");
            }
            if (visitControl == ReferenceGraph.VisitControl.ABORT) {
                return ReferenceGraph.VisitControl.ABORT;
            }
        }
        ReferenceGraphNode referenceGraphNode = this.mapReferenceGraphNode.get(moduleVersion);
        if (referenceGraphNode.listReferrer != null) {
            for (ReferenceGraph.Referrer referrer : referenceGraphNode.listReferrer) {
                referencePathIncludingParent = new ReferencePath();
                referencePathIncludingParent.add(referrer.getReference());
                referencePathIncludingParent.add(referencePath);
                if (this.traverseReferenceGraphForLeafModuleVersionReferencePaths(referencePathIncludingParent, referrer.getModuleVersion(), visitor) != ReferenceGraph.VisitControl.ABORT) continue;
                return ReferenceGraph.VisitControl.ABORT;
            }
        }
        return ReferenceGraph.VisitControl.CONTINUE;
    }

    public void addRootModuleVersion(ModuleVersion moduleVersionRoot) {
        if (!this.mapReferenceGraphNode.containsKey(moduleVersionRoot)) {
            this.mapReferenceGraphNode.put(moduleVersionRoot, new ReferenceGraphNode(moduleVersionRoot));
        }
        this.setModuleVersionRoot.add(moduleVersionRoot);
    }

    public void addReference(ModuleVersion moduleVersionReferrer, Reference reference) {
        ReferenceGraph.Referrer referrer;
        ReferenceGraphNode referenceGraphNodeReference;
        ReferenceGraphNode referenceGraphNodeReferrer = this.mapReferenceGraphNode.get(moduleVersionReferrer);
        if (referenceGraphNodeReferrer == null) {
            referenceGraphNodeReferrer = new ReferenceGraphNode(moduleVersionReferrer);
            this.mapReferenceGraphNode.put(moduleVersionReferrer, referenceGraphNodeReferrer);
        }
        if (referenceGraphNodeReferrer.listReference == null) {
            referenceGraphNodeReferrer.listReference = new ArrayList<Reference>();
        }
        if (!referenceGraphNodeReferrer.listReference.contains(reference)) {
            referenceGraphNodeReferrer.listReference.add(reference);
        }
        if ((referenceGraphNodeReference = this.mapReferenceGraphNode.get(reference.getModuleVersion())) == null) {
            referenceGraphNodeReference = new ReferenceGraphNode(reference.getModuleVersion());
            this.mapReferenceGraphNode.put(reference.getModuleVersion(), referenceGraphNodeReference);
        }
        if (referenceGraphNodeReference.listReferrer == null) {
            referenceGraphNodeReference.listReferrer = new ArrayList<ReferenceGraph.Referrer>();
        }
        if (!referenceGraphNodeReference.listReferrer.contains(referrer = new ReferenceGraph.Referrer(moduleVersionReferrer, reference))) {
            referenceGraphNodeReference.listReferrer.add(referrer);
        }
    }

    public void addMatchedReferencePath(ReferencePath referencePath) {
        ModuleVersion moduleVersionParent = null;
        for (int i = 0; i < referencePath.size(); ++i) {
            if (i == 0) {
                moduleVersionParent = referencePath.get(i).getModuleVersion();
                this.addRootModuleVersion(moduleVersionParent);
                continue;
            }
            Reference reference = referencePath.get(i);
            this.addReference(moduleVersionParent, reference);
            moduleVersionParent = reference.getModuleVersion();
        }
        this.setModuleVersionMatched.add(referencePath.getLeafModuleVersion());
    }

    private static class ReferenceGraphNode {
        public ModuleVersion moduleVersion;
        public List<ReferenceGraph.Referrer> listReferrer;
        public List<Reference> listReference;

        public ReferenceGraphNode(ModuleVersion moduleVersion) {
            this.moduleVersion = moduleVersion;
        }
    }
}

