/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.util;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.azyva.dragom.util.Util;

public class ServiceLocator {
    private static final String SYS_PROPERTY_PREFIX_DEFAULT_SERVICE_FACTORY = "org.azyva.dragom.DefaultServiceFactory.";
    private static final String SYS_PROPERTY_PREFIX_DEFAULT_SERVICE_IMPL = "org.azyva.dragom.DefaultServiceImpl.";
    private static Map<Class<?>, ServiceFactory<?>> mapServiceFactory = new HashMap();

    private ServiceLocator() {
    }

    public static <ServiceInterface> void setServiceFactory(Class<ServiceInterface> classServiceInterface, ServiceFactory<ServiceInterface> serviceFactory) {
        mapServiceFactory.put(classServiceInterface, serviceFactory);
    }

    public static <ServiceInterface> ServiceInterface getService(Class<ServiceInterface> classServiceInterface) {
        ServiceFactory<?> serviceFactory = mapServiceFactory.get(classServiceInterface);
        if (serviceFactory != null) {
            return (ServiceInterface)serviceFactory.getService();
        }
        String serviceFactoryClassName = System.getProperty(SYS_PROPERTY_PREFIX_DEFAULT_SERVICE_FACTORY + classServiceInterface.getName());
        if (serviceFactoryClassName != null) {
            try {
                return (ServiceInterface)Class.forName(serviceFactoryClassName).getMethod("getService", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        String serviceImplClassName = System.getProperty(SYS_PROPERTY_PREFIX_DEFAULT_SERVICE_IMPL + classServiceInterface.getName());
        if (serviceImplClassName != null) {
            try {
                return (ServiceInterface)Class.forName(serviceImplClassName).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (ServiceInterface)Class.forName(classServiceInterface.getPackage() + ".impl.Default" + classServiceInterface.getSimpleName() + "Factory").getMethod("getService", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return (ServiceInterface)Class.forName(classServiceInterface.getPackage() + ".impl.Default" + classServiceInterface.getSimpleName() + "Impl").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Util.applyDragomSystemProperties();
    }

    public static interface ServiceFactory<ServiceInterface> {
        public ServiceInterface getService();
    }
}

