/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.util.Util;

public class DragomToolInvoker {
    public static final String MSG_PATTERN_KEY_UNKNOWN_TOOL = "UNKNOWN_TOOL";
    private static final String SYS_PROPERTY_TOOLS = "org.azyva.dragom.Tools";
    private static final String SYS_PROPERTY_PREFIX_TOOL = "org.azyva.dragom.Tool.";
    private static final String SYS_PROPERTY_SUFFIX_TOOL_CLASS = ".ToolClass";
    private static final String SYS_PROPERTY_SUFFIX_FIXED_ARGS = ".FixedArgs";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(DragomToolInvoker.class.getName() + "ResourceBundle");
    private static boolean indInit;
    private static Map<String, ToolInvocationInfo> mapToolInvocationInfo;

    public static void main(String[] args) {
        String firstArg;
        DragomToolInvoker.init();
        if (args.length == 0 || args[0] == "--" + CliUtil.getHelpCommandLineOption()) {
            DragomToolInvoker.help();
            System.exit(args.length == 0 || args.length > 1 ? 1 : 0);
        }
        if ((firstArg = args[0]).equals(CliUtil.getHelpCommandLineOption())) {
            if (args.length > 2) {
                DragomToolInvoker.help();
                System.exit(1);
            }
            String tool = args[1];
            ToolInvocationInfo toolInvocationInfo = DragomToolInvoker.getToolInvocationInfo(tool);
            DragomToolInvoker.invokeTool(toolInvocationInfo, new String[]{"--" + CliUtil.getHelpCommandLineOption()});
        } else {
            String tool = args[0];
            ToolInvocationInfo toolInvocationInfo = DragomToolInvoker.getToolInvocationInfo(tool);
            DragomToolInvoker.invokeTool(toolInvocationInfo, Arrays.copyOfRange(args, 1, args.length));
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            String[] arrayTool;
            Util.applyDragomSystemProperties();
            mapToolInvocationInfo = new LinkedHashMap<String, ToolInvocationInfo>();
            for (String tool : arrayTool = System.getProperty(SYS_PROPERTY_TOOLS).split(",")) {
                ToolInvocationInfo toolInvocationInfo = new ToolInvocationInfo();
                try {
                    toolInvocationInfo.classTool = Class.forName(System.getProperty(SYS_PROPERTY_PREFIX_TOOL + tool + SYS_PROPERTY_SUFFIX_TOOL_CLASS));
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
                String fixedArgs = System.getProperty(SYS_PROPERTY_PREFIX_TOOL + tool + SYS_PROPERTY_SUFFIX_FIXED_ARGS);
                if (fixedArgs != null) {
                    toolInvocationInfo.arrayFixedArgs = fixedArgs.split(",");
                }
                mapToolInvocationInfo.put(tool, toolInvocationInfo);
            }
            indInit = true;
        }
    }

    private static void invokeTool(ToolInvocationInfo toolInvocationInfo, String[] arrayArgs) {
        String[] arrayRealArgs;
        if (toolInvocationInfo.arrayFixedArgs != null) {
            arrayRealArgs = new String[toolInvocationInfo.arrayFixedArgs.length + arrayArgs.length];
            System.arraycopy(toolInvocationInfo.arrayFixedArgs, 0, arrayRealArgs, 0, toolInvocationInfo.arrayFixedArgs.length);
            System.arraycopy(arrayArgs, 0, arrayRealArgs, toolInvocationInfo.arrayFixedArgs.length, arrayArgs.length);
        } else {
            arrayRealArgs = arrayArgs;
        }
        try {
            Method method = toolInvocationInfo.classTool.getMethod("main", String[].class);
            method.invoke(null, new Object[]{arrayRealArgs});
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause().getClass().getName().contains("ExitException")) {
                throw (RuntimeException)ite.getCause();
            }
            throw new RuntimeException(ite);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static ToolInvocationInfo getToolInvocationInfo(String tool) {
        ToolInvocationInfo toolInvocationInfo = mapToolInvocationInfo.get(tool);
        if (toolInvocationInfo == null) {
            System.err.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_UNKNOWN_TOOL), tool));
            System.exit(1);
        }
        return toolInvocationInfo;
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(DragomToolInvoker.class, "DragomToolInvokerHelp.txt"), (OutputStream)System.out);
            for (String tool : mapToolInvocationInfo.keySet()) {
                System.out.println(tool);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class ToolInvocationInfo {
        Class<?> classTool;
        String[] arrayFixedArgs;

        private ToolInvocationInfo() {
        }
    }
}

