/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ArtifactGroupId {
    private static final String MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_PARSING_ERROR = "ARTIFACT_GROUP_ID_PARSING_ERROR";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ArtifactGroupId.class.getName() + "ResourceBundle");
    private static final Pattern patternArtifactGroupIdLiteral = Pattern.compile("([a-zA-Z][a-zA-Z0-9\\.\\-_]*):([a-zA-Z][a-zA-Z0-9\\.\\-_]*)");
    private String groupId;
    private String artifactId;

    public ArtifactGroupId(String groupId, String artifactId) {
        if (groupId == null || artifactId == null) {
            throw new RuntimeException("The groupId and artifactId cannot be null.");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    public ArtifactGroupId(String stringArtifactGroupId) {
        Matcher matcher = patternArtifactGroupIdLiteral.matcher(stringArtifactGroupId);
        try {
            if (!matcher.matches()) {
                throw new ParseException(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_PARSING_ERROR), stringArtifactGroupId, patternArtifactGroupIdLiteral), 0);
            }
            this.groupId = matcher.group(1);
            this.artifactId = matcher.group(2);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe);
        }
    }

    public static ArtifactGroupId parse(String stringArtifactGroupId) throws ParseException {
        try {
            return new ArtifactGroupId(stringArtifactGroupId);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof ParseException) {
                throw (ParseException)re.getCause();
            }
            throw re;
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String toString() {
        return this.groupId + ':' + this.artifactId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactGroupId)) {
            return false;
        }
        ArtifactGroupId artifactGroupIdOther = (ArtifactGroupId)other;
        return this.groupId.equals(artifactGroupIdOther.groupId) && this.artifactId.equals(artifactGroupIdOther.artifactId);
    }
}

