/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.reference;

import java.util.Map;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.reference.ReferencePathMatcher;

public class ReferencePathMatcherVersionAttribute
implements ReferencePathMatcher {
    private String versionAttributeName;
    private String versionAttributeValue;
    private Model model;

    public ReferencePathMatcherVersionAttribute(String versionAttributeName, String versionAttributeValue, Model model) {
        this.versionAttributeName = versionAttributeName;
        this.versionAttributeValue = versionAttributeValue;
        this.model = model;
    }

    @Override
    public boolean matches(ReferencePath referencePath) {
        ModuleVersion moduleVersion = referencePath.getLeafModuleVersion();
        Module module = this.model.getModule(moduleVersion.getNodePath());
        ScmPlugin scmPlugin = module.getNodePlugin(ScmPlugin.class, null);
        Map<String, String> mapVersionAttr = scmPlugin.getMapVersionAttr(moduleVersion.getVersion());
        String versionAttributeValueFound = mapVersionAttr.get(this.versionAttributeName);
        if (versionAttributeValueFound == null) {
            return false;
        }
        return versionAttributeValueFound.equals(this.versionAttributeValue);
    }

    @Override
    public boolean canMatchChildren(ReferencePath referencePath) {
        return true;
    }
}

