/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.ReferenceGraphReport;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class ReferenceGraphReportTool {
    public static final String MSG_PATTERN_KEY_OUTPUT_FORMAT_POSSIBLE_VALUES = "OUTPUT_FORMAT_POSSIBLE_VALUES";
    public static final String MSG_PATTERN_KEY_GRAPH_OR_MODULE_VERSION_REQUIRED = "GRAPH_OR_MODULE_VERSION_REQUIRED";
    public static final String MSG_PATTERN_KEY_GRAPH_REQUIRED_WHEN = "GRAPH_REQUIRED_WHEN";
    public static final String MSG_PATTERN_KEY_MODULE_VERSIONS_REQUIRED_WHEN = "MODULE_VERSIONS_REQUIRED_WHEN";
    public static final String MSG_PATTERN_KEY_ONLY_MULTIPLE_VERSIONS_AND_ONLY_MATCHED_MODULES_MUTUALLY_EXCLUSIVE = "ONLY_MULTIPLE_VERSIONS_AND_ONLY_MATCHED_MODULES_MUTUALLY_EXCLUSIVE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ReferenceGraphReportTool.class.getName() + "ResourceBundle");
    private static boolean indInit;
    private static Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block24: {
            CommandLine commandLine = null;
            ReferenceGraphReportTool.init();
            try {
                ReferenceGraphReport.OutputFormat outputFormat;
                DefaultParser defaultParser = new DefaultParser();
                try {
                    commandLine = defaultParser.parse(options, args);
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE"), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
                if (CliUtil.hasHelpOption(commandLine)) {
                    ReferenceGraphReportTool.help();
                    break block24;
                }
                args = commandLine.getArgs();
                if (args.length != 1) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
                }
                CliUtil.setupExecContext(commandLine, true);
                if (!commandLine.hasOption("output-format")) {
                    outputFormat = ReferenceGraphReport.OutputFormat.TEXT;
                } else {
                    try {
                        outputFormat = ReferenceGraphReport.OutputFormat.valueOf((String)commandLine.getOptionValue("output-format"));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE_OPTION"), "output-format", resourceBundle.getString(MSG_PATTERN_KEY_OUTPUT_FORMAT_POSSIBLE_VALUES), CliUtil.getHelpCommandLineOption()));
                    }
                }
                if (!commandLine.hasOption("graph") && !commandLine.hasOption("module-versions")) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_GRAPH_OR_MODULE_VERSION_REQUIRED), CliUtil.getHelpCommandLineOption()));
                }
                if (commandLine.hasOption("avoid-redundancy") && !commandLine.hasOption("graph")) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_GRAPH_REQUIRED_WHEN), CliUtil.getHelpCommandLineOption()));
                }
                if ((commandLine.hasOption("only-multiple-versions") || commandLine.hasOption("only-matched-modules") || commandLine.hasOption("most-recent-version-in-reference-graph") || commandLine.hasOption("most-recent-static-version-in-scm") || commandLine.hasOption("reference-paths")) && !commandLine.hasOption("module-versions")) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSIONS_REQUIRED_WHEN), CliUtil.getHelpCommandLineOption()));
                }
                if (commandLine.hasOption("only-multiple-versions") && commandLine.hasOption("only-matched-modules")) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ONLY_MULTIPLE_VERSIONS_AND_ONLY_MATCHED_MODULES_MUTUALLY_EXCLUSIVE), CliUtil.getHelpCommandLineOption()));
                }
                ReferenceGraphReport referenceGraphReport = new ReferenceGraphReport(CliUtil.getListModuleVersionRoot(commandLine), outputFormat);
                referenceGraphReport.setReferencePathMatcherProvided(CliUtil.getReferencePathMatcher(commandLine));
                referenceGraphReport.setOutputFilePath(Paths.get(args[0], new String[0]));
                if (commandLine.hasOption("graph")) {
                    ReferenceGraphReport.ReferenceGraphMode referenceGraphMode = commandLine.hasOption("avoid-redundancy") ? ReferenceGraphReport.ReferenceGraphMode.TREE_NO_REDUNDANCY : ReferenceGraphReport.ReferenceGraphMode.FULL_TREE;
                    referenceGraphReport.includeReferenceGraph(referenceGraphMode);
                }
                if (commandLine.hasOption("module-versions")) {
                    ReferenceGraphReport.ModuleFilter moduleFilter = commandLine.hasOption("only-multiple-versions") ? ReferenceGraphReport.ModuleFilter.ONLY_MULTIPLE_VERSIONS : (commandLine.hasOption("only-matched-modules") ? ReferenceGraphReport.ModuleFilter.ONLY_MATCHED : ReferenceGraphReport.ModuleFilter.ALL);
                    referenceGraphReport.includeModules(moduleFilter);
                }
                if (commandLine.hasOption("most-recent-version-in-reference-graph")) {
                    referenceGraphReport.includeMostRecentVersionInReferenceGraph();
                }
                if (commandLine.hasOption("most-recent-static-version-in-scm")) {
                    referenceGraphReport.includeMostRecentStaticVersionInScm();
                }
                if (commandLine.hasOption("reference-paths")) {
                    referenceGraphReport.includeReferencePaths();
                }
                referenceGraphReport.performJob();
            }
            catch (RuntimeExceptionUserError reue) {
                System.err.println(CliUtil.getLocalizedMsgPattern("USER_ERROR_PREFIX") + reue.getMessage());
                System.exit(1);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                System.exit(1);
            }
            finally {
                ExecContextHolder.endToolAndUnset();
            }
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            CliUtil.initJavaUtilLogging();
            options = new Options();
            Option option = new Option(null, null);
            option.setLongOpt("output-format");
            option.setArgs(1);
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("graph");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("avoid-redundancy");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("module-versions");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("only-multiple-versions");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("only-matched-modules");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("most-recent-version-in-reference-graph");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("most-recent-static-version-in-scm");
            options.addOption(option);
            option = new Option(null, null);
            option.setLongOpt("reference-paths");
            options.addOption(option);
            CliUtil.addStandardOptions(options);
            CliUtil.addRootModuleVersionOptions(options);
            indInit = true;
        }
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(ReferenceGraphReportTool.class, "ReferenceGraphReportToolHelp.txt"), (OutputStream)System.out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

