/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.tool;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.azyva.dragom.cliutil.CliUtil;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootManager;
import org.azyva.dragom.model.ArtifactGroupIdVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.reference.ReferencePathMatcher;
import org.azyva.dragom.reference.ReferencePathMatcherByElement;
import org.azyva.dragom.reference.ReferencePathMatcherOr;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class RootManagerTool {
    private static final String MSG_PATTERN_KEY_LIST_OF_ROOT_MODULE_VERSIONS_EMPTY = "LIST_OF_ROOT_MODULE_VERSIONS_EMPTY";
    private static final String MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_DOES_NOT_CORRESPOND_TO_MODULE = "ARTIFACT_GROUP_ID_DOES_NOT_CORRESPOND_TO_MODULE";
    private static final String MSG_PATTERN_KEY_ARTIFACT_VERSION_CANNOT_MAP_TO_VERSION = "ARTIFACT_VERSION_CANNOT_MAP_TO_VERSION";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_ALREADY_IN_LIST_OF_ROOTS = "MODULE_VERSION_ALREADY_IN_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS = "MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_REPLACED_IN_LIST_OF_ROOTS = "MODULE_VERSION_REPLACED_IN_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_NOT_IN_LIST_OF_ROOTS = "MODULE_VERSION_NOT_IN_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_REMOVED_FROM_LIST_OF_ROOTS = "MODULE_VERSION_REMOVED_FROM_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_ALL_MODULE_VERSIONS_REMOVED_FROM_LIST_OF_ROOTS = "ALL_MODULE_VERSIONS_REMOVED_FROM_LIST_OF_ROOTS";
    private static final String MSG_PATTERN_KEY_LIST_REFERENCE_PATH_MATCHERS_EMPTY = "LIST_REFERENCE_PATH_MATCHERS_EMPTY";
    private static final String MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_ALREADY_IN_LIST = "REFERENCE_PATH_MATCHER_ALREADY_IN_LIST";
    private static final String MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_ADDED_TO_LIST = "REFERENCE_PATH_MATCHER_ADDED_TO_LIST";
    private static final String MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_NOT_IN_LIST = "REFERENCE_PATH_MATCHER_NOT_IN_LIST";
    private static final String MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST = "REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST";
    private static final String MSG_PATTERN_KEY_ALL_REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST = "ALL_REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(RootManagerTool.class.getName() + "ResourceBundle");
    private static boolean indInit;
    private static Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block20: {
            RootManagerTool.init();
            try {
                CommandLine commandLine;
                DefaultParser defaultParser = new DefaultParser();
                try {
                    commandLine = defaultParser.parse(options, args);
                }
                catch (ParseException pe) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("ERROR_PARSING_COMMAND_LINE"), pe.getMessage(), CliUtil.getHelpCommandLineOption()));
                }
                if (CliUtil.hasHelpOption(commandLine)) {
                    RootManagerTool.help();
                    break block20;
                }
                args = commandLine.getArgs();
                if (args.length < 1) {
                    throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
                }
                CliUtil.setupExecContext(commandLine, true);
                String command = args[0];
                if (command.equals("list")) {
                    RootManagerTool.listCommand(commandLine);
                    break block20;
                }
                if (command.equals("add")) {
                    RootManagerTool.addCommand(commandLine);
                    break block20;
                }
                if (command.equals("add-artifact")) {
                    RootManagerTool.addArtifactCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove")) {
                    RootManagerTool.removeCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove-all")) {
                    RootManagerTool.removeAllCommand(commandLine);
                    break block20;
                }
                if (command.equals("list-reference-path-matchers")) {
                    RootManagerTool.listReferencePathMatchersCommand(commandLine);
                    break block20;
                }
                if (command.equals("add-reference-path-matcher")) {
                    RootManagerTool.addReferencePathMatcherCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove-reference-path-matcher")) {
                    RootManagerTool.removeReferencePathMatcherCommand(commandLine);
                    break block20;
                }
                if (command.equals("remove-all-reference-path-matchers")) {
                    RootManagerTool.removeAllReferencePathMatchersCommand(commandLine);
                    break block20;
                }
                throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_COMMAND"), command, CliUtil.getHelpCommandLineOption()));
            }
            catch (RuntimeExceptionUserError reue) {
                System.err.println(CliUtil.getLocalizedMsgPattern("USER_ERROR_PREFIX") + reue.getMessage());
                System.exit(1);
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                System.exit(1);
            }
            finally {
                ExecContextHolder.endToolAndUnset();
            }
        }
    }

    private static synchronized void init() {
        if (!indInit) {
            CliUtil.initJavaUtilLogging();
            options = new Options();
            Option option = new Option(null, null);
            option.setLongOpt("ind-allow-duplicate-modules");
            options.addOption(option);
            CliUtil.addStandardOptions(options);
            indInit = true;
        }
    }

    private static void help() {
        try {
            IOUtils.copy((InputStream)CliUtil.getLocalizedResourceAsStream(RootManagerTool.class, "RootManagerToolHelp.txt"), (OutputStream)System.out);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static void listCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        List listModuleVersion = RootManager.getListModuleVersion();
        if (listModuleVersion.isEmpty()) {
            System.out.println(resourceBundle.getString(MSG_PATTERN_KEY_LIST_OF_ROOT_MODULE_VERSIONS_EMPTY));
        } else {
            for (ModuleVersion moduleVersion : listModuleVersion) {
                System.out.println(moduleVersion.toString());
            }
        }
    }

    private static void addCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        for (int i = 1; i < args.length; ++i) {
            ModuleVersion moduleVersion;
            try {
                moduleVersion = ModuleVersion.parse((String)args[i]);
            }
            catch (java.text.ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
            if (RootManager.containsModuleVersion((ModuleVersion)moduleVersion)) {
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ALREADY_IN_LIST_OF_ROOTS), moduleVersion));
                continue;
            }
            boolean indAllowDuplicateModule = commandLine.hasOption("ind-allow-duplicate-modules");
            if (indAllowDuplicateModule) {
                RootManager.addModuleVersion((ModuleVersion)moduleVersion, (boolean)true);
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS), moduleVersion));
                continue;
            }
            ModuleVersion moduleVersionOrg = RootManager.getModuleVersion((NodePath)moduleVersion.getNodePath());
            if (moduleVersionOrg != null) {
                RootManager.replaceModuleVersion((ModuleVersion)moduleVersionOrg, (ModuleVersion)moduleVersion);
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_REPLACED_IN_LIST_OF_ROOTS), moduleVersionOrg, moduleVersion));
                continue;
            }
            RootManager.addModuleVersion((ModuleVersion)moduleVersion, (boolean)false);
            System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS), moduleVersion));
        }
    }

    private static void addArtifactCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        for (int i = 1; i < args.length; ++i) {
            ArtifactGroupIdVersion artifactGroupIdVersion;
            try {
                artifactGroupIdVersion = ArtifactGroupIdVersion.parse((String)args[i]);
            }
            catch (java.text.ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
            ExecContext execContext = ExecContextHolder.get();
            Model model = execContext.getModel();
            Module module = model.findModuleByArtifactGroupId(artifactGroupIdVersion.getArtifactGroupId());
            if (module == null) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_GROUP_ID_DOES_NOT_CORRESPOND_TO_MODULE), artifactGroupIdVersion.getArtifactGroupId()));
            }
            if (!module.isNodePluginExists(ArtifactVersionMapperPlugin.class, null)) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_ARTIFACT_VERSION_CANNOT_MAP_TO_VERSION), artifactGroupIdVersion.getArtifactVersion(), module.getNodePath()));
            }
            ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)module.getNodePlugin(ArtifactVersionMapperPlugin.class, null);
            Version version = artifactVersionMapperPlugin.mapArtifactVersionToVersion(artifactGroupIdVersion.getArtifactVersion());
            ModuleVersion moduleVersion = new ModuleVersion(module.getNodePath(), version);
            if (RootManager.containsModuleVersion((ModuleVersion)moduleVersion)) {
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ALREADY_IN_LIST_OF_ROOTS), moduleVersion));
                continue;
            }
            boolean indAllowDuplicateModule = commandLine.hasOption("ind-allow-duplicate-modules");
            if (indAllowDuplicateModule) {
                RootManager.addModuleVersion((ModuleVersion)moduleVersion, (boolean)true);
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS), moduleVersion));
                continue;
            }
            ModuleVersion moduleVersionOrg = RootManager.getModuleVersion((NodePath)moduleVersion.getNodePath());
            if (moduleVersionOrg != null) {
                RootManager.replaceModuleVersion((ModuleVersion)moduleVersionOrg, (ModuleVersion)moduleVersion);
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_REPLACED_IN_LIST_OF_ROOTS), moduleVersionOrg, moduleVersion));
                continue;
            }
            RootManager.addModuleVersion((ModuleVersion)moduleVersion, (boolean)false);
            System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_ADDED_TO_LIST_OF_ROOTS), moduleVersion));
        }
    }

    private static void removeCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        for (int i = 1; i < args.length; ++i) {
            ModuleVersion moduleVersion;
            try {
                moduleVersion = ModuleVersion.parse((String)args[i]);
            }
            catch (java.text.ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
            if (!RootManager.containsModuleVersion((ModuleVersion)moduleVersion)) {
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_NOT_IN_LIST_OF_ROOTS), moduleVersion));
                continue;
            }
            RootManager.removeModuleVersion((ModuleVersion)moduleVersion);
            System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_REMOVED_FROM_LIST_OF_ROOTS), moduleVersion));
        }
    }

    private static void removeAllCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        RootManager.removeAllModuleVersion();
        System.out.println(resourceBundle.getString(MSG_PATTERN_KEY_ALL_MODULE_VERSIONS_REMOVED_FROM_LIST_OF_ROOTS));
    }

    private static void listReferencePathMatchersCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ReferencePathMatcherOr referencePathMatcherOr = RootManager.getReferencePathMatcherOr();
        List listReferencePathMatcher = referencePathMatcherOr.getListReferencePathMatcher();
        if (listReferencePathMatcher.isEmpty()) {
            System.out.println(resourceBundle.getString(MSG_PATTERN_KEY_LIST_REFERENCE_PATH_MATCHERS_EMPTY));
        } else {
            for (ReferencePathMatcher referencePathMatcher : listReferencePathMatcher) {
                System.out.println(referencePathMatcher.toString());
            }
        }
    }

    private static void addReferencePathMatcherCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        for (int i = 1; i < args.length; ++i) {
            ReferencePathMatcherByElement referencePathMatcherByElement;
            ReferencePathMatcherOr referencePathMatcherOr = RootManager.getReferencePathMatcherOr();
            try {
                referencePathMatcherByElement = ReferencePathMatcherByElement.parse((String)args[i], (Model)ExecContextHolder.get().getModel());
            }
            catch (java.text.ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
            if (referencePathMatcherOr.getListReferencePathMatcher().contains(referencePathMatcherByElement)) {
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_ALREADY_IN_LIST), referencePathMatcherByElement));
                continue;
            }
            referencePathMatcherOr.addReferencePathMatcher((ReferencePathMatcher)referencePathMatcherByElement);
            RootManager.saveReferencePathMatcherOr();
            System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_ADDED_TO_LIST), referencePathMatcherByElement));
        }
    }

    private static void removeReferencePathMatcherCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length < 2) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        for (int i = 1; i < args.length; ++i) {
            ReferencePathMatcherByElement referencePathMatcherByElement;
            ReferencePathMatcherOr referencePathMatcherOr = RootManager.getReferencePathMatcherOr();
            try {
                referencePathMatcherByElement = ReferencePathMatcherByElement.parse((String)args[i], (Model)ExecContextHolder.get().getModel());
            }
            catch (java.text.ParseException pe) {
                throw new RuntimeExceptionUserError(pe.getMessage());
            }
            if (!referencePathMatcherOr.getListReferencePathMatcher().contains(referencePathMatcherByElement)) {
                System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_NOT_IN_LIST), referencePathMatcherByElement));
                continue;
            }
            referencePathMatcherOr.getListReferencePathMatcher().remove(referencePathMatcherByElement);
            System.out.println(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST), referencePathMatcherByElement));
            RootManager.saveReferencePathMatcherOr();
        }
    }

    private static void removeAllReferencePathMatchersCommand(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        if (args.length != 1) {
            throw new RuntimeExceptionUserError(MessageFormat.format(CliUtil.getLocalizedMsgPattern("INVALID_ARGUMENT_COUNT"), CliUtil.getHelpCommandLineOption()));
        }
        ReferencePathMatcherOr referencePathMatcherOr = RootManager.getReferencePathMatcherOr();
        referencePathMatcherOr.getListReferencePathMatcher().clear();
        RootManager.saveReferencePathMatcherOr();
        System.out.println(resourceBundle.getString(MSG_PATTERN_KEY_ALL_REFERENCE_PATH_MATCHER_REMOVED_FROM_LIST));
    }
}

