/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.ExecContextFactory;
import org.azyva.dragom.execcontext.ToolLifeCycleExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContextFactory;
import org.azyva.dragom.execcontext.plugin.ExecContextPlugin;
import org.azyva.dragom.execcontext.plugin.ExecContextPluginFactory;
import org.azyva.dragom.execcontext.plugin.ToolLifeCycleExecContextPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.support.ExecContextPluginFactoryHolder;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.support.ModelFactoryHolder;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.SortedProperties;
import org.azyva.dragom.util.Util;

public class DefaultExecContextFactory
implements ExecContextFactory,
WorkspaceExecContextFactory {
    private static final String INIT_PROPERTY_WORKSPACE_DIR = "WORKSPACE_PATH";
    private static final String DRAGOM_METADATA_DIR = ".dragom";
    private static final String EXEC_CONTEXT_PROPERTY_WORKSPACE_FORMAT = "WORKSPACE_FORMAT";
    private static final String EXEC_CONTEXT_PROPERTY_WORKSPACE_VERSION = "WORKSPACE_VERSION";
    private static final String PROPERTIES_FILE = "exec-context.properties";
    private static final String INIT_PROPERTY_IND_IGNORE_CACHED_EXEC_CONTEXT = "IND_IGNORE_CACHED_EXEC_CONTEXT";
    private static final String MSG_PATTERN_KEY_WORKSPACE_DIR_INIT = "WORKSPACE_DIR_INIT";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(DefaultExecContextFactory.class.getName() + "ResourceBundle");
    private static Map<Path, DefaultExecContextImpl> mapPathWorkspaceDirDefaultExecContextImpl = new HashMap<Path, DefaultExecContextImpl>();

    public ExecContext getExecContext(Properties propertiesInit) {
        DefaultExecContextImpl defaultExecContextImpl;
        boolean indIgnoreCachedExecContext;
        Path pathWorkspaceDir;
        String workspaceDir = propertiesInit.getProperty(INIT_PROPERTY_WORKSPACE_DIR);
        if (workspaceDir == null) {
            workspaceDir = System.getProperty("user.dir");
            pathWorkspaceDir = Paths.get(workspaceDir, new String[0]).normalize();
            File fileDragomMetadataDir = pathWorkspaceDir.resolve(DRAGOM_METADATA_DIR).toFile();
            if (!fileDragomMetadataDir.exists()) {
                for (Path pathWorkspaceDirParent = pathWorkspaceDir.getParent(); pathWorkspaceDirParent != null; pathWorkspaceDirParent = pathWorkspaceDirParent.getParent()) {
                    fileDragomMetadataDir = pathWorkspaceDirParent.resolve(DRAGOM_METADATA_DIR).toFile();
                    if (!fileDragomMetadataDir.exists()) continue;
                    throw new RuntimeExceptionUserError("Workspace directory " + pathWorkspaceDir + " is itself within a workspace directory (one of its parent contains a .dragom directory or file).");
                }
            }
        } else {
            pathWorkspaceDir = Paths.get(workspaceDir, new String[0]).normalize();
        }
        if (indIgnoreCachedExecContext = Util.isNotNullAndTrue(propertiesInit.getProperty(INIT_PROPERTY_IND_IGNORE_CACHED_EXEC_CONTEXT))) {
            mapPathWorkspaceDirDefaultExecContextImpl.remove(pathWorkspaceDir);
        }
        if ((defaultExecContextImpl = mapPathWorkspaceDirDefaultExecContextImpl.get(pathWorkspaceDir)) == null) {
            defaultExecContextImpl = new DefaultExecContextImpl(pathWorkspaceDir, propertiesInit);
            mapPathWorkspaceDirDefaultExecContextImpl.put(pathWorkspaceDir, defaultExecContextImpl);
        }
        return defaultExecContextImpl;
    }

    public String getWorkspaceDirInitProperty() {
        return INIT_PROPERTY_WORKSPACE_DIR;
    }

    private class DefaultExecContextImpl
    implements ExecContext,
    WorkspaceExecContext,
    ToolLifeCycleExecContext {
        private boolean indWorkspaceDirInit;
        private Path pathWorkspaceDir;
        private Path pathMetadataDir;
        private Path pathPropertiesFile;
        private Model model;
        private Map<Class<? extends ExecContextPlugin>, ExecContextPlugin> mapExecContextPluginInstantiated;
        private Map<Class<? extends ExecContextPlugin>, ExecContextPlugin> mapExecContextPluginTransientInstantiated;
        private Properties propertiesInit;
        private Properties properties;
        private Map<String, Object> mapTransientData;
        private Properties propertiesTool;

        private DefaultExecContextImpl(Path pathWorkspaceDir, Properties propertiesInit) {
            this.propertiesInit = propertiesInit;
            this.pathWorkspaceDir = pathWorkspaceDir;
            this.pathMetadataDir = this.pathWorkspaceDir.resolve(DefaultExecContextFactory.DRAGOM_METADATA_DIR);
            this.pathPropertiesFile = this.pathMetadataDir.resolve(DefaultExecContextFactory.PROPERTIES_FILE);
            this.model = ModelFactoryHolder.getModelFactory().getModel(propertiesInit);
            this.properties = new SortedProperties();
            if (this.pathPropertiesFile.toFile().isFile()) {
                try (FileInputStream inputStreamProperties = new FileInputStream(this.pathPropertiesFile.toFile());){
                    this.properties.load(inputStreamProperties);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                this.indWorkspaceDirInit = true;
            }
            this.mapTransientData = new HashMap<String, Object>();
            this.mapExecContextPluginInstantiated = new HashMap<Class<? extends ExecContextPlugin>, ExecContextPlugin>();
            this.mapExecContextPluginTransientInstantiated = new HashMap<Class<? extends ExecContextPlugin>, ExecContextPlugin>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initWorkspaceDir() {
            if (!this.indWorkspaceDirInit) {
                DefaultExecContextImpl defaultExecContextImpl = this;
                synchronized (defaultExecContextImpl) {
                    if (!this.indWorkspaceDirInit) {
                        if (!this.pathMetadataDir.toFile().isDirectory() && !this.pathMetadataDir.toFile().mkdirs()) {
                            throw new RuntimeException("Directory " + this.pathMetadataDir + " could not be created.");
                        }
                        this.saveProperties();
                        this.indWorkspaceDirInit = true;
                        this.getExecContextPlugin(UserInteractionCallbackPlugin.class).provideInfo(MessageFormat.format(resourceBundle.getString(DefaultExecContextFactory.MSG_PATTERN_KEY_WORKSPACE_DIR_INIT), this.pathWorkspaceDir));
                    }
                }
            }
        }

        public Model getModel() {
            return this.model;
        }

        public <ExecContextPluginInterface extends ExecContextPlugin> ExecContextPluginInterface getExecContextPlugin(Class<ExecContextPluginInterface> classExecContextPluginInterface) {
            ExecContextPlugin execContextPlugin;
            if (this.mapExecContextPluginInstantiated.containsKey(classExecContextPluginInterface)) {
                execContextPlugin = this.mapExecContextPluginInstantiated.get(classExecContextPluginInterface);
            } else if (this.mapExecContextPluginTransientInstantiated.containsKey(classExecContextPluginInterface)) {
                execContextPlugin = this.mapExecContextPluginTransientInstantiated.get(classExecContextPluginInterface);
            } else {
                ExecContextPluginFactory<ExecContextPluginInterface> execContextPluginFactory = ExecContextPluginFactoryHolder.getExecContextPluginFactory(classExecContextPluginInterface);
                execContextPlugin = execContextPluginFactory.getExecContextPlugin((ExecContext)this);
                if (execContextPlugin instanceof ToolLifeCycleExecContextPlugin) {
                    ToolLifeCycleExecContextPlugin toolLifeCycleExecContextPlugin = (ToolLifeCycleExecContextPlugin)execContextPlugin;
                    if (toolLifeCycleExecContextPlugin.isTransient()) {
                        this.mapExecContextPluginTransientInstantiated.put(classExecContextPluginInterface, execContextPlugin);
                    } else {
                        this.mapExecContextPluginInstantiated.put(classExecContextPluginInterface, execContextPlugin);
                    }
                } else {
                    this.mapExecContextPluginInstantiated.put(classExecContextPluginInterface, execContextPlugin);
                }
            }
            return (ExecContextPluginInterface)((ExecContextPlugin)execContextPlugin.getClass().asSubclass(classExecContextPluginInterface).cast(execContextPlugin));
        }

        public Set<String> getSetInitProperty() {
            HashSet<String> setInitProperty = new HashSet<String>();
            for (Object key : this.propertiesInit.keySet()) {
                setInitProperty.add((String)key);
            }
            return setInitProperty;
        }

        public String getInitProperty(String name) {
            return this.propertiesInit.getProperty(name);
        }

        public String getProperty(String name) {
            return this.properties.getProperty(name);
        }

        public void setProperty(String name, String value) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.setProperty(name, value);
            }
            this.initWorkspaceDir();
            this.saveProperties();
        }

        public Set<String> getSetProperty(String prefix) {
            Set<String> setProperty = this.properties.stringPropertyNames();
            if (prefix != null) {
                Iterator<String> iteratorProperty = setProperty.iterator();
                while (iteratorProperty.hasNext()) {
                    if (iteratorProperty.next().startsWith(prefix)) continue;
                    iteratorProperty.remove();
                }
            }
            return setProperty;
        }

        public void removeProperty(String name) {
            if (this.properties.remove(name) != null) {
                this.saveProperties();
            }
        }

        public void removeProperties(String prefix) {
            Set<String> setProperty = this.getSetProperty(prefix);
            if (!setProperty.isEmpty()) {
                for (String property : setProperty) {
                    this.properties.remove(property);
                }
                this.saveProperties();
            }
        }

        private void saveProperties() {
            try (FileOutputStream outputStreamProperties = new FileOutputStream(this.pathPropertiesFile.toFile());){
                this.properties.store(outputStreamProperties, null);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public Object getTransientData(String name) {
            return this.mapTransientData.get(name);
        }

        public void setTransientData(String name, Object value) {
            this.mapTransientData.put(name, value);
        }

        public String getName() {
            return this.pathWorkspaceDir.toString();
        }

        public void release() {
            mapPathWorkspaceDirDefaultExecContextImpl.remove(this.pathWorkspaceDir);
        }

        public Path getPathWorkspaceDir() {
            this.initWorkspaceDir();
            return this.pathWorkspaceDir;
        }

        public Path getPathMetadataDir() {
            this.initWorkspaceDir();
            return this.pathMetadataDir;
        }

        public WorkspaceExecContext.WorkspaceFormatVersion getWorkspaceFormatVersion() {
            String workspaceFormat = this.getProperty(DefaultExecContextFactory.EXEC_CONTEXT_PROPERTY_WORKSPACE_FORMAT);
            if (workspaceFormat == null) {
                return null;
            }
            WorkspaceExecContext.WorkspaceFormatVersion workspaceFormatVersion = new WorkspaceExecContext.WorkspaceFormatVersion(workspaceFormat, this.getProperty(DefaultExecContextFactory.EXEC_CONTEXT_PROPERTY_WORKSPACE_VERSION));
            return workspaceFormatVersion;
        }

        public void setWorkspaceFormatVersion(WorkspaceExecContext.WorkspaceFormatVersion workspaceFormatVersion) {
            this.setProperty(DefaultExecContextFactory.EXEC_CONTEXT_PROPERTY_WORKSPACE_FORMAT, workspaceFormatVersion.format);
            this.setProperty(DefaultExecContextFactory.EXEC_CONTEXT_PROPERTY_WORKSPACE_VERSION, workspaceFormatVersion.version);
        }

        public void startTool(Properties propertiesTool) {
            if (!this.mapExecContextPluginTransientInstantiated.isEmpty()) {
                for (ExecContextPlugin execContextPlugin : this.mapExecContextPluginTransientInstantiated.values()) {
                    if (!(execContextPlugin instanceof ToolLifeCycleExecContextPlugin)) continue;
                    ((ToolLifeCycleExecContextPlugin)execContextPlugin).endTool();
                }
                this.mapExecContextPluginTransientInstantiated.clear();
            }
            this.propertiesTool = propertiesTool;
            for (ExecContextPlugin execContextPlugin : this.mapExecContextPluginInstantiated.values()) {
                if (!(execContextPlugin instanceof ToolLifeCycleExecContextPlugin)) continue;
                ((ToolLifeCycleExecContextPlugin)execContextPlugin).startTool();
            }
            this.mapTransientData.clear();
        }

        public void endTool() {
            for (ExecContextPlugin execContextPlugin : this.mapExecContextPluginInstantiated.values()) {
                if (!(execContextPlugin instanceof ToolLifeCycleExecContextPlugin)) continue;
                ((ToolLifeCycleExecContextPlugin)execContextPlugin).endTool();
            }
            for (ExecContextPlugin execContextPlugin : this.mapExecContextPluginTransientInstantiated.values()) {
                if (!(execContextPlugin instanceof ToolLifeCycleExecContextPlugin)) continue;
                ((ToolLifeCycleExecContextPlugin)execContextPlugin).endTool();
            }
            this.mapExecContextPluginTransientInstantiated.clear();
            this.mapTransientData.clear();
            this.propertiesTool = null;
        }

        public Set<String> getSetToolProperty() {
            if (this.propertiesTool == null) {
                return Collections.emptySet();
            }
            HashSet<String> setToolProperty = new HashSet<String>();
            for (Object key : this.propertiesTool.keySet()) {
                setToolProperty.add((String)key);
            }
            return setToolProperty;
        }

        public String getToolProperty(String name) {
            if (this.propertiesTool != null) {
                return this.propertiesTool.getProperty(name);
            }
            return null;
        }
    }
}

