/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.execcontext.support;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.ToolLifeCycleExecContext;
import org.azyva.dragom.execcontext.plugin.ExecContextPlugin;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class ExecContextHolder {
    private static final String MSG_PATTERN_KEY_EXEC_CONTEXT_LOCKED = "EXEC_CONTEXT_LOCKED";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ExecContextHolder.class.getName() + "ResourceBundle");
    private static ThreadLocal<ExecContext> threadLocalExecContext = new ThreadLocal();
    private static Set<ExecContext> setExecContextLocked = new HashSet<ExecContext>();

    public static void setAndStartTool(ExecContext execContext, Properties propertiesInit) {
        if (setExecContextLocked.contains(execContext)) {
            throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_EXEC_CONTEXT_LOCKED), execContext.getName()));
        }
        threadLocalExecContext.set(execContext);
        setExecContextLocked.add(execContext);
        if (execContext instanceof ToolLifeCycleExecContext) {
            ToolLifeCycleExecContext toolLifeCycleExecContext = (ToolLifeCycleExecContext)execContext;
            toolLifeCycleExecContext.startTool(propertiesInit);
        }
    }

    public static ExecContext setDummy(Model model) {
        DummyExecContext execContext = new DummyExecContext(model);
        ExecContextHolder.setAndStartTool(execContext, null);
        return execContext;
    }

    public static void setSecondaryThread(ExecContext execContext) {
        if (!setExecContextLocked.contains(execContext)) {
            throw new RuntimeException("ExecContext is not currenly being used.");
        }
        threadLocalExecContext.set(execContext);
    }

    public static void endToolAndUnset() {
        ExecContext execContext = ExecContextHolder.get();
        if (execContext != null) {
            if (execContext instanceof ToolLifeCycleExecContext) {
                ToolLifeCycleExecContext toolLifeCycleExecContext = (ToolLifeCycleExecContext)execContext;
                toolLifeCycleExecContext.endTool();
            }
            setExecContextLocked.remove(execContext);
            threadLocalExecContext.set(null);
        }
    }

    public static void forceUnset(ExecContext execContext) {
        if (execContext instanceof ToolLifeCycleExecContext) {
            ToolLifeCycleExecContext toolLifeCycleExecContext = (ToolLifeCycleExecContext)execContext;
            toolLifeCycleExecContext.endTool();
        }
        setExecContextLocked.remove(execContext);
    }

    public static ExecContext get() {
        return threadLocalExecContext.get();
    }

    private static class DummyExecContext
    implements ExecContext {
        private Model model;

        public DummyExecContext(Model model) {
            this.model = model;
        }

        public Model getModel() {
            return this.model;
        }

        public <ExecContextPluginInterface extends ExecContextPlugin> ExecContextPluginInterface getExecContextPlugin(Class<ExecContextPluginInterface> classExecContextPluginInterface) {
            return null;
        }

        public Set<String> getSetInitProperty() {
            return Collections.emptySet();
        }

        public String getInitProperty(String name) {
            return null;
        }

        public String getProperty(String name) {
            return null;
        }

        public void setProperty(String name, String value) {
        }

        public Set<String> getSetProperty(String prefix) {
            return Collections.emptySet();
        }

        public void removeProperty(String name) {
        }

        public void removeProperties(String prefix) {
        }

        public Object getTransientData(String name) {
            return null;
        }

        public void setTransientData(String name, Object value) {
        }

        public String getName() {
            return "Dummy ExecContext";
        }

        public void release() {
        }
    }
}

