/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.jenkins.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.azyva.dragom.jenkins.JenkinsClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultJenkinsClientImpl
implements JenkinsClient {
    private String baseUrl;
    private String user;
    private String password;
    private String basicAuthBase64;

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
        this.basicAuthBase64 = null;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.basicAuthBase64 = null;
    }

    @Override
    public boolean validateCredentials() {
        try {
            this.getForText(this.baseUrl + "/api/xml");
            return true;
        }
        catch (JenkinsClient.HttpStatusException hse) {
            if (hse.getStatusCode() == 401) {
                return false;
            }
            throw hse;
        }
    }

    @Override
    public JenkinsClient.ItemType getItemType(String item) {
        try {
            Document document = this.getForXml(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(item) + "/api/xml");
            return document.getDocumentElement().getNodeName().equals("folder") ? JenkinsClient.ItemType.FOLDER : JenkinsClient.ItemType.NOT_FOLDER;
        }
        catch (JenkinsClient.HttpStatusException hse) {
            if (hse.getStatusCode() == 404) {
                return null;
            }
            throw hse;
        }
    }

    @Override
    public boolean deleteItem(String item) {
        try {
            this.post(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(item) + "/doDelete");
            return true;
        }
        catch (JenkinsClient.HttpStatusException hse) {
            int statusCode = hse.getStatusCode();
            if (statusCode == 302) {
                return true;
            }
            if (statusCode == 404) {
                return false;
            }
            throw hse;
        }
    }

    @Override
    public void createUpdateJobFromTemplate(String template, String job, Map<String, String> mapTemplateParam) {
        try {
            URL url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(template) + "/instantiate?job=" + URLEncoder.encode(job, "UTF-8"));
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestProperty("Content-Type", "text/xml");
            httpUrlConnection.connect();
            OutputStream outputStream = httpUrlConnection.getOutputStream();
            outputStream.write("<values>".getBytes("US-ASCII"));
            for (Map.Entry<String, String> mapEntry : mapTemplateParam.entrySet()) {
                byte[] arrayByteKey = mapEntry.getKey().getBytes("US-ASCII");
                outputStream.write(60);
                outputStream.write(arrayByteKey);
                outputStream.write(62);
                outputStream.write(mapEntry.getValue().getBytes("US-ASCII"));
                outputStream.write("</".getBytes("US-ASCII"));
                outputStream.write(arrayByteKey);
                outputStream.write(62);
            }
            outputStream.write("</values>".getBytes("US-ASCII"));
            outputStream.close();
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode != 200) {
                throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void createJob(String job, Reader readerConfig) {
        try {
            int nbCharConfigRead;
            String jobName;
            String folderName;
            int indexJobName = job.lastIndexOf(47);
            if (indexJobName == -1) {
                folderName = "";
                jobName = job;
            } else {
                folderName = job.substring(0, indexJobName);
                jobName = job.substring(indexJobName + 1);
            }
            URL url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(folderName) + "/createItem?name=" + URLEncoder.encode(jobName, "UTF-8"));
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestProperty("Content-Type", "application/xml");
            httpUrlConnection.connect();
            OutputStream outputStream = httpUrlConnection.getOutputStream();
            char[] arrayCharConfig = new char[1024];
            while ((nbCharConfigRead = readerConfig.read(arrayCharConfig)) != -1) {
                outputStream.write(new String(arrayCharConfig, 0, nbCharConfigRead).getBytes("UTF-8"));
            }
            outputStream.close();
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode != 200) {
                throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void updateJob(String job, Reader readerConfig) {
        try {
            int nbCharConfigRead;
            URL url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(job) + "/config.xml");
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestProperty("Content-Type", "application/xml");
            httpUrlConnection.connect();
            OutputStream outputStream = httpUrlConnection.getOutputStream();
            char[] arrayCharConfig = new char[1024];
            while ((nbCharConfigRead = readerConfig.read(arrayCharConfig)) != -1) {
                outputStream.write(new String(arrayCharConfig, 0, nbCharConfigRead).getBytes("UTF-8"));
            }
            outputStream.close();
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode != 200) {
                throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void createUpdateJob(String job, Reader readerConfig) {
        JenkinsClient.ItemType itemType = this.getItemType(job);
        if (itemType != null) {
            if (itemType == JenkinsClient.ItemType.FOLDER) {
                throw new RuntimeException("Item " + job + " exists and is a folder. It cannot be updated as a job.");
            }
            this.updateJob(job, readerConfig);
        } else {
            this.createJob(job, readerConfig);
        }
    }

    @Override
    public JenkinsClient.Build build(String job, Map<String, String> mapBuildParam) {
        StringBuilder stringBuilderParams = null;
        try {
            URL url;
            boolean indParams;
            boolean bl = indParams = mapBuildParam != null && !mapBuildParam.isEmpty();
            if (indParams) {
                url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(job) + "/buildWithParameters");
                stringBuilderParams = new StringBuilder();
                for (Map.Entry<String, String> mapEntry : mapBuildParam.entrySet()) {
                    stringBuilderParams.append(mapEntry.getKey());
                    stringBuilderParams.append('=');
                    stringBuilderParams.append(URLEncoder.encode(mapEntry.getValue(), "UTF-8"));
                    stringBuilderParams.append('&');
                }
                stringBuilderParams.setLength(stringBuilderParams.length() - 1);
            } else {
                url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(job) + "/build");
            }
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            if (indParams) {
                httpUrlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                httpUrlConnection.setDoOutput(true);
            }
            httpUrlConnection.connect();
            if (indParams) {
                OutputStream outputStream = httpUrlConnection.getOutputStream();
                outputStream.write(stringBuilderParams.toString().getBytes());
                outputStream.close();
            }
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode == 200 || responseCode == 201) {
                return new DefaultBuildImpl(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(job), job, httpUrlConnection.getHeaderField("Location"));
            }
            throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean isFolderEmpty(String folder) {
        Document document = this.getForXml(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(folder) + "/api/xml");
        return document.getElementsByTagName("job").getLength() != 0;
    }

    @Override
    public boolean createSimpleFolder(String folder) {
        JenkinsClient.ItemType itemType = this.getItemType(folder);
        if (itemType != null) {
            if (itemType == JenkinsClient.ItemType.FOLDER) {
                return false;
            }
            throw new RuntimeException("Item " + folder + " already exists but is not a folder.");
        }
        try {
            String folderName;
            String parentFolderName;
            int indexFolderName = folder.lastIndexOf(47);
            if (indexFolderName == -1) {
                parentFolderName = "";
                folderName = folder;
            } else {
                parentFolderName = folder.substring(0, indexFolderName);
                folderName = folder.substring(indexFolderName + 1);
            }
            URL url = new URL(this.baseUrl + DefaultJenkinsClientImpl.convertItemToPath(parentFolderName) + "/createItem?name=" + URLEncoder.encode(folderName, "UTF-8"));
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.setDoOutput(true);
            httpUrlConnection.setRequestProperty("Content-Type", "application/xml");
            httpUrlConnection.connect();
            OutputStream outputStream = httpUrlConnection.getOutputStream();
            outputStream.write("<com.cloudbees.hudson.plugins.folder.Folder plugin=\"cloudbees-folder\"/>".getBytes("UTF-8"));
            outputStream.close();
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode != 200) {
                throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
            return true;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setBasicAuthBase64(HttpURLConnection httpUrlConnection) {
        if (this.basicAuthBase64 == null && this.user != null) {
            try {
                this.basicAuthBase64 = DatatypeConverter.printBase64Binary((byte[])(this.user + ':' + this.password).getBytes("US_ASCII"));
            }
            catch (UnsupportedEncodingException usee) {
                throw new RuntimeException(usee);
            }
        }
        if (this.basicAuthBase64 != null) {
            httpUrlConnection.setRequestProperty("Authorization", "Basic " + this.basicAuthBase64);
        }
    }

    private Document getForXml(String stringUrl) {
        try {
            URL url = new URL(stringUrl);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.connect();
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode == 200) {
                InputStream inputStream = httpUrlConnection.getInputStream();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                inputStream.close();
                return document;
            }
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            throw new JenkinsClient.HttpStatusException("GET " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private String getForText(String stringUrl) {
        try {
            URL url = new URL(stringUrl);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("GET");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.connect();
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode == 200) {
                int nbCharOutputRead;
                StringBuilder stringBuilderOutput = new StringBuilder();
                InputStreamReader reader = new InputStreamReader(httpUrlConnection.getInputStream(), "UTF-8");
                char[] arrayCharOutput = new char[1024];
                while ((nbCharOutputRead = reader.read(arrayCharOutput)) != -1) {
                    stringBuilderOutput.append(arrayCharOutput, 0, nbCharOutputRead);
                }
                ((Reader)reader).close();
                return stringBuilderOutput.toString();
            }
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            throw new JenkinsClient.HttpStatusException("GET " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void post(String stringUrl) {
        try {
            URL url = new URL(stringUrl);
            HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
            this.setBasicAuthBase64(httpUrlConnection);
            httpUrlConnection.setRequestMethod("POST");
            httpUrlConnection.setInstanceFollowRedirects(false);
            httpUrlConnection.connect();
            int responseCode = httpUrlConnection.getResponseCode();
            DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
            if (responseCode != 200) {
                throw new JenkinsClient.HttpStatusException("POST " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static String convertItemToPath(String item) {
        return "/job/" + item.replaceAll("/", "/job/");
    }

    private static void flushInputErrorStreams(HttpURLConnection httpUrlConnection) {
        try {
            InputStream inputStream;
            int responseCode = httpUrlConnection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300 && (inputStream = httpUrlConnection.getInputStream()) != null) {
                inputStream.skip(Integer.MAX_VALUE);
                inputStream.close();
            }
            if (httpUrlConnection.getResponseCode() != 200 && (inputStream = httpUrlConnection.getErrorStream()) != null) {
                inputStream.skip(Integer.MAX_VALUE);
                inputStream.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] args) {
    }

    public class DefaultBuildImpl
    implements JenkinsClient.Build {
        JenkinsClient.BuildState buildStatePrevious;
        String jobUrl;
        String queueItemUrl;
        String buildUrl;
        String job;
        int buildNumber;
        String buildName;
        int nextConsoleStart;

        private DefaultBuildImpl(String jobUrl, String job, String queueItemUrl) {
            this.jobUrl = jobUrl;
            this.job = job;
            this.queueItemUrl = queueItemUrl;
            this.buildStatePrevious = JenkinsClient.BuildState.QUEUED;
        }

        @Override
        public JenkinsClient.BuildState getBuildState() {
            NodeList nodeList;
            Document document;
            if (this.buildStatePrevious == JenkinsClient.BuildState.QUEUED) {
                document = DefaultJenkinsClientImpl.this.getForXml(this.queueItemUrl + "api/xml");
                nodeList = document.getElementsByTagName("cancelled");
                if (nodeList.getLength() == 0) {
                    return JenkinsClient.BuildState.QUEUED;
                }
                String cancelled = nodeList.item(0).getTextContent();
                if (cancelled.equals("true")) {
                    this.buildStatePrevious = JenkinsClient.BuildState.CANCELLED;
                    return JenkinsClient.BuildState.CANCELLED;
                }
                nodeList = document.getElementsByTagName("executable");
                if (nodeList.getLength() != 0) {
                    this.buildStatePrevious = JenkinsClient.BuildState.RUNNING;
                    this.buildNumber = Integer.parseInt(((Element)nodeList.item(0)).getElementsByTagName("number").item(0).getTextContent());
                    this.buildUrl = ((Element)nodeList.item(0)).getElementsByTagName("url").item(0).getTextContent();
                } else {
                    return JenkinsClient.BuildState.QUEUED;
                }
            }
            if (this.buildStatePrevious == JenkinsClient.BuildState.RUNNING) {
                document = DefaultJenkinsClientImpl.this.getForXml(this.buildUrl + "api/xml");
                this.buildName = document.getElementsByTagName("displayName").item(0).getTextContent();
                nodeList = document.getElementsByTagName("result");
                if (nodeList.getLength() == 0) {
                    return JenkinsClient.BuildState.RUNNING;
                }
                String result = nodeList.item(0).getTextContent();
                if (result.equals("ABORTED")) {
                    this.buildStatePrevious = JenkinsClient.BuildState.ABORTED;
                } else if (result.equals("FAILURE")) {
                    this.buildStatePrevious = JenkinsClient.BuildState.FAILED;
                } else if (result.equals("UNSTABLE")) {
                    this.buildStatePrevious = JenkinsClient.BuildState.UNSTABLE;
                } else if (result.equals("SUCCESS")) {
                    this.buildStatePrevious = JenkinsClient.BuildState.SUCCESS;
                }
                return this.buildStatePrevious;
            }
            return this.buildStatePrevious;
        }

        @Override
        public String getJobUrl() {
            return this.jobUrl;
        }

        @Override
        public String getJob() {
            return this.job;
        }

        @Override
        public String getBuildUrl() {
            return this.buildUrl;
        }

        @Override
        public int getBuildNumber() {
            return this.buildNumber;
        }

        @Override
        public String getBuildName() {
            return this.buildName;
        }

        @Override
        public boolean cancel() {
            JenkinsClient.BuildState buildState = this.getBuildState();
            if (buildState == JenkinsClient.BuildState.QUEUED) {
                int indexSlash = this.queueItemUrl.lastIndexOf(47, this.queueItemUrl.length() - 2);
                DefaultJenkinsClientImpl.this.post(this.queueItemUrl.substring(0, indexSlash - 4) + "cancelItem?id=" + this.queueItemUrl.substring(indexSlash + 1, this.queueItemUrl.length() - 1));
                return this.getBuildState() == JenkinsClient.BuildState.CANCELLED;
            }
            if (buildState == JenkinsClient.BuildState.RUNNING) {
                DefaultJenkinsClientImpl.this.post(this.buildUrl + "stop");
                return this.getBuildState() == JenkinsClient.BuildState.ABORTED;
            }
            return false;
        }

        @Override
        public String getNextConsoleChunk() {
            if (!this.buildStatePrevious.isOutOfQueue() && !this.getBuildState().isOutOfQueue()) {
                return null;
            }
            if (this.nextConsoleStart == -1) {
                return null;
            }
            try {
                URL url = new URL(this.buildUrl + "logText/progressiveText?start=" + this.nextConsoleStart);
                HttpURLConnection httpUrlConnection = (HttpURLConnection)url.openConnection();
                DefaultJenkinsClientImpl.this.setBasicAuthBase64(httpUrlConnection);
                httpUrlConnection.setRequestMethod("GET");
                httpUrlConnection.setInstanceFollowRedirects(false);
                httpUrlConnection.connect();
                int responseCode = httpUrlConnection.getResponseCode();
                if (responseCode == 200) {
                    int nbCharOutputRead;
                    StringBuilder stringBuilderOutput = new StringBuilder();
                    InputStreamReader reader = new InputStreamReader(httpUrlConnection.getInputStream(), "UTF-8");
                    char[] arrayCharOutput = new char[1024];
                    while ((nbCharOutputRead = reader.read(arrayCharOutput)) != -1) {
                        stringBuilderOutput.append(arrayCharOutput, 0, nbCharOutputRead);
                    }
                    ((Reader)reader).close();
                    this.nextConsoleStart = httpUrlConnection.getHeaderField("X-More-Data").equals("false") ? -1 : Integer.parseInt(httpUrlConnection.getHeaderField("X-Text-Size"));
                    return stringBuilderOutput.toString();
                }
                DefaultJenkinsClientImpl.flushInputErrorStreams(httpUrlConnection);
                throw new JenkinsClient.HttpStatusException("GET " + url.toString() + " returned " + responseCode + " - " + httpUrlConnection.getResponseMessage() + '.', responseCode);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public String getFullConsole() {
            if (!this.buildStatePrevious.isOutOfQueue() && !this.getBuildState().isOutOfQueue()) {
                return null;
            }
            return DefaultJenkinsClientImpl.this.getForText(this.buildUrl + "consoleText");
        }
    }
}

