/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.BuildReferenceGraph;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.plugin.RemoteBuilderPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.util.Util;

public class BuildRemote
extends RootModuleVersionJobAbstractImpl {
    public static final String RUNTIME_PROPERTY_IND_BUILD_REFERENCE_PATH = "IND_BUILD_REFERENCE_PATH";
    public static final String RUNTIME_PROPERTY_BUILD_MONITORING_CYCLE_DELAY = "BUILD_MONITORING_CYCLE_DELAY";
    public static final String RUNTIME_PROPERTY_BUILD_LOG_DIR = "BUILD_LOG_DIR";
    public static final String RUNTIME_PROPERTY_IND_INCLUDE_NODE_PATH_IN_BUILD_LOG_FILE_NAMES = "INCLUDE_NODE_PATH_IN_BUILD_LOG_FILE_NAMES";
    public static final String RUNTIME_PROPERTY_IND_INCLUDE_VERSION_IN_BUILD_LOG_FILE_NAMES = "INCLUDE_VERSION_IN_BUILD_LOG_FILE_NAMES";
    public static final String BUILD_LOG_FILE_NAMES_SUFFIX = ".log";
    private static final String MSG_PATTERN_KEY_BUILD_SUBMITTED = "BUILD_SUBMITTED";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_DOES_NOT_NEED_BUILDING = "MODULE_VERSION_DOES_NOT_NEED_BUILDING";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_CANNOT_BUILD_REMOTELY = "MODULE_VERSION_CANNOT_BUILD_REMOTELY";
    private static final String MSG_PATTERN_KEY_BUILD_CHANGED_STATE = "BUILD_CHANGED_STATE";
    private static final String MSG_PATTERN_KEY_BUILD_SUCCEEDED = "BUILD_SUCCEEDED";
    private static final String MSG_PATTERN_KEY_BUILD_FAILED = "BUILD_FAILED";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(BuildRemote.class.getName() + "ResourceBundle");

    public BuildRemote(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        this.setupReferencePathMatcherForProjectCode();
    }

    @Override
    public void performJob() {
        BuildReferenceGraph buildReferenceGraph = new BuildReferenceGraph(null, this.listModuleVersionRoot);
        buildReferenceGraph.setReferencePathMatcherProvided(this.getReferencePathMatcher());
        buildReferenceGraph.performJob();
        ReferenceGraph referenceGraph = buildReferenceGraph.getReferenceGraph();
        ExecContext execContext = ExecContextHolder.get();
        final RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        final UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        final Model model = execContext.getModel();
        int buildMonitoringCycleDelay = Integer.parseInt(runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_BUILD_MONITORING_CYCLE_DELAY));
        boolean indStillBuilding = true;
        final LinkedHashMap mapRemoteBuildWrapper = new LinkedHashMap();
        do {
            referenceGraph.traverseReferenceGraph(null, true, ReferenceGraph.ReentryMode.NO_REENTRY, new ReferenceGraph.Visitor(){

                public ReferenceGraph.VisitControl visit(ReferenceGraph referenceGraph, ReferencePath referencePath, EnumSet<ReferenceGraph.VisitAction> enumSetVisitAction) {
                    if (!enumSetVisitAction.contains(ReferenceGraph.VisitAction.VISIT)) {
                        return ReferenceGraph.VisitControl.CONTINUE;
                    }
                    ModuleVersion moduleVersion = referencePath.getLeafModuleVersion();
                    Module module = model.getModule(moduleVersion.getNodePath());
                    if (mapRemoteBuildWrapper.containsKey(moduleVersion)) {
                        return ReferenceGraph.VisitControl.CONTINUE;
                    }
                    boolean indBuildReferencePath = Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)module, BuildRemote.RUNTIME_PROPERTY_IND_BUILD_REFERENCE_PATH));
                    if (enumSetVisitAction.contains(ReferenceGraph.VisitAction.MATCHED) || indBuildReferencePath) {
                        boolean indReferenceBuildNotCompletedAndSuccess = false;
                        List listReference = referenceGraph.getListReference(moduleVersion);
                        for (Reference reference : listReference) {
                            ModuleVersion moduleVersionReference = reference.getModuleVersion();
                            RemoteBuildWrapper remoteBuildWrapperReference = (RemoteBuildWrapper)mapRemoteBuildWrapper.get(moduleVersionReference);
                            if (remoteBuildWrapperReference == null) {
                                if (mapRemoteBuildWrapper.containsKey(moduleVersionReference)) continue;
                                indReferenceBuildNotCompletedAndSuccess = true;
                                break;
                            }
                            if (remoteBuildWrapperReference.getRemoteBuildStatus() != RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus.COMPLETED && remoteBuildWrapperReference.getRemoteBuildStatus() != RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus.CANNOT_BUILD_REMOTELY) {
                                indReferenceBuildNotCompletedAndSuccess = true;
                                break;
                            }
                            if (remoteBuildWrapperReference.getRemoteBuildStatus() != RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus.CANNOT_BUILD_REMOTELY && remoteBuildWrapperReference.remoteBuildHandle.isSuccess()) continue;
                            indReferenceBuildNotCompletedAndSuccess = true;
                            break;
                        }
                        if (!indReferenceBuildNotCompletedAndSuccess) {
                            RemoteBuilderPlugin remoteBuilderPlugin = (RemoteBuilderPlugin)module.getNodePlugin(RemoteBuilderPlugin.class, null);
                            if (remoteBuilderPlugin.isBuildNeeded(moduleVersion.getVersion())) {
                                RemoteBuildWrapper remoteBuildWrapper = new RemoteBuildWrapper();
                                remoteBuildWrapper.remoteBuildHandle = remoteBuilderPlugin.submitBuild(moduleVersion.getVersion());
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(BuildRemote.MSG_PATTERN_KEY_BUILD_SUBMITTED), moduleVersion, remoteBuildWrapper.remoteBuildHandle.getLocation()));
                                mapRemoteBuildWrapper.put(moduleVersion, remoteBuildWrapper);
                            } else {
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(BuildRemote.MSG_PATTERN_KEY_MODULE_VERSION_DOES_NOT_NEED_BUILDING), moduleVersion));
                                mapRemoteBuildWrapper.put(moduleVersion, null);
                            }
                        }
                    } else {
                        mapRemoteBuildWrapper.put(moduleVersion, null);
                    }
                    return ReferenceGraph.VisitControl.CONTINUE;
                }
            });
            for (RemoteBuildWrapper remoteBuildWrapper : mapRemoteBuildWrapper.values()) {
                ModuleVersion moduleVersion = remoteBuildWrapper.remoteBuildHandle.getModuleVersion();
                Module module = model.getModule(moduleVersion.getNodePath());
                if (remoteBuildWrapper.isChangedState()) {
                    switch (remoteBuildWrapper.getRemoteBuildStatus()) {
                        case CANNOT_BUILD_REMOTELY: {
                            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_CANNOT_BUILD_REMOTELY), moduleVersion, remoteBuildWrapper.remoteBuildHandle.getCannotBuildRemotelyReason()));
                            break;
                        }
                        case QUEUED: 
                        case RUNNING: {
                            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_BUILD_CHANGED_STATE), moduleVersion, remoteBuildWrapper.remoteBuildHandle.getLocation(), remoteBuildWrapper.getRemoteBuildStatus()));
                            break;
                        }
                        case COMPLETED: {
                            File fileBuildLog;
                            Path pathBuildLogFile;
                            String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_BUILD_LOG_DIR);
                            Path pathBuildLogDir = runtimeProperty == null ? ((WorkspaceExecContext)execContext).getPathWorkspaceDir() : Paths.get(runtimeProperty, new String[0]);
                            boolean indIncludeNodePathInBuildLogFileNames = Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_IND_INCLUDE_NODE_PATH_IN_BUILD_LOG_FILE_NAMES));
                            boolean indIncludeVersionInBuildLogFileNames = Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_IND_INCLUDE_VERSION_IN_BUILD_LOG_FILE_NAMES));
                            String buildLogFileName = indIncludeNodePathInBuildLogFileNames ? moduleVersion.getNodePath().getPropertyNameSegment() : moduleVersion.getNodePath().getModuleName();
                            if (indIncludeVersionInBuildLogFileNames) {
                                buildLogFileName = buildLogFileName + '-' + moduleVersion.getVersion().getVersion();
                            }
                            int i = 0;
                            while (true) {
                                pathBuildLogFile = pathBuildLogDir.resolve(buildLogFileName + (i == 0 ? "" : " (" + i + ")") + BUILD_LOG_FILE_NAMES_SUFFIX);
                                fileBuildLog = pathBuildLogDir.toFile();
                                if (!fileBuildLog.exists()) break;
                                ++i;
                            }
                            try {
                                BufferedWriter writerLog = new BufferedWriter(new FileWriter(fileBuildLog));
                                remoteBuildWrapper.remoteBuildHandle.getLog((Writer)writerLog);
                                ((Writer)writerLog).close();
                            }
                            catch (IOException ioe) {
                                throw new RuntimeException(ioe);
                            }
                            if (remoteBuildWrapper.remoteBuildHandle.isSuccess()) {
                                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_BUILD_SUCCEEDED), moduleVersion, remoteBuildWrapper.remoteBuildHandle.getLocation(), pathBuildLogFile));
                                break;
                            }
                            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_BUILD_FAILED), moduleVersion, remoteBuildWrapper.remoteBuildHandle.getLocation(), pathBuildLogFile));
                        }
                    }
                    indStillBuilding = true;
                } else if (remoteBuildWrapper.getRemoteBuildStatus() == RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus.QUEUED || remoteBuildWrapper.getRemoteBuildStatus() == RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus.RUNNING) {
                    indStillBuilding = true;
                }
                remoteBuildWrapper.reset();
            }
            if (!indStillBuilding) continue;
            try {
                Thread.sleep(buildMonitoringCycleDelay);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
        } while (indStillBuilding);
    }

    private static class RemoteBuildWrapper {
        public RemoteBuilderPlugin.RemoteBuildHandle remoteBuildHandle;
        public RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus remoteBuildStatusPrevious;
        public RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus remoteBuildStatusNew;

        private RemoteBuildWrapper() {
        }

        public RemoteBuilderPlugin.RemoteBuildHandle.RemoteBuildStatus getRemoteBuildStatus() {
            if (this.remoteBuildStatusNew == null) {
                this.remoteBuildStatusNew = this.remoteBuildHandle.getRemoteBuildStatus();
            }
            return this.remoteBuildStatusNew;
        }

        public boolean isChangedState() {
            return this.getRemoteBuildStatus() != this.remoteBuildStatusPrevious;
        }

        public void reset() {
            if (this.remoteBuildStatusNew == null) {
                throw new RuntimeException("Must not get here.");
            }
            this.remoteBuildStatusPrevious = this.remoteBuildStatusNew;
        }
    }
}

