/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.ToolLifeCycleExecContext;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.plugin.WorkspaceDirUserModuleVersion;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ReferenceManagerPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeReferenceToModuleVersion
extends RootModuleVersionJobAbstractImpl {
    private static final Logger logger = LoggerFactory.getLogger(ChangeReferenceToModuleVersion.class);
    private static final String TOOL_PROPERTY_PREFIX_MAP_MODULE_VERSION_CHANGE = "MAP_MODULE_VERSION.";
    private static final String MSG_PATTERN_KEY_REFERENCE_WILL_BE_CHANGED = "REFERENCE_WILL_BE_CHANGED";
    private static final String MSG_PATTERN_KEY_MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY = "MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY";
    private static final String MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION = "CHANGE_REFERENCE_VERSION";
    private static final String MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE = "CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(ChangeReferenceToModuleVersion.class.getName() + "ResourceBundle");
    private Map<ModuleVersion, Version> mapModuleVersionChange;

    public ChangeReferenceToModuleVersion(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        this.setupReferencePathMatcherForProjectCode();
        this.initFromInitProperties();
    }

    @Override
    protected boolean visitMatchedModuleVersion(Reference reference) {
        List listReference;
        Path pathModuleWorkspace;
        ReferenceManagerPlugin referenceManagerPlugin = null;
        Version version = reference.getModuleVersion().getVersion();
        if (version.getVersionType() == VersionType.STATIC) {
            return false;
        }
        Module module = ExecContextHolder.get().getModel().getModule(reference.getModuleVersion().getNodePath());
        ExecContext execContext = ExecContextHolder.get();
        for (Map.Entry<ModuleVersion, Version> mapEntry : this.mapModuleVersionChange.entrySet()) {
            if (!mapEntry.getKey().getNodePath().equals((Object)module.getNodePath()) || !mapEntry.getValue().equals((Object)version)) continue;
            return false;
        }
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        if (!scmPlugin.isSync(pathModuleWorkspace = scmPlugin.checkoutSystem(version), ScmPlugin.IsSyncFlag.ALL_CHANGES)) {
            throw new RuntimeExceptionUserError("The directory " + pathModuleWorkspace + " is not synchronized with the SCM. Please synchronize all directories before using this task.");
        }
        if (!module.isNodePluginExists(ReferenceManagerPlugin.class, null)) {
            listReference = Collections.emptyList();
        } else {
            referenceManagerPlugin = (ReferenceManagerPlugin)module.getNodePlugin(ReferenceManagerPlugin.class, null);
            listReference = referenceManagerPlugin.getListReference(pathModuleWorkspace);
        }
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        for (Reference referenceChild : listReference) {
            if (referenceChild.getModuleVersion() == null) {
                logger.info("Reference " + referenceChild + " within ReferencePath " + this.referencePath + " does not include a source reference known to Dragom. It cannot be processed.");
                continue;
            }
            Version versionNew = this.mapModuleVersionChange.get(referenceChild.getModuleVersion());
            if (versionNew == null) continue;
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_REFERENCE_WILL_BE_CHANGED), this.referencePath, referenceChild, versionNew));
            WorkspacePlugin workspacePlugin = (WorkspacePlugin)execContext.getExecContextPlugin(WorkspacePlugin.class);
            boolean indUserWorkspaceDir = workspacePlugin.getWorkspaceDirFromPath(pathModuleWorkspace) instanceof WorkspaceDirUserModuleVersion;
            if (indUserWorkspaceDir) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_VERSION_CHECKED_OUT_IN_USER_WORKSPACE_DIRECTORY), new ModuleVersion(module.getNodePath(), version), pathModuleWorkspace));
            }
            if (!Util.handleDoYouWantToContinue("UPDATE_REFERENCE")) {
                return false;
            }
            if (referenceManagerPlugin.updateReferenceVersion(pathModuleWorkspace, referenceChild, versionNew, null)) {
                String message = MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION), this.referencePath, referenceChild, versionNew);
                HashMap<String, String> mapCommitAttr = new HashMap<String, String>();
                mapCommitAttr.put("dragom-reference-version-change", "true");
                scmPlugin.commit(pathModuleWorkspace, message, mapCommitAttr);
                userInteractionCallbackPlugin.provideInfo(message);
                this.listActionsPerformed.add(message);
                if (indUserWorkspaceDir) {
                    message = MessageFormat.format(Util.getLocalizedMsgPattern("PREVIOUS_CHANGE_COMMITTED_SCM"), pathModuleWorkspace);
                    userInteractionCallbackPlugin.provideInfo(message);
                    this.listActionsPerformed.add(message);
                    continue;
                }
                logger.info("The previous change was performed in " + pathModuleWorkspace + " and was committed to the SCM.");
                continue;
            }
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_CHANGE_REFERENCE_VERSION_NO_ARTIFACT_VERSION_CHANGE), this.referencePath, referenceChild, versionNew));
        }
        return true;
    }

    private void initFromInitProperties() {
        ExecContext execContext = ExecContextHolder.get();
        ToolLifeCycleExecContext toolLifeCycleExecContext = (ToolLifeCycleExecContext)execContext;
        this.mapModuleVersionChange = new HashMap<ModuleVersion, Version>();
        int index = 1;
        do {
            String stringMapModuleVersionChange;
            if ((stringMapModuleVersionChange = toolLifeCycleExecContext.getToolProperty(TOOL_PROPERTY_PREFIX_MAP_MODULE_VERSION_CHANGE + index)) == null) {
                index = 0;
            }
            int indexSeparatorKeyValue = stringMapModuleVersionChange.indexOf("->");
            ModuleVersion moduleVersion = new ModuleVersion(stringMapModuleVersionChange.substring(0, indexSeparatorKeyValue).trim());
            Version version = new Version(stringMapModuleVersionChange.substring(indexSeparatorKeyValue + 2).trim());
            this.mapModuleVersionChange.put(moduleVersion, version);
        } while (index++ != 0);
    }
}

