/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.job.BuildReferenceGraph;
import org.azyva.dragom.job.Report;
import org.azyva.dragom.job.ReportModule;
import org.azyva.dragom.job.ReportReference;
import org.azyva.dragom.job.ReportReferenceGraphNode;
import org.azyva.dragom.job.ReportVersion;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.VersionClassifierPlugin;
import org.azyva.dragom.reference.Reference;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.reference.ReferencePath;

public class ReferenceGraphReport
extends RootModuleVersionJobAbstractImpl {
    private OutputFormat outputFormat;
    private Path pathOutputFile;
    private Writer writerOutput;
    private boolean indIncludeReferenceGraph;
    private ReferenceGraphMode referenceGraphMode;
    private boolean indIncludeModules;
    private ModuleFilter moduleFilter;
    private boolean indIncludeMostRecentVersionInReferenceGraph;
    private boolean indIncludeMostRecentStaticVersionInScm;
    private boolean indIncludeReferencePaths;

    public ReferenceGraphReport(List<ModuleVersion> listModuleVersionRoot, OutputFormat outputFormat) {
        super(listModuleVersionRoot);
        this.outputFormat = outputFormat;
    }

    public void setOutputFilePath(Path pathOutputFile) {
        if (this.writerOutput != null) {
            throw new RuntimeException("Output Writer already set.");
        }
        this.pathOutputFile = pathOutputFile;
    }

    public void setOutputWriter(Writer writerOutput) {
        if (this.pathOutputFile != null) {
            throw new RuntimeException("Output file Path already set.");
        }
        this.writerOutput = writerOutput;
    }

    public void includeReferenceGraph(ReferenceGraphMode referenceGraphMode) {
        this.indIncludeReferenceGraph = true;
        this.referenceGraphMode = referenceGraphMode;
    }

    public void includeModules(ModuleFilter moduleFilter) {
        this.indIncludeModules = true;
        this.moduleFilter = moduleFilter;
    }

    public void includeMostRecentVersionInReferenceGraph() {
        this.indIncludeMostRecentVersionInReferenceGraph = true;
    }

    public void includeMostRecentStaticVersionInScm() {
        this.indIncludeMostRecentStaticVersionInScm = true;
        this.indIncludeMostRecentVersionInReferenceGraph = true;
    }

    public void includeReferencePaths() {
        this.indIncludeReferencePaths = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void performJob() {
        BuildReferenceGraph buildReferenceGraph = new BuildReferenceGraph(null, this.listModuleVersionRoot);
        buildReferenceGraph.setReferencePathMatcherProvided(this.getReferencePathMatcher());
        buildReferenceGraph.setIndAvoidReentry(this.indAvoidReentry);
        buildReferenceGraph.performJob();
        ReferenceGraph referenceGraph = buildReferenceGraph.getReferenceGraph();
        ReferenceGraphVisitorReport referenceGraphVisitorReport = new ReferenceGraphVisitorReport();
        referenceGraph.traverseReferenceGraph(null, false, ReferenceGraph.ReentryMode.ONLY_PARENT, (ReferenceGraph.Visitor)referenceGraphVisitorReport);
        if (this.indIncludeModules) {
            Iterator<ReportModule> iteratorReportModule = referenceGraphVisitorReport.report.listReportModule.iterator();
            while (iteratorReportModule.hasNext()) {
                ReportVersion reportVersionMax;
                VersionClassifierPlugin versionClassifierPlugin;
                ReportModule reportModule = iteratorReportModule.next();
                Module module = ExecContextHolder.get().getModel().getModule(reportModule.nodePathModule);
                if (this.moduleFilter == ModuleFilter.ONLY_MULTIPLE_VERSIONS && reportModule.listReportVersion.size() == 1 || this.moduleFilter == ModuleFilter.ONLY_MATCHED && !referenceGraphVisitorReport.setNodePathMatched.contains(reportModule.nodePathModule)) {
                    iteratorReportModule.remove();
                    continue;
                }
                if (this.indIncludeMostRecentVersionInReferenceGraph || this.indIncludeMostRecentStaticVersionInScm) {
                    versionClassifierPlugin = (VersionClassifierPlugin)module.getNodePlugin(VersionClassifierPlugin.class, null);
                    Collections.sort(reportModule.listReportVersion, new Comparator<ReportVersion>(){

                        @Override
                        public int compare(ReportVersion reportVersion1, ReportVersion reportVersion2) {
                            return -versionClassifierPlugin.compare(reportVersion1.version, reportVersion2.version);
                        }
                    });
                    reportVersionMax = reportModule.listReportVersion.get(0);
                } else {
                    versionClassifierPlugin = null;
                    reportVersionMax = null;
                }
                if (this.indIncludeMostRecentVersionInReferenceGraph) {
                    reportVersionMax.indMostRecentInReferenceGraph = true;
                }
                if (this.indIncludeMostRecentStaticVersionInScm) {
                    ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                    List listVersionStatic = scmPlugin.getListVersionStatic();
                    Collections.sort(listVersionStatic, versionClassifierPlugin);
                    if (!listVersionStatic.isEmpty()) {
                        Version versionStaticMaxScm = (Version)listVersionStatic.get(listVersionStatic.size() - 1);
                        if (reportVersionMax.version.equals((Object)versionStaticMaxScm)) {
                            reportVersionMax.indMostRecentInScm = true;
                        } else {
                            reportVersionMax = new ReportVersion();
                            reportVersionMax.version = versionStaticMaxScm;
                            reportVersionMax.indMostRecentInScm = true;
                            reportModule.listReportVersion.add(0, reportVersionMax);
                        }
                    }
                }
                if (!this.indIncludeReferencePaths) continue;
                for (final ReportVersion reportVersion : reportModule.listReportVersion) {
                    if (reportVersion.indMostRecentInScm != null && reportVersion.indMostRecentInScm.booleanValue() && (reportVersion.indMostRecentInReferenceGraph == null || !reportVersion.indMostRecentInReferenceGraph.booleanValue())) continue;
                    reportVersion.listReferencePathLiteral = new ArrayList<String>();
                    referenceGraph.visitLeafModuleVersionReferencePaths(new ModuleVersion(reportModule.nodePathModule, reportVersion.version), new ReferenceGraph.Visitor(){

                        public ReferenceGraph.VisitControl visit(ReferenceGraph referenceGraph, ReferencePath referencePath, EnumSet<ReferenceGraph.VisitAction> enumSetVisitAction) {
                            reportVersion.listReferencePathLiteral.add(referencePath.toString());
                            return ReferenceGraph.VisitControl.CONTINUE;
                        }
                    });
                }
            }
        }
        switch (this.outputFormat) {
            case XML: {
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Report.class});
                    Marshaller marshaller = jaxbContext.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    if (this.pathOutputFile != null) {
                        marshaller.marshal((Object)referenceGraphVisitorReport.report, this.pathOutputFile.toFile());
                        return;
                    }
                    if (this.writerOutput == null) throw new RuntimeException("pathOutputFile and writerOutput have not been set.");
                    marshaller.marshal((Object)referenceGraphVisitorReport.report, this.writerOutput);
                    return;
                }
                catch (JAXBException je) {
                    throw new RuntimeException(je);
                }
            }
            case JSON: {
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    if (this.pathOutputFile != null) {
                        objectMapper.writeValue(this.pathOutputFile.toFile(), (Object)referenceGraphVisitorReport.report);
                        return;
                    }
                    if (this.writerOutput == null) throw new RuntimeException("pathOutputFile and writerOutput have not been set.");
                    objectMapper.writeValue(this.writerOutput, (Object)referenceGraphVisitorReport.report);
                    return;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            case TEXT: {
                try {
                    Writer writer;
                    if (this.pathOutputFile != null) {
                        writer = new BufferedWriter(new FileWriter(this.pathOutputFile.toFile()));
                    } else {
                        if (this.writerOutput == null) throw new RuntimeException("pathOutputFile and writerOutput have not been set.");
                        writer = this.writerOutput;
                    }
                    referenceGraphVisitorReport.report.writeTextReport(writer);
                    if (this.pathOutputFile == null) return;
                    writer.close();
                    return;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            default: {
                throw new RuntimeException("Invalid output format " + (Object)((Object)this.outputFormat) + '.');
            }
        }
    }

    private class ReferenceGraphVisitorReport
    implements ReferenceGraph.Visitor {
        Report report = new Report();
        Map<ModuleVersion, ReportReferenceGraphNode> mapReportReferenceGraphNode;
        int nextBookmarkIndex;
        Map<NodePath, ReportModule> mapReportModule;
        Set<NodePath> setNodePathMatched;

        public ReferenceGraphVisitorReport() {
            if (ReferenceGraphReport.this.indIncludeReferenceGraph) {
                this.mapReportReferenceGraphNode = new HashMap<ModuleVersion, ReportReferenceGraphNode>();
                this.nextBookmarkIndex = 1;
                this.report.listReportReference = new ArrayList<ReportReference>();
            }
            if (ReferenceGraphReport.this.indIncludeModules) {
                this.mapReportModule = new HashMap<NodePath, ReportModule>();
                this.setNodePathMatched = new HashSet<NodePath>();
                this.report.listReportModule = new ArrayList<ReportModule>();
            }
        }

        public ReferenceGraph.VisitControl visit(ReferenceGraph referenceGraph, ReferencePath referencePath, EnumSet<ReferenceGraph.VisitAction> enumSetVisitAction) {
            if (enumSetVisitAction.contains(ReferenceGraph.VisitAction.VISIT)) {
                if (ReferenceGraphReport.this.indIncludeReferenceGraph) {
                    boolean indReportReferenceGraphNodeAlreadyExists;
                    String extraInfo;
                    List<ReportReference> listReportReference;
                    if (referencePath.size() == 1) {
                        listReportReference = this.report.listReportReference;
                        extraInfo = null;
                    } else {
                        Reference referenceParent = referencePath.get(referencePath.size() - 2);
                        ReportReferenceGraphNode reportReferenceGraphNodeParent = this.mapReportReferenceGraphNode.get(referenceParent.getModuleVersion());
                        if (reportReferenceGraphNodeParent == null) {
                            throw new RuntimeException("Parent ReportReferenceGraphNode could not be found corresponding to ModuleVersion " + referenceParent.getModuleVersion() + '.');
                        }
                        if (reportReferenceGraphNodeParent.listReportReference == null) {
                            reportReferenceGraphNodeParent.listReportReference = new ArrayList<ReportReference>();
                        }
                        listReportReference = reportReferenceGraphNodeParent.listReportReference;
                        Reference referenceLeaf = referencePath.getLeafReference();
                        Object objectImplData = referenceLeaf.getImplData();
                        String string = extraInfo = objectImplData == null ? null : objectImplData.toString();
                        if (referenceLeaf.getArtifactGroupId() != null) {
                            extraInfo = extraInfo == null ? referenceLeaf.getArtifactGroupId().toString() + ':' + referenceLeaf.getArtifactVersion().toString() : extraInfo + ", " + referenceLeaf.getArtifactGroupId().toString() + ':' + referenceLeaf.getArtifactVersion().toString();
                        }
                    }
                    ModuleVersion moduleVersion = referencePath.getLeafModuleVersion();
                    ReportReferenceGraphNode reportReferenceGraphNode = this.mapReportReferenceGraphNode.get(moduleVersion);
                    if (reportReferenceGraphNode == null) {
                        if (enumSetVisitAction.contains(ReferenceGraph.VisitAction.REPEATED)) {
                            throw new RuntimeException("ReportReferenceGraphNode could not be found corresponding to ModuleVersion " + moduleVersion + '.');
                        }
                        reportReferenceGraphNode = new ReportReferenceGraphNode();
                        reportReferenceGraphNode.moduleVersion = moduleVersion;
                        this.mapReportReferenceGraphNode.put(moduleVersion, reportReferenceGraphNode);
                        indReportReferenceGraphNodeAlreadyExists = false;
                    } else {
                        indReportReferenceGraphNodeAlreadyExists = true;
                    }
                    ReportReference reportReference = new ReportReference();
                    if (!indReportReferenceGraphNodeAlreadyExists || ReferenceGraphReport.this.referenceGraphMode == ReferenceGraphMode.FULL_TREE) {
                        reportReference.reportReferenceGraphNode = reportReferenceGraphNode;
                    } else {
                        reportReference.moduleVersion = moduleVersion;
                        if (reportReferenceGraphNode.bookmark == null) {
                            reportReferenceGraphNode.bookmark = "REF-" + this.nextBookmarkIndex++;
                        }
                        reportReference.jumpToReferenceGraphNodeBookmark = reportReferenceGraphNode.bookmark;
                    }
                    reportReference.extraInfo = extraInfo;
                    listReportReference.add(reportReference);
                }
                if (ReferenceGraphReport.this.indIncludeModules) {
                    if (enumSetVisitAction.contains(ReferenceGraph.VisitAction.REPEATED)) {
                        return ReferenceGraph.VisitControl.CONTINUE;
                    }
                    ModuleVersion moduleVersion = referencePath.getLeafModuleVersion();
                    ReportModule reportModule = this.mapReportModule.get(moduleVersion.getNodePath());
                    if (reportModule == null) {
                        reportModule = new ReportModule();
                        reportModule.nodePathModule = moduleVersion.getNodePath();
                        reportModule.listReportVersion = new ArrayList<ReportVersion>();
                        this.mapReportModule.put(moduleVersion.getNodePath(), reportModule);
                        this.report.listReportModule.add(reportModule);
                    }
                    if (enumSetVisitAction.contains(ReferenceGraph.VisitAction.MATCHED)) {
                        this.setNodePathMatched.add(moduleVersion.getNodePath());
                    }
                    ReportVersion reportVersion = new ReportVersion();
                    reportVersion.version = moduleVersion.getVersion();
                    reportModule.listReportVersion.add(reportVersion);
                }
            }
            return ReferenceGraph.VisitControl.CONTINUE;
        }
    }

    public static enum ModuleFilter {
        ALL,
        ONLY_MULTIPLE_VERSIONS,
        ONLY_MATCHED;

    }

    public static enum ReferenceGraphMode {
        FULL_TREE,
        TREE_NO_REDUNDANCY;

    }

    public static enum OutputFormat {
        XML,
        JSON,
        TEXT;

    }
}

