/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.azyva.dragom.job.ReportReferenceGraphNode;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.support.MapModuleVersionXmlAdapter;
import org.azyva.dragom.model.support.ModuleVersionJsonConverter;
import org.azyva.dragom.util.Util;

@XmlAccessorType(value=XmlAccessType.NONE)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class ReportReference {
    @XmlElement(name="reference-graph-node")
    @JsonProperty(value="reference-graph-node")
    public ReportReferenceGraphNode reportReferenceGraphNode;
    @XmlElement(name="module-version", type=String.class)
    @XmlJavaTypeAdapter(value=MapModuleVersionXmlAdapter.class)
    @JsonProperty(value="module-version")
    @JsonSerialize(converter=ModuleVersionJsonConverter.class)
    public ModuleVersion moduleVersion;
    @XmlElement(name="jump-to-reference-graph-node-bookmark")
    @JsonProperty(value="jump-to-reference-graph-node-bookmark")
    public String jumpToReferenceGraphNodeBookmark;
    @XmlElement(name="extra-info")
    @JsonProperty(value="extra-info")
    public String extraInfo;

    ReportReference() {
    }

    public void writeTextReport(Writer writer, int level) {
        try {
            if (this.reportReferenceGraphNode != null) {
                this.reportReferenceGraphNode.writeTextReport(writer, level, this.extraInfo);
            } else {
                writer.append(Util.spaces(8 + level * 2));
                writer.append(this.moduleVersion.toString());
                if (this.extraInfo != null) {
                    writer.append(" (").append(this.extraInfo).append(')');
                }
                writer.append('\n');
                writer.append(Util.spaces(8 + level * 2 + 2)).append("-> ").append(this.jumpToReferenceGraphNodeBookmark).append('\n');
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

