/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.azyva.dragom.job.ReportReference;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.support.MapModuleVersionXmlAdapter;
import org.azyva.dragom.model.support.ModuleVersionJsonConverter;
import org.azyva.dragom.util.Util;

@XmlAccessorType(value=XmlAccessType.NONE)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class ReportReferenceGraphNode {
    @XmlElement(name="bookmark")
    @JsonProperty(value="bookmark")
    public String bookmark;
    @XmlElement(name="module-version", type=String.class)
    @XmlJavaTypeAdapter(value=MapModuleVersionXmlAdapter.class)
    @JsonProperty(value="module-version")
    @JsonSerialize(converter=ModuleVersionJsonConverter.class)
    public ModuleVersion moduleVersion;
    @XmlElementWrapper(name="references")
    @XmlElement(name="reference")
    @JsonProperty(value="references")
    public List<ReportReference> listReportReference;

    ReportReferenceGraphNode() {
    }

    public void writeTextReport(Writer writer, int level, String extraInfo) {
        try {
            if (this.bookmark != null) {
                writer.append(String.format("%-8s", this.bookmark));
            } else {
                writer.append(Util.spaces(8));
            }
            writer.append(Util.spaces(level * 2)).append(this.moduleVersion.toString());
            if (extraInfo != null) {
                writer.append(" (").append(extraInfo).append(')');
            }
            writer.append('\n');
            if (this.listReportReference != null) {
                for (ReportReference reportReference : this.listReportReference) {
                    reportReference.writeTextReport(writer, level + 1);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

