/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.support.MapVersionXmlAdapter;
import org.azyva.dragom.model.support.VersionJsonConverter;

@XmlAccessorType(value=XmlAccessType.NONE)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
class ReportVersion {
    @XmlElement(name="version", type=String.class)
    @XmlJavaTypeAdapter(value=MapVersionXmlAdapter.class)
    @JsonProperty(value="version")
    @JsonSerialize(converter=VersionJsonConverter.class)
    public Version version;
    @XmlElement(name="ind-most-recent-in-reference-graph")
    @JsonProperty(value="ind-most-recent-in-reference-graph")
    public Boolean indMostRecentInReferenceGraph;
    @XmlElement(name="ind-most-recent-in-scm")
    @JsonProperty(value="ind-most-recent-in-scm")
    public Boolean indMostRecentInScm;
    @XmlElementWrapper(name="reference-paths")
    @XmlElement(name="reference-path")
    @JsonProperty(value="reference-paths")
    public List<String> listReferencePathLiteral;

    ReportVersion() {
    }

    public void writeTextReport(Writer writer) {
        try {
            writer.append("  Version: ").append(this.version.toString()).append('\n');
            if (this.indMostRecentInReferenceGraph != null) {
                writer.append("    MostRecentInReferenceGraph: ").append(Boolean.toString(this.indMostRecentInReferenceGraph)).append('\n');
            }
            if (this.indMostRecentInScm != null) {
                writer.append("    MostRecentInScm: ").append(Boolean.toString(this.indMostRecentInScm)).append('\n');
            }
            if (this.listReferencePathLiteral != null) {
                writer.append("    ReferencePaths:\n");
                for (String referencePathLiteral : this.listReferencePathLiteral) {
                    writer.append("      ").append(referencePathLiteral).append('\n');
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

