/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.reference.ReferencePathMatcher;
import org.azyva.dragom.reference.ReferencePathMatcherByElement;
import org.azyva.dragom.reference.ReferencePathMatcherOr;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class RootManager {
    private static final String EXEC_CONTEXT_PROPERTY_PREFIX_ROOT_MODULE_VERSION = "ROOT_MODULE_VERSIONS.";
    private static final String EXEC_CONTEXT_PROPERTY_PREFIX_REFERENCE_PATH_MATCHER = "REFERENCE_PATH_MATCHER.";
    private static final String MSG_PATTERN_KEY_MODULE_DOES_NOT_EXIST = "MODULE_DOES_NOT_EXIST";
    private static final String MSG_PATTERN_KEY_VERSION_DOES_NOT_EXIST = "VERSION_DOES_NOT_EXIST";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(RootManager.class.getName() + "ResourceBundle");

    public static List<ModuleVersion> getListModuleVersion() {
        ExecContext execContext = ExecContextHolder.get();
        ArrayList<ModuleVersion> listModuleVersion = (ArrayList<ModuleVersion>)execContext.getTransientData(RootManager.class.getName() + ".ListModuleVersion");
        if (listModuleVersion == null) {
            listModuleVersion = new ArrayList<ModuleVersion>();
            int index = 1;
            do {
                String rootModuleVersion;
                if ((rootModuleVersion = execContext.getProperty(EXEC_CONTEXT_PROPERTY_PREFIX_ROOT_MODULE_VERSION + String.format("%03d", index))) != null) {
                    listModuleVersion.add(new ModuleVersion(rootModuleVersion));
                    continue;
                }
                index = 0;
            } while (index++ != 0);
            execContext.setTransientData(RootManager.class.getName() + ".ListModuleVersion", listModuleVersion);
        }
        return listModuleVersion;
    }

    public static boolean containsModuleVersion(ModuleVersion moduleVersion) {
        return RootManager.getListModuleVersion().contains(moduleVersion);
    }

    public static ModuleVersion getModuleVersion(NodePath nodePathModule) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        for (ModuleVersion moduleVersion : listModuleVersion) {
            if (!moduleVersion.getNodePath().equals((Object)nodePathModule)) continue;
            return moduleVersion;
        }
        return null;
    }

    public static boolean addModuleVersion(ModuleVersion moduleVersion, boolean indAllowDuplicateModule) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        if (listModuleVersion.contains(moduleVersion)) {
            return false;
        }
        if (!indAllowDuplicateModule) {
            for (int i = 0; i < listModuleVersion.size(); ++i) {
                if (!listModuleVersion.get(i).getNodePath().equals((Object)moduleVersion.getNodePath())) continue;
                return false;
            }
        }
        listModuleVersion.add(moduleVersion);
        RootManager.saveListModuleVersion();
        return true;
    }

    public static boolean removeModuleVersion(ModuleVersion moduleVersion) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        if (!listModuleVersion.contains(moduleVersion)) {
            return false;
        }
        listModuleVersion.remove(moduleVersion);
        RootManager.saveListModuleVersion();
        return true;
    }

    public static void removeAllModuleVersion() {
        RootManager.getListModuleVersion().clear();
        RootManager.saveListModuleVersion();
    }

    public static boolean replaceModuleVersion(ModuleVersion moduleVersionOrg, ModuleVersion moduleVersionNew) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        if (!listModuleVersion.contains(moduleVersionOrg)) {
            return false;
        }
        listModuleVersion.set(listModuleVersion.indexOf(moduleVersionOrg), moduleVersionNew);
        RootManager.saveListModuleVersion();
        return true;
    }

    public static boolean moveFirst(ModuleVersion moduleVersion) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        if (!listModuleVersion.contains(moduleVersion)) {
            return false;
        }
        listModuleVersion.remove(moduleVersion);
        listModuleVersion.add(0, moduleVersion);
        RootManager.saveListModuleVersion();
        return true;
    }

    public static boolean moveLast(ModuleVersion moduleVersion) {
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        if (!listModuleVersion.contains(moduleVersion)) {
            return false;
        }
        listModuleVersion.remove(moduleVersion);
        listModuleVersion.add(listModuleVersion.size(), moduleVersion);
        RootManager.saveListModuleVersion();
        return true;
    }

    public static void validateModuleVersion(ModuleVersion moduleVersion) {
        ExecContext execContext = ExecContextHolder.get();
        Model model = execContext.getModel();
        Module module = model.getModule(moduleVersion.getNodePath());
        if (module == null) {
            throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_MODULE_DOES_NOT_EXIST), moduleVersion));
        }
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        if (moduleVersion.getVersion() != null && !scmPlugin.isVersionExists(moduleVersion.getVersion())) {
            throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_VERSION_DOES_NOT_EXIST), moduleVersion));
        }
    }

    public static void saveListModuleVersion() {
        ExecContext execContext = ExecContextHolder.get();
        List<ModuleVersion> listModuleVersion = RootManager.getListModuleVersion();
        execContext.removeProperties(EXEC_CONTEXT_PROPERTY_PREFIX_ROOT_MODULE_VERSION);
        int index = 1;
        for (ModuleVersion moduleVersion : listModuleVersion) {
            execContext.setProperty(EXEC_CONTEXT_PROPERTY_PREFIX_ROOT_MODULE_VERSION + String.format("%03d", index++), moduleVersion.toString());
        }
    }

    public static ReferencePathMatcherOr getReferencePathMatcherOr() {
        ExecContext execContext = ExecContextHolder.get();
        ReferencePathMatcherOr referencePathMatcherOr = (ReferencePathMatcherOr)execContext.getTransientData(RootManager.class.getName() + ".ReferencePathMatcherOr");
        if (referencePathMatcherOr == null) {
            referencePathMatcherOr = new ReferencePathMatcherOr();
            int index = 1;
            do {
                String stringReferencePathMatcherByElement;
                if ((stringReferencePathMatcherByElement = execContext.getProperty(EXEC_CONTEXT_PROPERTY_PREFIX_REFERENCE_PATH_MATCHER + String.format("%03d", index))) != null) {
                    referencePathMatcherOr.addReferencePathMatcher((ReferencePathMatcher)new ReferencePathMatcherByElement(stringReferencePathMatcherByElement, execContext.getModel()));
                    continue;
                }
                index = 0;
            } while (index++ != 0);
            execContext.setTransientData(RootManager.class.getName() + ".ReferencePathMatcherOr", (Object)referencePathMatcherOr);
        }
        return referencePathMatcherOr;
    }

    public static void saveReferencePathMatcherOr() {
        ReferencePathMatcherOr referencePathMatcherOr = RootManager.getReferencePathMatcherOr();
        ExecContext execContext = ExecContextHolder.get();
        execContext.removeProperties(EXEC_CONTEXT_PROPERTY_PREFIX_REFERENCE_PATH_MATCHER);
        int index = 1;
        for (ReferencePathMatcher referencePathMatcher : referencePathMatcherOr.getListReferencePathMatcher()) {
            execContext.setProperty(EXEC_CONTEXT_PROPERTY_PREFIX_REFERENCE_PATH_MATCHER + String.format("%03d", index++), ((ReferencePathMatcherByElement)ReferencePathMatcherByElement.class.cast(referencePathMatcher)).toString());
        }
    }
}

