/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.job;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.WorkspaceExecContext;
import org.azyva.dragom.execcontext.plugin.CredentialStorePlugin;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.jenkins.JenkinsClient;
import org.azyva.dragom.job.BuildReferenceGraph;
import org.azyva.dragom.job.RootModuleVersionJobAbstractImpl;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.JenkinsJobInfoPlugin;
import org.azyva.dragom.reference.ReferenceGraph;
import org.azyva.dragom.reference.ReferencePath;
import org.azyva.dragom.util.ServiceLocator;

public class SetupJenkinsJobs
extends RootModuleVersionJobAbstractImpl {
    private static final String RUNTIME_PROPERTY_JENKINS_BASE_URL = "JENKINS_BASE_URL";
    private static final String RUNTIME_PROPERTY_JENKINS_USER = "JENKINS_USER";
    private static final String MSG_PATTERN_KEY_SKIPPING_NOT_DYNAMIC_VERSION = "SKIPPING_NOT_DYNAMIC_VERSION";
    private static final String MSG_PATTERN_KEY_VISITING_MODULE_VERSION = "VISITING_MODULE_VERSION";
    private static final String MSG_PATTERN_KEY_JOB_NEEDS_CREATING_OR_UPDATING = "JOB_NEEDS_CREATING_OR_UPDATING";
    private static final String MSG_PATTERN_KEY_FOLDER_NEED_CREATING = "FOLDER_NEED_CREATING";
    private static final String MSG_PATTERN_KEY_DELETING_UNREFERENCED_FOLDER = "DELETING_UNREFERENCED_FOLDER";
    private static final String MSG_PATTERN_KEY_DELETING_UNREFERENCED_JOB = "DELETING_UNREFERENCED_JOB";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SetupJenkinsJobs.class.getName() + "ResourceBundle");
    private static final String DEFAULT_ITEMS_CREATED_FILE = "jenkins-items-created.txt";
    private ExistingItemsCreatedFileMode existingItemsCreatedFileMode;
    private ItemsCreatedFileManager itemsCreatedFileManager = new ItemsCreatedFileManager(((WorkspaceExecContext)ExecContextHolder.get()).getPathMetadataDir().resolve("jenkins-items-created.txt"));
    private JenkinsClient jenkinsClient;

    public SetupJenkinsJobs(List<ModuleVersion> listModuleVersionRoot) {
        super(listModuleVersionRoot);
        String password;
        this.existingItemsCreatedFileMode = ExistingItemsCreatedFileMode.MERGE;
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        CredentialStorePlugin credentialStorePlugin = (CredentialStorePlugin)execContext.getExecContextPlugin(CredentialStorePlugin.class);
        final String jenkinsBaseUrl = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_JENKINS_BASE_URL);
        String user = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_JENKINS_USER);
        if (user != null && user.isEmpty()) {
            user = null;
            password = null;
        } else {
            CredentialStorePlugin.Credentials credentials = credentialStorePlugin.getCredentials(jenkinsBaseUrl, user, new CredentialStorePlugin.CredentialValidator(){

                public boolean validateCredentials(String resource, String user, String password) {
                    JenkinsClient jenkinsClient = ServiceLocator.getService(JenkinsClient.class);
                    jenkinsClient.setBaseUrl(jenkinsBaseUrl);
                    jenkinsClient.setUser(user);
                    jenkinsClient.setPassword(password);
                    return jenkinsClient.validateCredentials();
                }
            });
            user = credentials.user;
            password = credentials.password;
        }
        this.jenkinsClient = ServiceLocator.getService(JenkinsClient.class);
        this.jenkinsClient.setBaseUrl(jenkinsBaseUrl);
        this.jenkinsClient.setUser(user);
        this.jenkinsClient.setPassword(password);
    }

    public void setPathItemsCreatedFile(Path pathItemsCreatedFile) {
        this.itemsCreatedFileManager = new ItemsCreatedFileManager(pathItemsCreatedFile);
    }

    public void setExistingItemsCreatedFileMode(ExistingItemsCreatedFileMode existingItemsCreatedFileMode) {
        this.existingItemsCreatedFileMode = existingItemsCreatedFileMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performJob() {
        BuildReferenceGraph buildReferenceGraph = new BuildReferenceGraph(null, this.listModuleVersionRoot);
        buildReferenceGraph.setReferencePathMatcherProvided(this.getReferencePathMatcher());
        buildReferenceGraph.performJob();
        ReferenceGraph referenceGraph = buildReferenceGraph.getReferenceGraph();
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        if (this.itemsCreatedFileManager != null) {
            if (this.existingItemsCreatedFileMode == ExistingItemsCreatedFileMode.IGNORE) {
                this.itemsCreatedFileManager.save();
            } else {
                this.itemsCreatedFileManager.loadIfExists();
            }
        } else if (this.existingItemsCreatedFileMode != ExistingItemsCreatedFileMode.IGNORE) {
            throw new RuntimeException("ExistingItemsCreatedFileMode must be IGNORE when items created file not specified.");
        }
        ReferenceGraphVisitorSetupJob referenceGraphVisitorSetupJob = new ReferenceGraphVisitorSetupJob();
        try {
            referenceGraph.traverseReferenceGraph(null, false, ReferenceGraph.ReentryMode.NO_REENTRY, (ReferenceGraph.Visitor)referenceGraphVisitorSetupJob);
            if (this.existingItemsCreatedFileMode == ExistingItemsCreatedFileMode.REPLACE) {
                for (String folder : this.itemsCreatedFileManager.getSetFolderNotReferencedSinceLoaded()) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETING_UNREFERENCED_FOLDER), folder));
                    this.jenkinsClient.deleteItem(folder);
                    this.itemsCreatedFileManager.folderDeleted(folder);
                }
                for (String job : this.itemsCreatedFileManager.getSetJobNotReferencedSinceLoaded()) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETING_UNREFERENCED_JOB), job));
                    this.jenkinsClient.deleteItem(job);
                    this.itemsCreatedFileManager.jobDeleted(job);
                }
            } else if (this.existingItemsCreatedFileMode == ExistingItemsCreatedFileMode.REPLACE_DELETE_FOLDER_ONLY_IF_EMPTY) {
                for (String job : this.itemsCreatedFileManager.getSetJobNotReferencedSinceLoaded()) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETING_UNREFERENCED_JOB), job));
                    this.jenkinsClient.deleteItem(job);
                    this.itemsCreatedFileManager.jobDeleted(job);
                }
                for (String folder : this.itemsCreatedFileManager.getSetFolderNotReferencedSinceLoaded()) {
                    if (!this.jenkinsClient.isFolderEmpty(folder)) continue;
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETING_UNREFERENCED_FOLDER), folder));
                    this.jenkinsClient.deleteItem(folder);
                    this.itemsCreatedFileManager.folderDeleted(folder);
                }
            } else if (this.existingItemsCreatedFileMode == ExistingItemsCreatedFileMode.REPLACE_NO_DELETE_FOLDER) {
                for (String job : this.itemsCreatedFileManager.getSetJobNotReferencedSinceLoaded()) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DELETING_UNREFERENCED_JOB), job));
                    this.jenkinsClient.deleteItem(job);
                    this.itemsCreatedFileManager.jobDeleted(job);
                }
            }
        }
        finally {
            if (this.itemsCreatedFileManager != null) {
                this.itemsCreatedFileManager.save();
            }
        }
    }

    private class ReferenceGraphVisitorSetupJob
    implements ReferenceGraph.Visitor {
        public ReferenceGraph.VisitControl visit(ReferenceGraph referenceGraph, ReferencePath referencePath, EnumSet<ReferenceGraph.VisitAction> enumSetVisitAction) {
            String template;
            int indexJobName;
            if (!enumSetVisitAction.contains(ReferenceGraph.VisitAction.VISIT)) {
                return ReferenceGraph.VisitControl.CONTINUE;
            }
            ExecContext execContext = ExecContextHolder.get();
            UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
            Version version = referencePath.getLeafModuleVersion().getVersion();
            if (version.getVersionType() != VersionType.DYNAMIC) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(SetupJenkinsJobs.MSG_PATTERN_KEY_SKIPPING_NOT_DYNAMIC_VERSION), referencePath, referencePath.getLeafModuleVersion(), version));
                return ReferenceGraph.VisitControl.SKIP_CHILDREN;
            }
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(SetupJenkinsJobs.MSG_PATTERN_KEY_VISITING_MODULE_VERSION), referencePath, referencePath.getLeafModuleVersion()));
            Model model = execContext.getModel();
            Module module = model.getModule(referencePath.getLeafModuleVersion().getNodePath());
            JenkinsJobInfoPlugin jenkinsJobInfoPlugin = (JenkinsJobInfoPlugin)module.getNodePlugin(JenkinsJobInfoPlugin.class, null);
            String job = jenkinsJobInfoPlugin.getJobFullName(version);
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(SetupJenkinsJobs.MSG_PATTERN_KEY_JOB_NEEDS_CREATING_OR_UPDATING), referencePath.getLeafModuleVersion(), job));
            if (jenkinsJobInfoPlugin.isHandleParentFolderCreation() && (indexJobName = job.lastIndexOf(47)) != -1) {
                String folder = job.substring(0, indexJobName);
                JenkinsClient.ItemType itemType = SetupJenkinsJobs.this.jenkinsClient.getItemType(folder);
                if (itemType != null && itemType == JenkinsClient.ItemType.NOT_FOLDER) {
                    throw new RuntimeException("Unexpected type for item " + folder + '.');
                }
                if (itemType == null) {
                    userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(SetupJenkinsJobs.MSG_PATTERN_KEY_FOLDER_NEED_CREATING), referencePath.getLeafModuleVersion(), folder));
                    SetupJenkinsJobs.this.jenkinsClient.createSimpleFolder(folder);
                    if (SetupJenkinsJobs.this.itemsCreatedFileManager != null) {
                        SetupJenkinsJobs.this.itemsCreatedFileManager.folderCreated(folder);
                    }
                }
            }
            if ((template = jenkinsJobInfoPlugin.getTemplate()) != null) {
                Map mapTemplateParam = jenkinsJobInfoPlugin.getMapTemplateParam(referenceGraph, version);
                SetupJenkinsJobs.this.jenkinsClient.createUpdateJobFromTemplate(template, job, mapTemplateParam);
            } else {
                Reader readerConfig = jenkinsJobInfoPlugin.getReaderConfig(referenceGraph, version);
                SetupJenkinsJobs.this.jenkinsClient.createUpdateJob(job, readerConfig);
            }
            if (SetupJenkinsJobs.this.itemsCreatedFileManager != null) {
                SetupJenkinsJobs.this.itemsCreatedFileManager.jobCreated(job);
            }
            return ReferenceGraph.VisitControl.CONTINUE;
        }
    }

    private static class ItemsCreatedFileManager {
        Set<String> setFolderNotReferencedSinceLoaded;
        Set<String> setJobNotReferencedSinceLoaded;
        Set<String> setFolderCreated;
        Set<String> setJobCreated;
        Path pathItemsCreatedFile;
        boolean indModified;

        public ItemsCreatedFileManager(Path pathItemsCreatedFile) {
            this.pathItemsCreatedFile = pathItemsCreatedFile;
            this.setFolderNotReferencedSinceLoaded = new LinkedHashSet<String>();
            this.setJobNotReferencedSinceLoaded = new LinkedHashSet<String>();
            this.setFolderCreated = new LinkedHashSet<String>();
            this.setJobCreated = new LinkedHashSet<String>();
        }

        public boolean loadIfExists() {
            if (!this.pathItemsCreatedFile.toFile().isFile()) {
                return false;
            }
            try {
                String line;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.pathItemsCreatedFile.toFile()));
                while ((line = bufferedReader.readLine()) != null) {
                    if (line.charAt(line.length() - 1) == '/') {
                        line = line.substring(0, line.length() - 1);
                        this.setFolderCreated.add(line);
                        this.setFolderNotReferencedSinceLoaded.add(line);
                        continue;
                    }
                    this.setJobCreated.add(line);
                    this.setJobNotReferencedSinceLoaded.add(line);
                }
                bufferedReader.close();
                return true;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public void save() {
            try {
                if (this.indModified) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.pathItemsCreatedFile.toFile()));
                    for (String folder : this.setFolderCreated) {
                        bufferedWriter.write(folder);
                        bufferedWriter.write(47);
                        bufferedWriter.write(10);
                    }
                    for (String job : this.setJobCreated) {
                        bufferedWriter.write(job);
                        bufferedWriter.write(10);
                    }
                    bufferedWriter.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public void folderCreated(String folder) {
            this.indModified |= this.setFolderCreated.add(folder);
            this.setFolderNotReferencedSinceLoaded.remove(folder);
        }

        public void jobCreated(String job) {
            this.indModified |= this.setJobCreated.add(job);
            int indexJobName = job.lastIndexOf(47);
            if (indexJobName != -1) {
                this.setFolderNotReferencedSinceLoaded.remove(job.substring(0, indexJobName));
            }
        }

        public Set<String> getSetJobNotReferencedSinceLoaded() {
            return new LinkedHashSet<String>(this.setJobNotReferencedSinceLoaded);
        }

        public Set<String> getSetFolderNotReferencedSinceLoaded() {
            return new LinkedHashSet<String>(this.setFolderNotReferencedSinceLoaded);
        }

        public void jobDeleted(String job) {
            this.indModified |= this.setJobCreated.remove(job);
            this.setJobNotReferencedSinceLoaded.remove(job);
        }

        public void folderDeleted(String folder) {
            String job;
            this.indModified |= this.setFolderCreated.remove(folder);
            this.setFolderNotReferencedSinceLoaded.remove(folder);
            folder = folder + '/';
            Iterator<String> iteratorJob = this.setJobCreated.iterator();
            while (iteratorJob.hasNext()) {
                job = iteratorJob.next();
                if (!job.startsWith(folder)) continue;
                iteratorJob.remove();
                this.indModified = true;
            }
            iteratorJob = this.setJobNotReferencedSinceLoaded.iterator();
            while (iteratorJob.hasNext()) {
                job = iteratorJob.next();
                if (!job.startsWith(folder)) continue;
                iteratorJob.remove();
            }
        }
    }

    public static enum ExistingItemsCreatedFileMode {
        IGNORE,
        MERGE,
        REPLACE,
        REPLACE_DELETE_FOLDER_ONLY_IF_EMPTY,
        REPLACE_NO_DELETE_FOLDER;

    }
}

