/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.maven;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.model.ArtifactGroupId;

public class PomAggregation {
    Pom pomMain;
    Map<ArtifactGroupId, Pom> mapArtifactGroupIdPom = new LinkedHashMap<ArtifactGroupId, Pom>();

    public PomAggregation(Path pathMainPom) {
        this.pomMain = this.loadPom(pathMainPom);
    }

    private Pom loadPom(Path pathPom) {
        Pom pom = new Pom();
        pom.setPathPom(pathPom);
        pom.loadPom();
        this.mapArtifactGroupIdPom.put(new ArtifactGroupId(pom.getEffectiveGroupId(), pom.getArtifactId()), pom);
        for (String submodule : pom.getListSubmodule()) {
            this.loadPom(pathPom.getParent().resolve(submodule).resolve("pom.xml"));
        }
        return pom;
    }

    public Pom getPomMain() {
        return this.pomMain;
    }

    public Set<ArtifactGroupId> getSetArtifactGroupId() {
        return Collections.unmodifiableSet(this.mapArtifactGroupIdPom.keySet());
    }

    public Collection<Pom> getCollectionPom() {
        return Collections.unmodifiableCollection(this.mapArtifactGroupIdPom.values());
    }

    public Pom getPom(ArtifactGroupId artifactGroupId) {
        return this.mapArtifactGroupIdPom.get(artifactGroupId);
    }
}

