/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import org.azyva.dragom.model.config.impl.simple.SimplePropertyDefConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class MapXmlPropertyDefConfigAdapter
extends XmlAdapter<ListProperty, Map<String, SimplePropertyDefConfig>> {
    private static final Logger logger = LoggerFactory.getLogger(MapXmlPropertyDefConfigAdapter.class);

    public ListProperty marshal(Map<String, SimplePropertyDefConfig> mapPropertyDefConfigXml) {
        if (mapPropertyDefConfigXml == null || mapPropertyDefConfigXml.isEmpty()) {
            return null;
        }
        ArrayList<JAXBElement<String>> listProperty = new ArrayList<JAXBElement<String>>();
        for (SimplePropertyDefConfig xmlPropertyDefConfig : mapPropertyDefConfigXml.values()) {
            listProperty.add((JAXBElement<String>)new JAXBElement(new QName(xmlPropertyDefConfig.getName()), String.class, (Object)xmlPropertyDefConfig.getValue()));
        }
        return new ListProperty(listProperty);
    }

    public Map<String, SimplePropertyDefConfig> unmarshal(ListProperty listProperty) {
        LinkedHashMap<String, SimplePropertyDefConfig> mapPropertyDefConfigXml = new LinkedHashMap<String, SimplePropertyDefConfig>();
        if (listProperty.getListProperty() == null) {
            return mapPropertyDefConfigXml;
        }
        for (Node node : listProperty.getListProperty()) {
            try {
                Node attributeIndOnlyThisNode = node.getAttributes().getNamedItem("ind-only-this-node");
                SimplePropertyDefConfig simplePropertyDefConfig = new SimplePropertyDefConfig(node.getLocalName(), node.getFirstChild().getTextContent(), attributeIndOnlyThisNode == null ? false : Boolean.parseBoolean(attributeIndOnlyThisNode.getTextContent()));
                if (mapPropertyDefConfigXml.containsKey(node.getLocalName())) {
                    throw new RuntimeException("Duplicate property definition " + simplePropertyDefConfig + '.');
                }
                mapPropertyDefConfigXml.put(node.getLocalName(), simplePropertyDefConfig);
            }
            catch (Exception e) {
                logger.error("An exception was thrown in an XmlAdapter and JAXB silently discards exceptions in this context.", (Throwable)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return mapPropertyDefConfigXml;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ListProperty {
        @XmlAnyElement
        private List<JAXBElement<String>> listProperty;

        public ListProperty() {
        }

        public ListProperty(List<JAXBElement<String>> listProperty) {
            this.listProperty = listProperty;
        }

        public List<JAXBElement<String>> getListProperty() {
            return this.listProperty;
        }
    }
}

