/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.config.impl.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.azyva.dragom.model.config.DuplicateNodeException;
import org.azyva.dragom.model.config.MutableNodeConfig;
import org.azyva.dragom.model.config.NodeConfig;
import org.azyva.dragom.model.config.NodeConfigTransferObject;
import org.azyva.dragom.model.config.OptimisticLockException;
import org.azyva.dragom.model.config.OptimisticLockHandle;
import org.azyva.dragom.model.config.PluginDefConfig;
import org.azyva.dragom.model.config.PluginKey;
import org.azyva.dragom.model.config.PropertyDefConfig;
import org.azyva.dragom.model.config.impl.simple.SimpleNodeConfigTransferObject;
import org.azyva.dragom.model.config.impl.xml.MapXmlPluginDefConfigAdapter;
import org.azyva.dragom.model.config.impl.xml.MapXmlPropertyDefConfigAdapter;
import org.azyva.dragom.model.config.impl.xml.XmlClassificationNodeConfig;
import org.azyva.dragom.model.config.impl.xml.XmlConfig;
import org.azyva.dragom.model.config.impl.xml.XmlOptimisticLockHandle;
import org.azyva.dragom.model.plugin.NodePlugin;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class XmlNodeConfig
implements NodeConfig,
MutableNodeConfig {
    protected boolean indNew;
    private XmlClassificationNodeConfig xmlClassificationNodeConfigParent;
    protected int revision;
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="properties", type=MapXmlPropertyDefConfigAdapter.ListProperty.class)
    @XmlJavaTypeAdapter(value=MapXmlPropertyDefConfigAdapter.class)
    private Map<String, PropertyDefConfig> mapPropertyDefConfig;
    @XmlElement(name="plugins", type=MapXmlPluginDefConfigAdapter.ListPluginDefConfigXml.class)
    @XmlJavaTypeAdapter(value=MapXmlPluginDefConfigAdapter.class)
    private Map<PluginKey, PluginDefConfig> mapPluginDefConfig;

    XmlNodeConfig() {
        this.revision = 1;
    }

    XmlNodeConfig(XmlClassificationNodeConfig xmlClassificationNodeConfigParent) {
        this.indNew = true;
        this.xmlClassificationNodeConfigParent = xmlClassificationNodeConfigParent;
        this.revision = 1;
        this.mapPropertyDefConfig = new LinkedHashMap<String, PropertyDefConfig>();
        this.mapPluginDefConfig = new LinkedHashMap<PluginKey, PluginDefConfig>();
    }

    protected void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (!(parent instanceof XmlConfig) && (this.name == null || this.name.isEmpty())) {
            throw new RuntimeException("Node cannot have null or empty name. Parent: " + parent);
        }
        if (parent instanceof XmlClassificationNodeConfig) {
            this.xmlClassificationNodeConfigParent = (XmlClassificationNodeConfig)parent;
        }
        if (this.mapPropertyDefConfig == null) {
            this.mapPropertyDefConfig = Collections.emptyMap();
        }
        if (this.mapPluginDefConfig == null) {
            this.mapPluginDefConfig = Collections.emptyMap();
        }
    }

    public String getName() {
        return this.name;
    }

    public PropertyDefConfig getPropertyDefConfig(String name) {
        return this.mapPropertyDefConfig.get(name);
    }

    public boolean isPropertyExists(String name) {
        return this.mapPropertyDefConfig.containsKey(name);
    }

    public List<PropertyDefConfig> getListPropertyDefConfig() {
        return new ArrayList<PropertyDefConfig>(this.mapPropertyDefConfig.values());
    }

    public PluginDefConfig getPluginDefConfig(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.get(new PluginKey(classNodePlugin, pluginId));
    }

    public boolean isPluginDefConfigExists(Class<? extends NodePlugin> classNodePlugin, String pluginId) {
        return this.mapPluginDefConfig.containsKey(new PluginKey(classNodePlugin, pluginId));
    }

    public List<PluginDefConfig> getListPluginDefConfig() {
        return new ArrayList<PluginDefConfig>(this.mapPluginDefConfig.values());
    }

    public boolean isNew() {
        return this.indNew;
    }

    protected void checkOptimisticLock(OptimisticLockHandle optimisticLockHandle, boolean indRequireLock) {
        if (optimisticLockHandle != null) {
            if (optimisticLockHandle.isLocked()) {
                if (((XmlOptimisticLockHandle)optimisticLockHandle).getRevision() != this.revision) {
                    throw new OptimisticLockException();
                }
            } else {
                if (indRequireLock) {
                    throw new RuntimeException("Lock required.");
                }
                ((XmlOptimisticLockHandle)optimisticLockHandle).setRevision(this.revision);
            }
        }
    }

    public OptimisticLockHandle createOptimisticLockHandle(boolean indLock) {
        return new XmlOptimisticLockHandle(indLock ? this.revision : 0);
    }

    public boolean isOptimisticLockValid(OptimisticLockHandle optimisticLockHandle) {
        return ((XmlOptimisticLockHandle)optimisticLockHandle).getRevision() == this.revision;
    }

    public NodeConfigTransferObject getNodeConfigTransferObject(OptimisticLockHandle optimisticLockHandle) throws OptimisticLockException {
        this.checkOptimisticLock(optimisticLockHandle, false);
        SimpleNodeConfigTransferObject nodeConfigTransferObject = new SimpleNodeConfigTransferObject();
        nodeConfigTransferObject.setName(this.name);
        for (PropertyDefConfig propertyDefConfig : this.mapPropertyDefConfig.values()) {
            nodeConfigTransferObject.setPropertyDefConfig(propertyDefConfig);
        }
        for (PluginDefConfig pluginDefConfig : this.mapPluginDefConfig.values()) {
            nodeConfigTransferObject.setPluginDefConfig(pluginDefConfig);
        }
        return nodeConfigTransferObject;
    }

    protected void extractNodeConfigTransferObject(NodeConfigTransferObject nodeConfigTransferObject, OptimisticLockHandle optimisticLockHandle) throws DuplicateNodeException {
        this.checkOptimisticLock(optimisticLockHandle, !this.indNew);
        if (nodeConfigTransferObject.getName() == null && this.xmlClassificationNodeConfigParent != null) {
            throw new RuntimeException("Name of NodeConfigTrnmsferObject must not be null for non-root XmlClassificationNodeConfig.");
        }
        String previousName = this.name;
        this.name = nodeConfigTransferObject.getName();
        if (this.indNew) {
            if (this.xmlClassificationNodeConfigParent != null) {
                this.xmlClassificationNodeConfigParent.setXmlNodeConfigChild(this);
            }
        } else if (this.xmlClassificationNodeConfigParent != null && !this.name.equals(previousName)) {
            this.xmlClassificationNodeConfigParent.renameXmlNodeConfigChild(previousName, this.name);
        }
        this.mapPropertyDefConfig.clear();
        for (PropertyDefConfig propertyDefConfig : nodeConfigTransferObject.getListPropertyDefConfig()) {
            this.mapPropertyDefConfig.put(propertyDefConfig.getName(), propertyDefConfig);
        }
        this.mapPluginDefConfig.clear();
        for (PluginDefConfig pluginDefConfig : nodeConfigTransferObject.getListPluginDefConfig()) {
            this.mapPluginDefConfig.put(new PluginKey(pluginDefConfig.getClassNodePlugin(), pluginDefConfig.getPluginId()), pluginDefConfig);
        }
        if (!this.indNew) {
            ++this.revision;
        }
        if (optimisticLockHandle != null) {
            ((XmlOptimisticLockHandle)optimisticLockHandle).setRevision(this.revision);
        }
    }

    public void delete() {
        if (!this.indNew && this.xmlClassificationNodeConfigParent != null) {
            this.xmlClassificationNodeConfigParent.removeChildNodeConfig(this.name);
            this.xmlClassificationNodeConfigParent = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + "]";
    }
}

