/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.event.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.config.NodeType;
import org.azyva.dragom.model.event.ClassificationNodeEvent;
import org.azyva.dragom.model.event.ModuleEvent;
import org.azyva.dragom.model.event.NodeEvent;
import org.azyva.dragom.model.event.NodeEventListener;

public class EventManager {
    private Map<NodeEventListenerKey, List<NodeEventListenerEntry>> mapNodeEventListener;

    public <NodeEventClass extends NodeEvent> void registerListener(Node node, NodeEventListener<NodeEventClass> nodeEventListener, boolean indChildrenAlso) {
        Class<NodeEventClass> classNodeEvent;
        List<NodeEventListenerEntry> listNodeEventListenerEntry;
        if (this.mapNodeEventListener == null) {
            this.mapNodeEventListener = new HashMap<NodeEventListenerKey, List<NodeEventListenerEntry>>();
        }
        if ((listNodeEventListenerEntry = this.mapNodeEventListener.get(classNodeEvent = EventManager.getClassNodeEvent(nodeEventListener))) == null) {
            listNodeEventListenerEntry = new ArrayList<NodeEventListenerEntry>();
            this.mapNodeEventListener.put(new NodeEventListenerKey(node, classNodeEvent), listNodeEventListenerEntry);
        }
        listNodeEventListenerEntry.add(new NodeEventListenerEntry(nodeEventListener, indChildrenAlso));
    }

    public void raiseNodeEvent(NodeEvent nodeEvent) {
        if (nodeEvent instanceof ModuleEvent && nodeEvent.getNode().getNodeType() != NodeType.MODULE) {
            throw new RuntimeException("Module events must be raised on modules.");
        }
        if (nodeEvent instanceof ClassificationNodeEvent && nodeEvent.getNode().getNodeType() != NodeType.CLASSIFICATION) {
            throw new RuntimeException("Classification node events must be raised on modules.");
        }
        this.dispatchNodeEventParent(nodeEvent.getNode(), nodeEvent);
    }

    private <NodeEventClass extends NodeEvent> void dispatchNodeEventParent(Node node, NodeEventClass nodeEvent) {
        if (this.mapNodeEventListener != null) {
            for (Class<?> classNodeEvent = nodeEvent.getClass(); classNodeEvent != Object.class; classNodeEvent = classNodeEvent.getSuperclass()) {
                List<NodeEventListenerEntry> listNodeEventListenerEntry = this.mapNodeEventListener.get(new NodeEventListenerKey(node, (Class)NodeEvent.class.getClass().cast(classNodeEvent)));
                if (listNodeEventListenerEntry == null) continue;
                for (NodeEventListenerEntry nodeEventListenerEntry : listNodeEventListenerEntry) {
                    if (!nodeEventListenerEntry.isChildrenAlso() && nodeEvent.getNode() != node) continue;
                    nodeEventListenerEntry.getNodeEventListener().onEvent(nodeEvent);
                }
            }
        }
        if (node.getClassificationNodeParent() != null) {
            this.dispatchNodeEventParent((Node)node.getClassificationNodeParent(), nodeEvent);
        }
    }

    public static <NodeEventClass extends NodeEvent> Class<NodeEventClass> getClassNodeEvent(NodeEventListener<NodeEventClass> nodeEventListener) {
        Type[] arrayTypeInterface;
        Class<?> classNodeEventListener = nodeEventListener.getClass();
        for (Type typeInterface : arrayTypeInterface = classNodeEventListener.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(typeInterface instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)typeInterface).getRawType() != NodeEventListener.class) continue;
            Type[] types = parameterizedType.getActualTypeArguments();
            return (Class)types[0];
        }
        throw new RuntimeException("Node event class could not be inferred.");
    }

    private static class NodeEventListenerEntry {
        private NodeEventListener<? extends NodeEvent> nodeEventListener;
        private boolean indChildrenAlso;

        private NodeEventListenerEntry(NodeEventListener<? extends NodeEvent> nodeEventListener, boolean indChildrenAlso) {
            this.nodeEventListener = nodeEventListener;
            this.indChildrenAlso = indChildrenAlso;
        }

        public NodeEventListener<? extends NodeEvent> getNodeEventListener() {
            return this.nodeEventListener;
        }

        public boolean isChildrenAlso() {
            return this.indChildrenAlso;
        }
    }

    private static class NodeEventListenerKey {
        private Node node;
        private Class<? extends NodeEvent> classNodeEvent;

        private NodeEventListenerKey(Node node, Class<? extends NodeEvent> classNodeEvent) {
            this.node = node;
            this.classNodeEvent = classNodeEvent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.classNodeEvent.hashCode();
            result = 31 * result + this.node.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof NodeEventListenerKey)) {
                return false;
            }
            NodeEventListenerKey otherNodeEventListenerKey = (NodeEventListenerKey)other;
            if (this.classNodeEvent != otherNodeEventListenerKey.classNodeEvent) {
                return false;
            }
            return this.node.equals(otherNodeEventListenerKey.node);
        }
    }
}

