/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.impl.simple;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.azyva.dragom.model.ClassificationNode;
import org.azyva.dragom.model.MutableClassificationNode;
import org.azyva.dragom.model.MutableModule;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.NodeVisitor;
import org.azyva.dragom.model.config.ClassificationNodeConfig;
import org.azyva.dragom.model.config.DuplicateNodeException;
import org.azyva.dragom.model.config.ModuleConfig;
import org.azyva.dragom.model.config.MutableClassificationNodeConfig;
import org.azyva.dragom.model.config.NodeConfig;
import org.azyva.dragom.model.config.NodeConfigTransferObject;
import org.azyva.dragom.model.config.NodeType;
import org.azyva.dragom.model.config.OptimisticLockException;
import org.azyva.dragom.model.config.OptimisticLockHandle;
import org.azyva.dragom.model.impl.simple.SimpleModel;
import org.azyva.dragom.model.impl.simple.SimpleModule;
import org.azyva.dragom.model.impl.simple.SimpleNode;
import org.azyva.dragom.model.plugin.UndefinedDescendantNodeManagerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClassificationNode
extends SimpleNode
implements ClassificationNode,
MutableClassificationNode {
    private static final Logger logger = LoggerFactory.getLogger(SimpleClassificationNode.class);
    private Map<String, SimpleNode> mapSimpleNodeChild;

    SimpleClassificationNode(SimpleModel simpleModel) {
        super(simpleModel);
        this.mapSimpleNodeChild = new LinkedHashMap<String, SimpleNode>();
    }

    SimpleClassificationNode(ClassificationNodeConfig classificationNodeConfig, SimpleModel simpleModel) {
        super((NodeConfig)classificationNodeConfig, simpleModel);
    }

    SimpleClassificationNode(ClassificationNodeConfig classificationNodeConfig, SimpleClassificationNode simpleClassificationNodeParent) {
        super((NodeConfig)classificationNodeConfig, simpleClassificationNodeParent);
    }

    public NodeType getNodeType() {
        this.checkNotDeleted();
        return NodeType.CLASSIFICATION;
    }

    public List<Node> getListChildNode() {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        return new ArrayList<Node>(this.mapSimpleNodeChild.values());
    }

    public Node getNodeChild(String name) {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        return this.mapSimpleNodeChild.get(name);
    }

    private void createChildNodesFromConfig() {
        if (this.mapSimpleNodeChild == null) {
            this.mapSimpleNodeChild = new LinkedHashMap<String, SimpleNode>();
            List listNodeConfigChild = ((ClassificationNodeConfig)this.getNodeConfig()).getListChildNodeConfig();
            for (NodeConfig nodeConfigChild : listNodeConfigChild) {
                switch (nodeConfigChild.getNodeType()) {
                    case CLASSIFICATION: {
                        SimpleClassificationNode simpleClassificationNode = new SimpleClassificationNode((ClassificationNodeConfig)nodeConfigChild, this);
                        this.addNodeChild(simpleClassificationNode);
                        simpleClassificationNode.init();
                        break;
                    }
                    case MODULE: {
                        SimpleModule simpleModule = new SimpleModule((ModuleConfig)nodeConfigChild, this);
                        this.addNodeChild(simpleModule);
                        simpleModule.init();
                    }
                }
            }
        }
    }

    public boolean traverseNodeHierarchyDepthFirst(NodeType nodeTypeFilter, NodeVisitor nodeVisitor) {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        Set<Map.Entry<String, SimpleNode>> setMapEntry = this.mapSimpleNodeChild.entrySet();
        for (Map.Entry<String, SimpleNode> mapEntry : setMapEntry) {
            SimpleNode simpleNode = mapEntry.getValue();
            switch (simpleNode.getNodeType()) {
                case CLASSIFICATION: {
                    if (!((SimpleClassificationNode)simpleNode).traverseNodeHierarchyDepthFirst(nodeTypeFilter, nodeVisitor)) break;
                    return true;
                }
                case MODULE: {
                    if (nodeTypeFilter != null && nodeTypeFilter != NodeType.MODULE || !nodeVisitor.visitNode((Node)simpleNode)) break;
                    return true;
                }
            }
        }
        return (nodeTypeFilter == null || nodeTypeFilter == NodeType.CLASSIFICATION) && nodeVisitor.visitNode((Node)this);
    }

    void addNodeChild(SimpleNode simpleNode) {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        if (simpleNode.getClassificationNodeParent() != this) {
            throw new RuntimeException("The current node " + this + " is not the parent of the new node " + simpleNode + '.');
        }
        this.createChildNodesFromConfig();
        if (this.mapSimpleNodeChild.containsKey(simpleNode.getName())) {
            throw new RuntimeException("A child node with the same name " + simpleNode.getName() + " exists in classification node " + this + '.');
        }
        this.mapSimpleNodeChild.put(simpleNode.getName(), simpleNode);
    }

    SimpleClassificationNode getSimpleClassificationNodeChildDynamic(String name) {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        SimpleNode simpleNode = (SimpleNode)this.getNodeChild(name);
        if (simpleNode == null) {
            if (!this.isNodePluginExists(UndefinedDescendantNodeManagerPlugin.class, null)) {
                logger.trace("Dynamic creation request for child classification node " + name + " of parent classification node " + this + " denied since the UndefinedDescendantNodeManagerPlugin plugin is not defined for the node.");
                return null;
            }
            UndefinedDescendantNodeManagerPlugin undefinedDescendantNodeManagerPlugin = this.getNodePlugin(UndefinedDescendantNodeManagerPlugin.class, null);
            SimpleClassificationNode simpleClassificationNode = (SimpleClassificationNode)undefinedDescendantNodeManagerPlugin.requestClassificationNode(name);
            if (simpleClassificationNode == null) {
                logger.trace("Dynamic creation request for child classification node " + name + " of parent classification node " + this + " denied, probably because classification nodes must be preconfigured.");
            }
            return simpleClassificationNode;
        }
        if (simpleNode.getNodeType() == NodeType.CLASSIFICATION) {
            return (SimpleClassificationNode)simpleNode;
        }
        throw new RuntimeException("The child node " + name + " is not a classification node.");
    }

    SimpleModule getSimpleModuleChildDynamic(String name) {
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.DYNAMICALLY_CREATED) {
            throw new IllegalStateException("State must be CONFIG or DYNAMICALLY_BEING_COMPLETED. State: " + (Object)((Object)this.state));
        }
        SimpleNode simpleNode = (SimpleNode)this.getNodeChild(name);
        if (simpleNode == null) {
            if (!this.isNodePluginExists(UndefinedDescendantNodeManagerPlugin.class, null)) {
                logger.trace("Dynamic creation request for child module " + name + " of parent classification node " + this + " denied since the UndefinedDescendantNodeManagerPlugin plugin is not defined for the node.");
                return null;
            }
            UndefinedDescendantNodeManagerPlugin undefinedDescendantNodeManagerPlugin = this.getNodePlugin(UndefinedDescendantNodeManagerPlugin.class, null);
            SimpleModule module = (SimpleModule)undefinedDescendantNodeManagerPlugin.requestModule(name);
            if (module == null) {
                logger.trace("Dynamic creation request for child module " + name + " of parent classification node " + this + " denied, probably because the module does not exist in the SCM.");
            }
            return module;
        }
        if (simpleNode.getNodeType() == NodeType.MODULE) {
            return (SimpleModule)simpleNode;
        }
        throw new RuntimeException("The child node " + name + " is not a module.");
    }

    public void setNodeConfigTransferObject(NodeConfigTransferObject nodeConfigTransferObject, OptimisticLockHandle optimisticLockHandle) throws OptimisticLockException, DuplicateNodeException {
        boolean indConfigNew = this.state == SimpleNode.State.CONFIG_NEW;
        super.extractNodeConfigTransferObject(nodeConfigTransferObject, optimisticLockHandle);
        if (indConfigNew && this.getClassificationNodeParent() == null) {
            ((SimpleModel)this.getModel()).setSimpleClassificationNodeRoot(this);
        }
        this.state = SimpleNode.State.CONFIG;
        this.init();
    }

    void setSimpleNodeChild(String name, SimpleNode simpleNodeChild) {
        this.checkMutable();
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        if (this.mapSimpleNodeChild.containsKey(name)) {
            throw new RuntimeException("SimpleNode with name " + name + " already exists.");
        }
        this.mapSimpleNodeChild.put(name, simpleNodeChild);
    }

    void renameSimpleNodeChild(String currentName, String newName) throws DuplicateNodeException {
        this.checkMutable();
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        if (!this.mapSimpleNodeChild.containsKey(currentName)) {
            throw new RuntimeException("SimpleNode with current name " + currentName + " not found.");
        }
        if (this.mapSimpleNodeChild.containsKey(newName)) {
            throw new RuntimeException("SimpleNode with new name " + newName + " already exists.");
        }
        this.mapSimpleNodeChild.put(newName, this.mapSimpleNodeChild.remove(currentName));
    }

    void removeChildNode(String childNodeName) {
        this.checkMutable();
        if (this.state != SimpleNode.State.CONFIG && this.state != SimpleNode.State.CONFIG_NEW) {
            throw new IllegalStateException("State must be CONFIG or CONFIG_NEW. State: " + (Object)((Object)this.state));
        }
        this.createChildNodesFromConfig();
        if (this.mapSimpleNodeChild.remove(childNodeName) == null) {
            throw new RuntimeException("SimpleNode with name " + childNodeName + " not found.");
        }
    }

    public MutableClassificationNode createChildMutableClassificationNode() {
        this.checkMutable();
        this.checkNotDeleted();
        return new SimpleClassificationNode((ClassificationNodeConfig)((MutableClassificationNodeConfig)this.getNodeConfig()).createChildMutableClassificationNodeConfig(), this);
    }

    public MutableModule createChildMutableModule() {
        this.checkMutable();
        this.checkNotDeleted();
        return new SimpleModule((ModuleConfig)((MutableClassificationNodeConfig)this.getNodeConfig()).createChildMutableModuleConfig(), this);
    }

    @Override
    protected void cleanCaches(boolean indDelete) {
        if (this.mapSimpleNodeChild != null) {
            for (SimpleNode simpleNode : this.mapSimpleNodeChild.values()) {
                simpleNode.cleanCaches(indDelete);
            }
        }
        super.cleanCaches(indDelete);
    }
}

