/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.impl.simple;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ClassificationNode;
import org.azyva.dragom.model.ClassificationNodeBuilder;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.ModelNodeBuilderFactory;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleBuilder;
import org.azyva.dragom.model.MutableClassificationNode;
import org.azyva.dragom.model.MutableModel;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.NodeVisitor;
import org.azyva.dragom.model.config.ClassificationNodeConfig;
import org.azyva.dragom.model.config.Config;
import org.azyva.dragom.model.config.MutableConfig;
import org.azyva.dragom.model.config.NodeType;
import org.azyva.dragom.model.impl.simple.SimpleClassificationNode;
import org.azyva.dragom.model.impl.simple.SimpleClassificationNodeBuilder;
import org.azyva.dragom.model.impl.simple.SimpleModule;
import org.azyva.dragom.model.impl.simple.SimpleModuleBuilder;
import org.azyva.dragom.model.impl.simple.SimpleNode;
import org.azyva.dragom.model.plugin.ArtifactInfoPlugin;
import org.azyva.dragom.model.plugin.FindModuleByArtifactGroupIdPlugin;
import org.azyva.dragom.util.Util;

public class SimpleModel
implements Model,
ModelNodeBuilderFactory,
MutableModel {
    private static final String MODEL_PROPERTY_OPTIMISTIC_ARTIFACT_GROUP_ID_PRODUCED_MAPPING = "OPTIMISTIC_ARTIFACT_GROUP_ID_PRODUCED_MAPPING";
    private boolean indMutable;
    private Properties propertiesInit;
    private Config config;
    private SimpleClassificationNode simpleClassificationNodeRoot;
    private Map<ArtifactGroupId, SimpleModule> mapArtifactGroupIdModule;

    public SimpleModel(Config config, Properties propertiesInit) {
        this.propertiesInit = propertiesInit;
        this.config = config;
        this.indMutable = this.config instanceof MutableConfig;
        if (this.indMutable) {
            if (config.getClassificationNodeConfigRoot() != null) {
                this.simpleClassificationNodeRoot = new SimpleClassificationNode(config.getClassificationNodeConfigRoot(), this);
            }
        } else {
            if (config.getClassificationNodeConfigRoot() == null) {
                throw new RuntimeException("Root ClassificationNodeConfig must be specified.");
            }
            this.simpleClassificationNodeRoot = new SimpleClassificationNode(config.getClassificationNodeConfigRoot(), this);
        }
        this.mapArtifactGroupIdModule = new HashMap<ArtifactGroupId, SimpleModule>();
    }

    public Properties getInitProperties() {
        return this.propertiesInit;
    }

    public ClassificationNode getClassificationNodeRoot() {
        return this.simpleClassificationNodeRoot;
    }

    public ClassificationNode getClassificationNode(NodePath nodePath) {
        if (!nodePath.isPartial()) {
            throw new RuntimeException("Cannot get a classification node given a complete non-partial NodsePath " + nodePath + '.');
        }
        SimpleClassificationNode simpleClassificationNodeCurrent = this.simpleClassificationNodeRoot;
        for (int i = 0; i < nodePath.getNodeCount(); ++i) {
            if ((simpleClassificationNodeCurrent = simpleClassificationNodeCurrent.getSimpleClassificationNodeChildDynamic(nodePath.getNodeName(i))) != null) continue;
            return null;
        }
        return simpleClassificationNodeCurrent;
    }

    public Module getModule(NodePath nodePath) {
        if (nodePath.isPartial()) {
            throw new RuntimeException("Cannot get a module given a partial NodsePath " + nodePath + '.');
        }
        SimpleClassificationNode classificationNode = (SimpleClassificationNode)this.getClassificationNode(nodePath.getNodePathParent());
        if (classificationNode == null) {
            return null;
        }
        return classificationNode.getSimpleModuleChildDynamic(nodePath.getModuleName());
    }

    public Module findModuleByArtifactGroupId(ArtifactGroupId artifactGroupId) {
        if (this.mapArtifactGroupIdModule.containsKey(artifactGroupId)) {
            return this.mapArtifactGroupIdModule.get(artifactGroupId);
        }
        FindModuleByArtifactGroupIdModuleNodeVisitor findModuleByArtifactGroupIdModuleNodeVisitor = new FindModuleByArtifactGroupIdModuleNodeVisitor(artifactGroupId);
        this.simpleClassificationNodeRoot.traverseNodeHierarchyDepthFirst(NodeType.MODULE, findModuleByArtifactGroupIdModuleNodeVisitor);
        SimpleModule moduleFound = (SimpleModule)findModuleByArtifactGroupIdModuleNodeVisitor.getModuleFound();
        if (moduleFound != null) {
            this.mapArtifactGroupIdModule.put(artifactGroupId, moduleFound);
            return moduleFound;
        }
        FindModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor findModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor = new FindModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor(artifactGroupId);
        this.simpleClassificationNodeRoot.traverseNodeHierarchyDepthFirst(NodeType.CLASSIFICATION, findModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor);
        moduleFound = (SimpleModule)findModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor.getModuleFound();
        if (moduleFound != null) {
            this.mapArtifactGroupIdModule.put(artifactGroupId, moduleFound);
            return moduleFound;
        }
        this.mapArtifactGroupIdModule.put(artifactGroupId, null);
        return null;
    }

    public ClassificationNodeBuilder createClassificationNodeBuilder() {
        return new SimpleClassificationNodeBuilder(this);
    }

    public ModuleBuilder createModuleBuilder() {
        return new SimpleModuleBuilder(this);
    }

    void setSimpleClassificationNodeRoot(SimpleClassificationNode simpleClassificationNodeRoot) {
        if (!this.indMutable) {
            throw new IllegalStateException("SimpleModel must be mutable.");
        }
        if (this.simpleClassificationNodeRoot != null && simpleClassificationNodeRoot != null) {
            throw new RuntimeException("Replacing the root SimpleClassificationNode is not allowed.");
        }
        this.simpleClassificationNodeRoot = simpleClassificationNodeRoot;
    }

    public MutableClassificationNode createMutableClassificationNodeRoot() {
        if (!this.indMutable) {
            throw new IllegalStateException("SimpleModel must be mutable.");
        }
        return new SimpleClassificationNode((ClassificationNodeConfig)((MutableConfig)this.config).createMutableClassificationNodeConfigRoot(), this);
    }

    void cleanCaches(SimpleNode simpleNode) {
        if (simpleNode.getNodeType() == NodeType.MODULE) {
            Iterator<Map.Entry<ArtifactGroupId, SimpleModule>> iteratorArtifactGroupIdModule = this.mapArtifactGroupIdModule.entrySet().iterator();
            while (iteratorArtifactGroupIdModule.hasNext()) {
                Map.Entry<ArtifactGroupId, SimpleModule> mapEntry = iteratorArtifactGroupIdModule.next();
                if (mapEntry.getValue() != simpleNode) continue;
                iteratorArtifactGroupIdModule.remove();
            }
        }
    }

    private static class FindModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor
    implements NodeVisitor {
        private ArtifactGroupId artifactGroupId;
        private Module moduleFound;

        public FindModuleThroughClassificationNodeByArtifactGroupIdClassificationNodeVisitor(ArtifactGroupId artifactGroupId) {
            this.artifactGroupId = artifactGroupId;
        }

        public Module getModuleFound() {
            return this.moduleFound;
        }

        public boolean visitNode(Node node) {
            Module modulePossiblyFound = null;
            if (!node.isNodePluginExists(FindModuleByArtifactGroupIdPlugin.class, null)) {
                return false;
            }
            FindModuleByArtifactGroupIdPlugin findModuleByArtifactGroupIdPlugin = (FindModuleByArtifactGroupIdPlugin)node.getNodePlugin(FindModuleByArtifactGroupIdPlugin.class, null);
            List listNodePath = findModuleByArtifactGroupIdPlugin.getListModulePossiblyProduceArtifactGroupId(this.artifactGroupId);
            if (listNodePath == null) {
                return false;
            }
            for (NodePath nodePath : listNodePath) {
                ArtifactInfoPlugin artifactInfoPlugin;
                Module module = node.getModel().getModule(nodePath);
                if (module == null || (artifactInfoPlugin = (ArtifactInfoPlugin)module.getNodePlugin(ArtifactInfoPlugin.class, null)) == null) continue;
                if (artifactInfoPlugin.isArtifactGroupIdProduced(this.artifactGroupId)) {
                    if (this.moduleFound != null) {
                        throw new RuntimeException("More than one module produces the same ArtifactGroupId " + this.artifactGroupId + ". The first one encountered was " + this.moduleFound + ". The one just encountered is " + module + '.');
                    }
                    this.moduleFound = module;
                    if (Util.isNotNullAndTrue(module.getProperty(SimpleModel.MODEL_PROPERTY_OPTIMISTIC_ARTIFACT_GROUP_ID_PRODUCED_MAPPING))) break;
                }
                if (!artifactInfoPlugin.isArtifactGroupIdPossiblyProduced(this.artifactGroupId) || modulePossiblyFound != null) continue;
                modulePossiblyFound = module;
                if (!Util.isNotNullAndTrue(module.getProperty(SimpleModel.MODEL_PROPERTY_OPTIMISTIC_ARTIFACT_GROUP_ID_PRODUCED_MAPPING))) continue;
                break;
            }
            if (modulePossiblyFound != null) {
                if (this.moduleFound != null && this.moduleFound != modulePossiblyFound) {
                    throw new RuntimeException("More than one module produces the same ArtifactGroupId " + this.artifactGroupId + ". The first one encountered was " + this.moduleFound + ". The one just encountered is " + modulePossiblyFound + '.');
                }
                this.moduleFound = modulePossiblyFound;
            }
            return false;
        }
    }

    private static class FindModuleByArtifactGroupIdModuleNodeVisitor
    implements NodeVisitor {
        private ArtifactGroupId artifactGroupId;
        private Module moduleFound;

        public FindModuleByArtifactGroupIdModuleNodeVisitor(ArtifactGroupId artifactGroupId) {
            this.artifactGroupId = artifactGroupId;
        }

        public Module getModuleFound() {
            return this.moduleFound;
        }

        public boolean visitNode(Node node) {
            if (!node.isNodePluginExists(ArtifactInfoPlugin.class, null)) {
                return false;
            }
            ArtifactInfoPlugin artifactInfoPlugin = (ArtifactInfoPlugin)node.getNodePlugin(ArtifactInfoPlugin.class, null);
            if (artifactInfoPlugin.isArtifactGroupIdProduced(this.artifactGroupId)) {
                if (this.moduleFound != null) {
                    throw new RuntimeException("More than one module produces the same ArtifactGroupId " + this.artifactGroupId + ". The first one encountered was " + this.moduleFound + ". The one just encountered is " + node + '.');
                }
                this.moduleFound = (Module)node;
            }
            return false;
        }
    }
}

