/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.maven.PomAggregation;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.plugin.ArtifactVersionManagerPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;

public class MavenArtifactVersionManagerPluginImpl
extends ModulePluginAbstractImpl
implements ArtifactVersionManagerPlugin {
    public MavenArtifactVersionManagerPluginImpl(Module module) {
        super(module);
    }

    public ArtifactVersion getArtifactVersion(Path pathModuleWorkspace) {
        Pom pom = new Pom();
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        pom.setPathPom(pathPom);
        pom.loadPom();
        String version = pom.getVersion();
        if (version == null) {
            throw new RuntimeException("The version of the artifacts is not explicitely set within POM " + pathPom + " of module " + pathModuleWorkspace + ". Maven allows this (the version being inherited from the parent), but Dragom does not allow this for a top-level module.");
        }
        if (version.contains("${")) {
            throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ". This is not supported by Maven nor Dragom.");
        }
        return new ArtifactVersion(version);
    }

    public boolean setArtifactVersion(Path pathModuleWorkspace, ArtifactVersion artifactVersion) {
        Path pathPom = pathModuleWorkspace.resolve("pom.xml");
        PomAggregation pomAggregation = new PomAggregation(pathPom);
        String priorVersion = pomAggregation.getPomMain().getVersion();
        if (priorVersion == null) {
            throw new RuntimeException("The version of the artifacts is not explicitely set within POM " + pathPom + " of module " + pathModuleWorkspace + ". Maven allows this (the version being inherited from the parent), but Dragom does not allow this for a top-level module.");
        }
        if (priorVersion.contains("${")) {
            throw new RuntimeException("A property reference was found within version " + priorVersion + " in the POM " + pathPom + ". This is not supported by Maven nor Dragom.");
        }
        if (artifactVersion.toString().equals(priorVersion)) {
            return false;
        }
        Set<ArtifactGroupId> setArtifactGroupIdAggregation = pomAggregation.getSetArtifactGroupId();
        String newVersion = artifactVersion.toString();
        for (Pom pom : pomAggregation.getCollectionPom()) {
            ArtifactGroupId artifactGroupId;
            String version = pom.getVersion();
            if (version != null && version.contains("${")) {
                throw new RuntimeException("A property reference was found within version " + version + " in the POM " + pathPom + ". This is not supported by Maven nor Dragom.");
            }
            Pom.ReferencedArtifact referencedArtifactParent = pom.getParentReferencedArtifact();
            if (referencedArtifactParent != null) {
                if (referencedArtifactParent.getGroupId().contains("${") || referencedArtifactParent.getArtifactId().contains("${") || referencedArtifactParent.getVersion().contains("${")) {
                    throw new RuntimeException("A property reference was found within referenced parent artifact " + referencedArtifactParent + " in the POM " + pathPom + ". This is not supported by Maven nor Dragom.");
                }
                artifactGroupId = new ArtifactGroupId(referencedArtifactParent.getGroupId(), referencedArtifactParent.getArtifactId());
                if (setArtifactGroupIdAggregation.contains(artifactGroupId)) {
                    if (!referencedArtifactParent.getVersion().equals(priorVersion)) {
                        throw new RuntimeException("The parent " + referencedArtifactParent + " identified within " + pathPom + " is within the aggregation but its version does not match that of the main aggregator module " + pathModuleWorkspace + '.');
                    }
                    if (version != null && !version.equals(priorVersion)) {
                        throw new RuntimeException("The parent " + referencedArtifactParent + " identified within " + pathPom + " is within the aggregation rooted at " + pathModuleWorkspace + ", the module also specifies a version but this version does not match that of the parent.");
                    }
                    pom.setReferencedArtifactVersion(referencedArtifactParent, newVersion);
                }
            } else {
                if (version == null) {
                    throw new RuntimeException("The POM " + pathPom + " within the aggregation rooted at " + pathModuleWorkspace + " does not specify a parent and its version is not specified.");
                }
                if (!version.equals(priorVersion)) {
                    throw new RuntimeException("The version of the POM " + pathPom + " does not match that of the main aggregator module " + pathModuleWorkspace + '.');
                }
            }
            if (version != null) {
                pom.setVersion(newVersion);
            }
            List<Pom.ReferencedArtifact> listReferencedArtifact = pom.getListReferencedArtifact(EnumSet.of(Pom.ReferencedArtifactType.DEPENDENCY, Pom.ReferencedArtifactType.DEPENDENCY_MANAGEMENT, Pom.ReferencedArtifactType.PROFILE_DEPENDENCY, Pom.ReferencedArtifactType.PROFILE_DEPENDENCY_MANAGEMENT), null, null, null);
            for (Pom.ReferencedArtifact referencedArtifact : listReferencedArtifact) {
                String groupId = pom.resolveProperties(referencedArtifact.getGroupId(), null);
                String artifactId = pom.resolveProperties(referencedArtifact.getArtifactId(), null);
                if (groupId == null || artifactId == null || !setArtifactGroupIdAggregation.contains(artifactGroupId = new ArtifactGroupId(groupId, artifactId)) || referencedArtifact.getVersion().equals("${project.version}") || referencedArtifact.getVersion().equals("${pom.version}") || referencedArtifact.getVersion().equals("${version}")) continue;
                if (referencedArtifact.getVersion().contains("${")) {
                    throw new RuntimeException("A property reference (other than ${project.version}, ${pom.version} or ${version}) was found within version " + version + " in the POM " + pathPom + " for an artifact within the aggregation. This is not supported by Dragom.");
                }
                if (!referencedArtifact.getVersion().equals(priorVersion)) {
                    throw new RuntimeException("The referenced module " + referencedArtifact + " identified within " + pathPom + " is within the aggregation but its version does not match that of the main aggregator module " + pathModuleWorkspace + " and is not one of the property references ${project.version}, ${pom.version} or ${version}.");
                }
                pom.setReferencedArtifactVersion(referencedArtifact, newVersion);
            }
            pom.savePom();
        }
        return true;
    }
}

