/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import org.azyva.dragom.apiutil.ByReference;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectDynamicVersionPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.reference.ReferencePath;

public class PhaseSelectDynamicVersionPluginImpl
extends ModulePluginAbstractImpl
implements SelectDynamicVersionPlugin {
    public PhaseSelectDynamicVersionPluginImpl(Module module) {
        super(module);
    }

    public Version selectDynamicVersion(Version version, ByReference<Version> byReferenceVersionBase, ReferencePath referencePath) {
        if (version.getVersionType() == VersionType.DYNAMIC) {
            return version;
        }
        ScmPlugin scmPlugin = (ScmPlugin)this.getModule().getNodePlugin(ScmPlugin.class, null);
        ScmPlugin.BaseVersion baseVersion = scmPlugin.getBaseVersion(version);
        if (baseVersion == null) {
            throw new RuntimeException("Base version for version " + version + " of module " + this.getModule() + " could not be found.");
        }
        Version versionDynamicSelected = baseVersion.versionBase;
        if (versionDynamicSelected.getVersionType() != VersionType.DYNAMIC) {
            throw new RuntimeException("Base version " + versionDynamicSelected + " of current version " + version + " of module " + this.getModule() + " is not dynamic.");
        }
        return versionDynamicSelected;
    }
}

