/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.plugin.UserInteractionCallbackPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleVersion;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.VersionType;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.SelectDynamicVersionPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.AlwaysNeverAskUserResponse;
import org.azyva.dragom.util.RuntimeExceptionUserError;
import org.azyva.dragom.util.Util;

public abstract class SelectDynamicVersionPluginBaseImpl
extends ModulePluginAbstractImpl
implements SelectDynamicVersionPlugin {
    private static final String RUNTIME_PROPERTY_SPECIFIC_DYNAMIC_VERSION = "SPECIFIC_DYNAMIC_VERSION";
    private static final String RUNTIME_PROPERTY_CAN_REUSE_DYNAMIC_VERSION = "CAN_REUSE_DYNAMIC_VERSION";
    private static final String RUNTIME_PROPERTY_REUSE_DYNAMIC_VERSION = "REUSE_DYNAMIC_VERSION";
    private static final String RUNTIME_PROPERTY_SPECIFIC_BASE_VERSION = "SPECIFIC_BASE_VERSION";
    private static final String RUNTIME_PROPERTY_IND_USE_DEFAULT_VERSION_AS_BASE = "IND_USE_DEFAULT_VERSION_AS_BASE";
    private static final String MSG_PATTERN_KEY_DYNAMIC_VERSION_SPECIFIED = "DYNAMIC_VERSION_SPECIFIED";
    private static final String MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_SAME_AS_CURRENT = "SELECTED_DYNAMIC_VERSION_SAME_AS_CURRENT";
    private static final String MSG_PATTERN_KEY_DYNAMIC_VERSION_AUTOMATICALLY_REUSED = "DYNAMIC_VERSION_AUTOMATICALLY_REUSED";
    private static final String MSG_PATTERN_KEY_INPUT_DYNAMIC_VERSION = "INPUT_DYNAMIC_VERSION";
    private static final String MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_DYNAMIC_VERSION = "AUTOMATICALLY_REUSE_DYNAMIC_VERSION";
    private static final String MSG_PATTERN_KEY_BASE_VERSION_SPECIFIED = "BASE_VERSION_SPECIFIED";
    private static final String MSG_PATTERN_KEY_SPECIFIED_BASE_VERSION_DOES_NOT_EXIST = "SPECIFIED_BASE_VERSION_DOES_NOT_EXIST";
    private static final String MSG_PATTERN_KEY_USING_DEFAULT_VERSION_AS_BASE = "USING_DEFAULT_VERSION_AS_BASE";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle(SelectDynamicVersionPluginBaseImpl.class.getName() + "ResourceBundle");

    public SelectDynamicVersionPluginBaseImpl(Module module) {
        super(module);
    }

    protected Version handleSpecificDynamicVersion(Version version) {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        String stringSpecificDynamicVersion = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_SPECIFIC_DYNAMIC_VERSION);
        if (stringSpecificDynamicVersion != null) {
            Version versionDynamicSelected = new Version(stringSpecificDynamicVersion);
            if (versionDynamicSelected.getVersionType() != VersionType.DYNAMIC) {
                throw new RuntimeException("Version " + versionDynamicSelected + " must be dynamic.");
            }
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DYNAMIC_VERSION_SPECIFIED), new ModuleVersion(this.getModule().getNodePath(), version), versionDynamicSelected));
            if (versionDynamicSelected.equals((Object)version)) {
                userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_SAME_AS_CURRENT), new ModuleVersion(this.getModule().getNodePath(), version), versionDynamicSelected));
            }
            return versionDynamicSelected;
        }
        return null;
    }

    protected Version handleReuseDynamicVersion(Version version) {
        Version versionDynamicSelected;
        Version versionReuseDynamic;
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)ExecContextHolder.get().getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)ExecContextHolder.get().getExecContextPlugin(UserInteractionCallbackPlugin.class);
        Module module = this.getModule();
        AlwaysNeverAskUserResponse alwaysNeverAskUserResponseCanReuseDynamicVersion = AlwaysNeverAskUserResponse.valueOfWithAskDefault(runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_CAN_REUSE_DYNAMIC_VERSION));
        String runtimeProperty = runtimePropertiesPlugin.getProperty((Node)module, RUNTIME_PROPERTY_REUSE_DYNAMIC_VERSION);
        if (runtimeProperty != null) {
            versionReuseDynamic = new Version(runtimeProperty);
            if (versionReuseDynamic.getVersionType() != VersionType.DYNAMIC) {
                throw new RuntimeException("Version " + versionReuseDynamic + " must be dynamic.");
            }
        } else {
            versionReuseDynamic = null;
            if (alwaysNeverAskUserResponseCanReuseDynamicVersion.isAlways()) {
                alwaysNeverAskUserResponseCanReuseDynamicVersion = AlwaysNeverAskUserResponse.YES_ASK;
            }
        }
        if (alwaysNeverAskUserResponseCanReuseDynamicVersion.isAlways()) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_DYNAMIC_VERSION_AUTOMATICALLY_REUSED), new ModuleVersion(module.getNodePath(), version), versionReuseDynamic));
            versionDynamicSelected = versionReuseDynamic;
        } else {
            versionDynamicSelected = Util.getInfoVersion(VersionType.DYNAMIC, null, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_INPUT_DYNAMIC_VERSION), new ModuleVersion(module.getNodePath(), version)), versionReuseDynamic);
            runtimePropertiesPlugin.setProperty(null, RUNTIME_PROPERTY_REUSE_DYNAMIC_VERSION, versionDynamicSelected.toString());
            Util.getInfoAlwaysNeverAskUserResponseAndHandleAsk(runtimePropertiesPlugin, RUNTIME_PROPERTY_CAN_REUSE_DYNAMIC_VERSION, userInteractionCallbackPlugin, MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_AUTOMATICALLY_REUSE_DYNAMIC_VERSION), versionDynamicSelected));
        }
        if (versionDynamicSelected.equals((Object)version)) {
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SELECTED_DYNAMIC_VERSION_SAME_AS_CURRENT), new ModuleVersion(module.getNodePath(), version), versionDynamicSelected));
        }
        return versionDynamicSelected;
    }

    protected Version handleSpecificBaseVersion(Version versionDynamicSelected) {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        UserInteractionCallbackPlugin userInteractionCallbackPlugin = (UserInteractionCallbackPlugin)execContext.getExecContextPlugin(UserInteractionCallbackPlugin.class);
        Module module = this.getModule();
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        String stringSpecificBaseVersion = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_SPECIFIC_BASE_VERSION);
        if (stringSpecificBaseVersion != null) {
            Version versionBase = new Version(stringSpecificBaseVersion);
            if (!scmPlugin.isVersionExists(versionBase)) {
                throw new RuntimeExceptionUserError(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_SPECIFIED_BASE_VERSION_DOES_NOT_EXIST), this.getModule(), versionDynamicSelected, versionDynamicSelected, versionBase));
            }
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_BASE_VERSION_SPECIFIED), this.getModule(), versionDynamicSelected, versionBase));
            return versionBase;
        }
        if (Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_IND_USE_DEFAULT_VERSION_AS_BASE))) {
            Version versionBase = scmPlugin.getDefaultVersion();
            userInteractionCallbackPlugin.provideInfo(MessageFormat.format(resourceBundle.getString(MSG_PATTERN_KEY_USING_DEFAULT_VERSION_AS_BASE), this.getModule(), versionDynamicSelected, versionBase));
            return versionBase;
        }
        return null;
    }
}

