/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.util.ArrayList;
import java.util.List;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ClassificationNode;
import org.azyva.dragom.model.NodePath;
import org.azyva.dragom.model.plugin.FindModuleByArtifactGroupIdPlugin;
import org.azyva.dragom.model.plugin.impl.ClassificationNodePluginAbstractImpl;
import org.azyva.dragom.util.Util;

public class SimpleFindModuleByArtifactGroupIdPluginImpl
extends ClassificationNodePluginAbstractImpl
implements FindModuleByArtifactGroupIdPlugin {
    private static final String MODEL_PROPERTY_BASE_GROUP_ID = "BASE_GROUP_ID";
    private String groupId;

    public SimpleFindModuleByArtifactGroupIdPluginImpl(ClassificationNode classificationNode) {
        super(classificationNode);
        String baseGroupId = classificationNode.getProperty(MODEL_PROPERTY_BASE_GROUP_ID);
        this.groupId = baseGroupId == null ? Util.inferGroupIdSegmentFromNodePath(classificationNode.getNodePath()) : (classificationNode != classificationNode.getModel().getClassificationNodeRoot() ? baseGroupId + '.' + Util.inferGroupIdSegmentFromNodePath(classificationNode.getNodePath()) : baseGroupId);
    }

    public List<NodePath> getListModulePossiblyProduceArtifactGroupId(ArtifactGroupId artifactGroupId) {
        int lastDashPos;
        if (!artifactGroupId.getGroupId().equals(this.groupId)) {
            return null;
        }
        ArrayList<NodePath> listNodePath = new ArrayList<NodePath>();
        String artifactId = artifactGroupId.getArtifactId();
        do {
            listNodePath.add(new NodePath(this.getNode().getNodePath(), artifactId));
            lastDashPos = artifactId.lastIndexOf(45);
            if (lastDashPos == -1) continue;
            artifactId = artifactId.substring(0, lastDashPos);
        } while (lastDashPos != -1);
        return listNodePath;
    }
}

