/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.plugin.RuntimePropertiesPlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Node;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.JenkinsJobInfoPlugin;
import org.azyva.dragom.model.plugin.impl.ModulePluginAbstractImpl;
import org.azyva.dragom.util.Util;

public abstract class SimpleJenkinsJobInfoPluginBaseImpl
extends ModulePluginAbstractImpl
implements JenkinsJobInfoPlugin {
    private static final String RUNTIME_PROPERTY_JOBS_ROOT_FOLDER = "JENKINS_JOBS_ROOT_FOLDER";
    private static final String RUNTIME_PROPERTY_MODULE_SUBFOLDER = "JENKINS_MODULE_SUBFOLDER";
    private static final String RUNTIME_PROPERTY_PROJECT = "JENKINS_PROJECT";
    private static final String RUNTIME_PROPERTY_IND_INCLUDE_VERSION = "JENKINS_IND_INCLUDE_VERSION";

    public SimpleJenkinsJobInfoPluginBaseImpl(Module module) {
        super(module);
    }

    public String getJobFullName(Version versionDynamic) {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        String jobRootFolder = runtimePropertiesPlugin.getProperty(null, RUNTIME_PROPERTY_JOBS_ROOT_FOLDER);
        String moduleSubfolder = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_MODULE_SUBFOLDER);
        String project = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_PROJECT);
        boolean indIncludeVersion = Util.isNotNullAndTrue(runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_IND_INCLUDE_VERSION));
        StringBuilder stringBuilder = new StringBuilder();
        if (jobRootFolder != null) {
            stringBuilder.append(jobRootFolder);
        }
        if (moduleSubfolder != null) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append(moduleSubfolder);
        }
        if (stringBuilder.length() != 0) {
            stringBuilder.append('/');
        }
        if (project != null) {
            stringBuilder.append(project);
            if (!project.endsWith("/")) {
                stringBuilder.append('_');
            }
        }
        if (indIncludeVersion) {
            stringBuilder.append(versionDynamic.getVersion());
            stringBuilder.append('_');
        }
        stringBuilder.append(this.getModule().getName());
        return stringBuilder.toString();
    }

    public boolean isHandleParentFolderCreation() {
        ExecContext execContext = ExecContextHolder.get();
        RuntimePropertiesPlugin runtimePropertiesPlugin = (RuntimePropertiesPlugin)execContext.getExecContextPlugin(RuntimePropertiesPlugin.class);
        String project = runtimePropertiesPlugin.getProperty((Node)this.getModule(), RUNTIME_PROPERTY_PROJECT);
        return project != null && project.endsWith("/");
    }
}

