/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.azyva.dragom.execcontext.plugin.WorkspacePlugin;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.maven.Pom;
import org.azyva.dragom.maven.PomAggregation;
import org.azyva.dragom.model.ArtifactGroupId;
import org.azyva.dragom.model.ArtifactVersion;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.Version;
import org.azyva.dragom.model.plugin.ArtifactVersionMapperPlugin;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.util.RuntimeExceptionUserError;

public class SimplePomResolver
implements Pom.PomResolver {
    List<PomAggregation> listPomAggregation = new ArrayList<PomAggregation>();
    private Map<Gav, Pom> mapGavPom;
    Model model;

    public SimplePomResolver(PomAggregation pomAggregationInitial) {
        if (pomAggregationInitial != null) {
            this.listPomAggregation.add(pomAggregationInitial);
        }
        this.mapGavPom = new HashMap<Gav, Pom>();
        this.model = ExecContextHolder.get().getModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pom resolve(String groupId, String artifactId, String stringVersion) {
        PomAggregation pomAggregation;
        Path pathModuleWorkspace;
        ArtifactGroupId artifactGroupId = new ArtifactGroupId(groupId, artifactId);
        Gav gav = new Gav(artifactGroupId, stringVersion);
        Pom pom = this.mapGavPom.get(gav);
        if (pom != null) {
            return pom;
        }
        for (PomAggregation pomAggregation2 : this.listPomAggregation) {
            pom = pomAggregation2.getPom(artifactGroupId);
            if (pom == null || !pom.getEffectiveVersion().equals(stringVersion)) continue;
            this.mapGavPom.put(gav, pom);
            return pom;
        }
        Module module = this.model.findModuleByArtifactGroupId(artifactGroupId);
        if (module == null) {
            throw new RuntimeException("Could not find Module corresponding to ArtifactGroupId " + artifactGroupId + '.');
        }
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        ArtifactVersionMapperPlugin artifactVersionMapperPlugin = (ArtifactVersionMapperPlugin)module.getNodePlugin(ArtifactVersionMapperPlugin.class, null);
        WorkspacePlugin workspacePlugin = (WorkspacePlugin)ExecContextHolder.get().getExecContextPlugin(WorkspacePlugin.class);
        Version version = artifactVersionMapperPlugin.mapArtifactVersionToVersion(new ArtifactVersion(stringVersion));
        try {
            pathModuleWorkspace = scmPlugin.checkoutSystem(version);
        }
        catch (RuntimeExceptionUserError reue) {
            throw reue;
        }
        catch (RuntimeException re) {
            throw new RuntimeException("Could not checkout Version " + version + " of Module " + module + '.', re);
        }
        try {
            pomAggregation = new PomAggregation(pathModuleWorkspace.resolve("pom.xml"));
        }
        finally {
            workspacePlugin.releaseWorkspaceDir(pathModuleWorkspace);
        }
        this.listPomAggregation.add(pomAggregation);
        pom = pomAggregation.getPom(artifactGroupId);
        this.mapGavPom.put(gav, pom);
        return pom;
    }

    private static class Gav {
        ArtifactGroupId artifactGroupId;
        String version;

        public Gav(ArtifactGroupId artifactGroupId, String version) {
            this.artifactGroupId = artifactGroupId;
            this.version = version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.artifactGroupId.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            Gav gavOther = (Gav)other;
            return this.artifactGroupId.equals((Object)gavOther.artifactGroupId) && this.version.equals(gavOther.version);
        }
    }
}

