/*
 * Decompiled with CFR 0.152.
 */
package org.azyva.dragom.model.plugin.impl;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import org.azyva.dragom.execcontext.ExecContext;
import org.azyva.dragom.execcontext.support.ExecContextHolder;
import org.azyva.dragom.model.ClassificationNode;
import org.azyva.dragom.model.Model;
import org.azyva.dragom.model.ModelNodeBuilderFactory;
import org.azyva.dragom.model.Module;
import org.azyva.dragom.model.ModuleBuilder;
import org.azyva.dragom.model.plugin.ScmPlugin;
import org.azyva.dragom.model.plugin.UndefinedDescendantNodeManagerPlugin;
import org.azyva.dragom.model.plugin.impl.ClassificationNodePluginAbstractImpl;
import org.azyva.dragom.util.Util;
import org.azyva.dragom.util.WormFile;

public class UndefinedDescendantNodeManagerSimpleDynamicModulePluginImpl
extends ClassificationNodePluginAbstractImpl
implements UndefinedDescendantNodeManagerPlugin {
    private static final String INIT_PROPERTY_IND_CACHE_MODULE_EXISTENCE = "IND_CACHE_MODULE_EXISTENCE";
    private static final String INIT_PROPERTY_MODULE_EXISTENCE_CACHE_FILE = "MODULE_EXISTENCE_CACHE_FILE";
    private static final String TRANSIENT_DATA_MODULE_EXISTENCE_CACHE = UndefinedDescendantNodeManagerSimpleDynamicModulePluginImpl.class.getName() + ".ModuleExistenceCache";
    private static final String TRANSIENT_DATA_MODULE_EXISTENCE_CACHE_FILE = UndefinedDescendantNodeManagerSimpleDynamicModulePluginImpl.class.getName() + ".ModuleExistenceCacheFile";

    public UndefinedDescendantNodeManagerSimpleDynamicModulePluginImpl(ClassificationNode classificationNode) {
        super(classificationNode);
    }

    public ClassificationNode requestClassificationNode(String name) {
        return null;
    }

    public Module requestModule(String name) {
        Model model = this.getClassificationNode().getModel();
        if (!(model instanceof ModelNodeBuilderFactory)) {
            return null;
        }
        ModelNodeBuilderFactory modelNodeBuilderFactory = (ModelNodeBuilderFactory)model;
        ModuleBuilder moduleBuilder = modelNodeBuilderFactory.createModuleBuilder();
        moduleBuilder.setClassificationNodeParent(this.getClassificationNode());
        moduleBuilder.setName(name);
        Module module = (Module)moduleBuilder.getPartial();
        if (!this.isModuleExists(module)) {
            return null;
        }
        return (Module)moduleBuilder.create();
    }

    private boolean isModuleExists(Module module) {
        ExecContext execContext = ExecContextHolder.get();
        if (Util.isNotNullAndTrue(execContext.getInitProperty(INIT_PROPERTY_IND_CACHE_MODULE_EXISTENCE))) {
            String stringBoolean;
            WormFile.AccessHandle accessHandle;
            WormFile.WormFileCache wormFileCacheModuleExistanceCache;
            Properties propertiesModuleExist = (Properties)execContext.getTransientData(TRANSIENT_DATA_MODULE_EXISTENCE_CACHE);
            if (propertiesModuleExist == null) {
                String moduleExistenceCacheFile = execContext.getInitProperty(INIT_PROPERTY_MODULE_EXISTENCE_CACHE_FILE);
                if (moduleExistenceCacheFile == null) {
                    throw new RuntimeException("Initialization property MODULE_EXISTENCE_CACHE_FILE is not defined.");
                }
                moduleExistenceCacheFile = moduleExistenceCacheFile.replaceAll("~", Matcher.quoteReplacement(System.getProperty("user.home")));
                wormFileCacheModuleExistanceCache = WormFile.getCache(Paths.get(moduleExistenceCacheFile, new String[0]));
                execContext.setTransientData(TRANSIENT_DATA_MODULE_EXISTENCE_CACHE_FILE, (Object)wormFileCacheModuleExistanceCache);
                propertiesModuleExist = new Properties();
                execContext.setTransientData(TRANSIENT_DATA_MODULE_EXISTENCE_CACHE, (Object)propertiesModuleExist);
            } else {
                wormFileCacheModuleExistanceCache = (WormFile.WormFileCache)execContext.getTransientData(TRANSIENT_DATA_MODULE_EXISTENCE_CACHE_FILE);
            }
            if (wormFileCacheModuleExistanceCache.isModified() && wormFileCacheModuleExistanceCache.isExists()) {
                accessHandle = wormFileCacheModuleExistanceCache.reserveAccess(false);
                try {
                    propertiesModuleExist.clear();
                    propertiesModuleExist.load(wormFileCacheModuleExistanceCache.getInputStream());
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    accessHandle.release();
                }
            }
            if ((stringBoolean = propertiesModuleExist.getProperty(module.getNodePath().toString())) == null) {
                boolean indModuleExists;
                accessHandle = wormFileCacheModuleExistanceCache.reserveAccess(true);
                try {
                    if (wormFileCacheModuleExistanceCache.isModified() && wormFileCacheModuleExistanceCache.isExists()) {
                        propertiesModuleExist.clear();
                        propertiesModuleExist.load(wormFileCacheModuleExistanceCache.getInputStream());
                    }
                    ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
                    indModuleExists = scmPlugin.isModuleExists();
                    propertiesModuleExist.setProperty(module.getNodePath().toString(), Boolean.toString(indModuleExists));
                    propertiesModuleExist.store(wormFileCacheModuleExistanceCache.getOutputStream(), null);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    accessHandle.release();
                }
                return indModuleExists;
            }
            return Boolean.parseBoolean(stringBoolean);
        }
        ScmPlugin scmPlugin = (ScmPlugin)module.getNodePlugin(ScmPlugin.class, null);
        return scmPlugin.isModuleExists();
    }
}

